/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import androidx.test.internal.runner.AndroidRunnerBuilder;
import androidx.test.internal.runner.EmptyTestRunner;
import androidx.test.internal.runner.ErrorReportingRunner;
import androidx.test.internal.runner.NonExecutingRunner;
import androidx.test.internal.runner.junit3.JUnit38ClassRunner;
import androidx.test.internal.runner.junit3.NonExecutingTestSuite;
import androidx.test.internal.util.AndroidRunnerBuilderUtil;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.builders.IgnoredClassRunner;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class AndroidLogOnlyBuilder
extends RunnerBuilder {
    private final AndroidRunnerBuilder builder;
    private final boolean ignoreSuiteMethods;
    private int runnerCount = 0;

    AndroidLogOnlyBuilder(boolean ignoreSuiteMethods, List<Class<? extends RunnerBuilder>> customRunnerBuilderClasses) {
        this.ignoreSuiteMethods = ignoreSuiteMethods;
        this.builder = new AndroidRunnerBuilder(this, ignoreSuiteMethods, 0L, customRunnerBuilderClasses);
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        ++this.runnerCount;
        if (AndroidRunnerBuilderUtil.isJUnit3Test(testClass)) {
            if (!AndroidRunnerBuilderUtil.hasJUnit3TestMethod(testClass)) {
                return new EmptyTestRunner(testClass);
            }
            return new JUnit38ClassRunner((Test)new NonExecutingTestSuite(testClass));
        }
        if (AndroidRunnerBuilderUtil.hasSuiteMethod(testClass)) {
            if (this.ignoreSuiteMethods) {
                return null;
            }
            Test test = SuiteMethod.testFromSuiteMethod(testClass);
            if (!(test instanceof TestSuite)) {
                throw new IllegalArgumentException(testClass.getName() + "#suite() did not return a TestSuite");
            }
            return new JUnit38ClassRunner((Test)new NonExecutingTestSuite((TestSuite)test));
        }
        int oldRunnerCount = this.runnerCount;
        Runner runner = this.builder.runnerForClass(testClass);
        if (null == runner) {
            return null;
        }
        if (runner instanceof org.junit.internal.runners.ErrorReportingRunner || runner instanceof ErrorReportingRunner) {
            return runner;
        }
        if (runner instanceof IgnoredClassRunner) {
            return runner;
        }
        if (this.runnerCount > oldRunnerCount) {
            return runner;
        }
        return new NonExecutingRunner(runner);
    }
}

