/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.util.Log;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class LogRunListener
extends RunListener {
    private static final String TAG = "TestRunner";

    public void testRunStarted(Description description) throws Exception {
        Log.i((String)TAG, (String)String.format("run started: %d tests", description.testCount()));
    }

    public void testRunFinished(Result result) throws Exception {
        Log.i((String)TAG, (String)String.format("run finished: %d tests, %d failed, %d ignored", result.getRunCount(), result.getFailureCount(), result.getIgnoreCount()));
    }

    public void testStarted(Description description) throws Exception {
        Log.i((String)TAG, (String)("started: " + description.getDisplayName()));
    }

    public void testFinished(Description description) throws Exception {
        Log.i((String)TAG, (String)("finished: " + description.getDisplayName()));
    }

    public void testFailure(Failure failure) throws Exception {
        Log.e((String)TAG, (String)("failed: " + failure.getDescription().getDisplayName()));
        Log.e((String)TAG, (String)"----- begin exception -----", (Throwable)failure.getException());
        Log.e((String)TAG, (String)"----- end exception -----");
    }

    public void testAssumptionFailure(Failure failure) {
        Log.e((String)TAG, (String)("assumption failed: " + failure.getDescription().getDisplayName()));
        Log.e((String)TAG, (String)"----- begin exception -----", (Throwable)failure.getException());
        Log.e((String)TAG, (String)"----- end exception -----");
    }

    public void testIgnored(Description description) throws Exception {
        Log.i((String)TAG, (String)("ignored: " + description.getDisplayName()));
    }
}

