/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.platform;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.ErrorInfo;
import androidx.test.services.events.TestRunInfo;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.platform.TestPlatformEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TestRunErrorEvent
extends TestPlatformEvent {
    @NonNull
    public final TestRunInfo testRun;
    @NonNull
    public final ErrorInfo error;
    @NonNull
    public final TimeStamp timeStamp;

    public TestRunErrorEvent(@NonNull TestRunInfo testRun, @NonNull ErrorInfo error, @NonNull TimeStamp timeStamp) {
        this.testRun = (TestRunInfo)Checks.checkNotNull((Object)testRun, (Object)"testRun cannot be null");
        this.error = (ErrorInfo)Checks.checkNotNull((Object)error, (Object)"error cannot be null");
        this.timeStamp = (TimeStamp)Checks.checkNotNull((Object)timeStamp, (Object)"timeStamp cannot be null");
    }

    TestRunErrorEvent(Parcel source) {
        this.testRun = new TestRunInfo(source);
        this.error = new ErrorInfo(source);
        this.timeStamp = new TimeStamp(source);
    }

    @Override
    TestPlatformEvent.EventType instanceType() {
        return TestPlatformEvent.EventType.TEST_RUN_ERROR;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.testRun.writeToParcel(parcel, i);
        this.error.writeToParcel(parcel, i);
        this.timeStamp.writeToParcel(parcel, i);
    }
}

