/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.internal.StackTrimmer;
import org.junit.runner.notification.Failure;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ErrorInfo
implements Parcelable {
    @Nullable
    public final String errorMessage;
    @Nullable
    public final String errorType;
    @NonNull
    public final String stackTrace;
    public static final Parcelable.Creator<ErrorInfo> CREATOR = new Parcelable.Creator<ErrorInfo>(){

        public ErrorInfo createFromParcel(Parcel source) {
            return new ErrorInfo(source);
        }

        public ErrorInfo[] newArray(int size) {
            return new ErrorInfo[size];
        }
    };

    public ErrorInfo(@Nullable String errorMessage, @Nullable String errorType, @NonNull String stackTrace) {
        this.errorMessage = errorMessage;
        this.errorType = errorType;
        this.stackTrace = (String)Checks.checkNotNull((Object)stackTrace, (Object)"stackTrace cannot be null");
    }

    public ErrorInfo(@NonNull Parcel source) {
        Checks.checkNotNull((Object)source, (Object)"source cannot be null");
        this.errorMessage = source.readString();
        this.errorType = source.readString();
        this.stackTrace = (String)Checks.checkNotNull((Object)source.readString(), (Object)"stackTrace cannot be null");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.errorMessage);
        parcel.writeString(this.errorType);
        parcel.writeString(this.stackTrace);
    }

    public static ErrorInfo createFromFailure(Failure failure) {
        return new ErrorInfo(StackTrimmer.getTrimmedMessage(failure), failure.getException().getClass().getName(), StackTrimmer.getTrimmedStackTrace(failure));
    }
}

