/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.platform;

import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.TestRunInfo;
import androidx.test.services.events.TimeStamp;
import androidx.test.services.events.platform.TestPlatformEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TestRunStartedEvent
extends TestPlatformEvent {
    public final TestRunInfo testRun;
    public final TimeStamp timeStamp;

    public TestRunStartedEvent(@NonNull TestRunInfo testRun, @NonNull TimeStamp timeStamp) {
        this.testRun = (TestRunInfo)Checks.checkNotNull((Object)testRun, (Object)"testRun cannot be null");
        this.timeStamp = (TimeStamp)Checks.checkNotNull((Object)timeStamp, (Object)"timeStamp cannot be null");
    }

    public TestRunStartedEvent(Parcel source) {
        this.testRun = new TestRunInfo(source);
        this.timeStamp = new TimeStamp(source);
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        super.writeToParcel(parcel, i);
        this.testRun.writeToParcel(parcel, i);
        this.timeStamp.writeToParcel(parcel, i);
    }

    @Override
    TestPlatformEvent.EventType instanceType() {
        return TestPlatformEvent.EventType.TEST_RUN_STARTED;
    }
}

