/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.storage.internal;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.storage.TestStorageException;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TestStorageUtil {
    private static ContentProviderClient makeContentProviderClient(ContentResolver resolver, Uri uri) {
        Checks.checkNotNull((Object)resolver);
        ContentProviderClient providerClient = resolver.acquireContentProviderClient(uri);
        if (null == providerClient) {
            throw new TestStorageException(String.format("No content provider registered for: %s. Are all test services apks installed?", uri));
        }
        return providerClient;
    }

    public static InputStream getInputStream(Uri uri, ContentResolver contentResolver) throws FileNotFoundException {
        Checks.checkNotNull((Object)uri);
        ContentProviderClient providerClient = null;
        try {
            providerClient = TestStorageUtil.makeContentProviderClient(contentResolver, uri);
            ParcelFileDescriptor pfd = providerClient.openFile(uri, "r");
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(pfd));
            return bufferedInputStream;
        }
        catch (RemoteException re) {
            String string = String.valueOf(uri);
            throw new TestStorageException("Unable to access content provider: " + string, re);
        }
        finally {
            if (providerClient != null) {
                providerClient.release();
            }
        }
    }

    public static OutputStream getOutputStream(Uri uri, ContentResolver contentResolver) throws FileNotFoundException {
        return TestStorageUtil.getOutputStream(uri, contentResolver, false);
    }

    public static OutputStream getOutputStream(Uri uri, ContentResolver contentResolver, boolean append) throws FileNotFoundException {
        Checks.checkNotNull((Object)uri);
        ContentProviderClient providerClient = null;
        try {
            providerClient = TestStorageUtil.makeContentProviderClient(contentResolver, uri);
            String mode = append ? "wa" : "w";
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(providerClient.openFile(uri, mode));
            return autoCloseOutputStream;
        }
        catch (RemoteException re) {
            String string = String.valueOf(uri);
            throw new TestStorageException("Unable to access content provider: " + string, re);
        }
        finally {
            if (providerClient != null) {
                providerClient.release();
            }
        }
    }

    private TestStorageUtil() {
    }
}

