/*
 * Decompiled with CFR 0.152.
 */
package androidx.vectordrawable.graphics.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.AnimRes;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.util.ObjectsCompat;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.PathInterpolatorCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class AnimationUtilsCompat {
    @NonNull
    public static Interpolator loadInterpolator(@NonNull Context context, @AnimRes int id) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            Interpolator interp = AnimationUtils.loadInterpolator((Context)context, (int)id);
            ObjectsCompat.requireNonNull((Object)interp, (String)"Failed to parse interpolator, no start tag found");
            return interp;
        }
        try (XmlResourceParser parser = null;){
            if (id == 17563663) {
                FastOutLinearInInterpolator fastOutLinearInInterpolator = new FastOutLinearInInterpolator();
                return fastOutLinearInInterpolator;
            }
            if (id == 17563661) {
                FastOutSlowInInterpolator fastOutSlowInInterpolator = new FastOutSlowInInterpolator();
                return fastOutSlowInInterpolator;
            }
            if (id == 17563662) {
                LinearOutSlowInInterpolator linearOutSlowInInterpolator = new LinearOutSlowInInterpolator();
                return linearOutSlowInInterpolator;
            }
            parser = context.getResources().getAnimation(id);
            Interpolator interpolator = AnimationUtilsCompat.createInterpolatorFromXml(context, (XmlPullParser)parser);
            return interpolator;
        }
    }

    @NonNull
    private static Interpolator createInterpolatorFromXml(@NonNull Context context, @NonNull XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        Object interpolator = null;
        int depth = parser.getDepth();
        block24: while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            String name;
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            switch (name = parser.getName()) {
                case "linearInterpolator": {
                    interpolator = new LinearInterpolator();
                    continue block24;
                }
                case "accelerateInterpolator": {
                    interpolator = new AccelerateInterpolator(context, attrs);
                    continue block24;
                }
                case "decelerateInterpolator": {
                    interpolator = new DecelerateInterpolator(context, attrs);
                    continue block24;
                }
                case "accelerateDecelerateInterpolator": {
                    interpolator = new AccelerateDecelerateInterpolator();
                    continue block24;
                }
                case "cycleInterpolator": {
                    interpolator = new CycleInterpolator(context, attrs);
                    continue block24;
                }
                case "anticipateInterpolator": {
                    interpolator = new AnticipateInterpolator(context, attrs);
                    continue block24;
                }
                case "overshootInterpolator": {
                    interpolator = new OvershootInterpolator(context, attrs);
                    continue block24;
                }
                case "anticipateOvershootInterpolator": {
                    interpolator = new AnticipateOvershootInterpolator(context, attrs);
                    continue block24;
                }
                case "bounceInterpolator": {
                    interpolator = new BounceInterpolator();
                    continue block24;
                }
                case "pathInterpolator": {
                    interpolator = new PathInterpolatorCompat(context, attrs, parser);
                    continue block24;
                }
            }
            throw new RuntimeException("Unknown interpolator name: " + parser.getName());
        }
        if (interpolator == null) {
            throw new RuntimeException("Failed to parse interpolator, no start tag found");
        }
        return interpolator;
    }

    private AnimationUtilsCompat() {
    }
}

