/*
 * Decompiled with CFR 0.152.
 */
package androidx.vectordrawable.graphics.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.core.animation.Animator;
import androidx.core.animation.AnimatorInflater;
import androidx.core.animation.AnimatorListenerAdapter;
import androidx.core.animation.AnimatorSet;
import androidx.core.content.res.TypedArrayUtils;
import androidx.vectordrawable.graphics.drawable.AndroidResources;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SeekableAnimatedVectorDrawable
extends Drawable
implements Animatable {
    private static final String LOGTAG = "SeekableAVD";
    private static final String ANIMATED_VECTOR = "animated-vector";
    private static final String TARGET = "target";
    private static final boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private AnimatedVectorDrawableState mAnimatedVectorState;
    private InternalAnimatorListener mAnimatorListener = null;
    ArrayList<AnimationCallback> mAnimationCallbacks = null;
    private final Drawable.Callback mCallback = new Drawable.Callback(){

        public void invalidateDrawable(@NonNull Drawable who) {
            SeekableAnimatedVectorDrawable.this.invalidateSelf();
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
            SeekableAnimatedVectorDrawable.this.scheduleSelf(what, when);
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
            SeekableAnimatedVectorDrawable.this.unscheduleSelf(what);
        }
    };

    private SeekableAnimatedVectorDrawable() {
        this(null, null);
    }

    private SeekableAnimatedVectorDrawable(@Nullable AnimatedVectorDrawableState state, @Nullable Resources res) {
        this.mAnimatedVectorState = state != null ? state : new AnimatedVectorDrawableState(null, this.mCallback, res);
    }

    @NonNull
    public Drawable mutate() {
        return this;
    }

    @Nullable
    public static SeekableAnimatedVectorDrawable create(@NonNull Context context, @DrawableRes int resId) {
        Resources resources = context.getResources();
        try {
            int type;
            XmlResourceParser parser = resources.getXml(resId);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            return SeekableAnimatedVectorDrawable.createFromXmlInner(context.getResources(), (XmlPullParser)parser, attrs, context.getTheme());
        }
        catch (XmlPullParserException e) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)LOGTAG, (String)"parser error", (Throwable)e);
        }
        return null;
    }

    @NonNull
    public static SeekableAnimatedVectorDrawable createFromXmlInner(@NonNull Resources r, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        SeekableAnimatedVectorDrawable drawable = new SeekableAnimatedVectorDrawable();
        drawable.inflate(r, parser, attrs, theme);
        return drawable;
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return null;
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mAnimatedVectorState.mChangingConfigurations;
    }

    public void draw(@NonNull Canvas canvas) {
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
        if (this.mAnimatedVectorState.mAnimatorSet.isStarted()) {
            this.invalidateSelf();
        }
    }

    protected void onBoundsChange(@NonNull Rect bounds) {
        this.mAnimatedVectorState.mVectorDrawable.setBounds(bounds);
    }

    protected boolean onStateChange(@NonNull int[] state) {
        return this.mAnimatedVectorState.mVectorDrawable.setState(state);
    }

    protected boolean onLevelChange(int level) {
        return this.mAnimatedVectorState.mVectorDrawable.setLevel(level);
    }

    @IntRange(from=0L, to=255L)
    public int getAlpha() {
        return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.mAnimatedVectorState.mVectorDrawable.getColorFilter();
    }

    public void setTint(@ColorInt int tint) {
        this.mAnimatedVectorState.mVectorDrawable.setTint(tint);
    }

    public void setTintList(@Nullable ColorStateList tint) {
        this.mAnimatedVectorState.mVectorDrawable.setTintList(tint);
    }

    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(tintMode);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.mAnimatedVectorState.mVectorDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    public boolean isStateful() {
        return this.mAnimatedVectorState.mVectorDrawable.isStateful();
    }

    @Deprecated
    public int getOpacity() {
        return this.mAnimatedVectorState.mVectorDrawable.getOpacity();
    }

    public int getIntrinsicWidth() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
    }

    public boolean isAutoMirrored() {
        return this.mAnimatedVectorState.mVectorDrawable.isAutoMirrored();
    }

    public void setAutoMirrored(boolean mirrored) {
        this.mAnimatedVectorState.mVectorDrawable.setAutoMirrored(mirrored);
    }

    public void inflate(@NonNull Resources res, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        int innerDepth = parser.getDepth() + 1;
        while (eventType != 1 && (parser.getDepth() >= innerDepth || eventType != 3)) {
            if (eventType == 2) {
                TypedArray a;
                String tagName = parser.getName();
                if (ANIMATED_VECTOR.equals(tagName)) {
                    a = TypedArrayUtils.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])AndroidResources.STYLEABLE_ANIMATED_VECTOR_DRAWABLE);
                    int drawableRes = a.getResourceId(0, 0);
                    if (drawableRes != 0) {
                        VectorDrawableCompat vectorDrawable = VectorDrawableCompat.createWithoutDelegate((Resources)res, (int)drawableRes, (Resources.Theme)theme);
                        vectorDrawable.setAllowCaching(false);
                        vectorDrawable.setCallback(this.mCallback);
                        if (this.mAnimatedVectorState.mVectorDrawable != null) {
                            this.mAnimatedVectorState.mVectorDrawable.setCallback(null);
                        }
                        this.mAnimatedVectorState.mVectorDrawable = vectorDrawable;
                    }
                    a.recycle();
                } else if (TARGET.equals(tagName)) {
                    a = res.obtainAttributes(attrs, AndroidResources.STYLEABLE_ANIMATED_VECTOR_DRAWABLE_TARGET);
                    String target = a.getString(0);
                    int id = a.getResourceId(1, 0);
                    if (id != 0) {
                        Animator objectAnimator = AnimatorInflater.loadAnimator((Resources)res, (Resources.Theme)theme, (int)id);
                        this.setupAnimatorsForTarget(target, objectAnimator);
                    }
                    a.recycle();
                }
            }
            eventType = parser.next();
        }
        this.mAnimatedVectorState.setupAnimatorSet();
    }

    public void inflate(@NonNull Resources res, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs) throws XmlPullParserException, IOException {
        this.inflate(res, parser, attrs, null);
    }

    public void applyTheme(@NonNull Resources.Theme t) {
    }

    public boolean canApplyTheme() {
        return false;
    }

    private void setupAnimatorsForTarget(String name, Animator animator) {
        Object target = this.mAnimatedVectorState.mVectorDrawable.getTargetByName(name);
        animator.setTarget(target);
        if (this.mAnimatedVectorState.mAnimators == null) {
            this.mAnimatedVectorState.mAnimators = new ArrayList();
            this.mAnimatedVectorState.mTargetNameMap = new SimpleArrayMap();
        }
        this.mAnimatedVectorState.mAnimators.add(animator);
        this.mAnimatedVectorState.mTargetNameMap.put((Object)animator, (Object)name);
    }

    public boolean isRunning() {
        return this.mAnimatedVectorState.mAnimatorSet.isRunning();
    }

    public boolean isPaused() {
        return this.mAnimatedVectorState.mAnimatorSet.isPaused();
    }

    public void start() {
        if (this.mAnimatedVectorState.mAnimatorSet.isStarted()) {
            return;
        }
        this.mAnimatedVectorState.mAnimatorSet.start();
        this.invalidateSelf();
    }

    public void stop() {
        this.mAnimatedVectorState.mAnimatorSet.end();
    }

    public void pause() {
        this.mAnimatedVectorState.mAnimatorSet.pause();
    }

    public void resume() {
        this.mAnimatedVectorState.mAnimatorSet.resume();
    }

    public void setCurrentPlayTime(@IntRange(from=0L) long playTime) {
        this.mAnimatedVectorState.mAnimatorSet.setCurrentPlayTime(playTime);
        this.invalidateSelf();
    }

    @IntRange(from=0L)
    public long getCurrentPlayTime() {
        return this.mAnimatedVectorState.mAnimatorSet.getCurrentPlayTime();
    }

    public long getTotalDuration() {
        return this.mAnimatedVectorState.mAnimatorSet.getTotalDuration();
    }

    public void registerAnimationCallback(@NonNull AnimationCallback callback) {
        if (this.mAnimationCallbacks == null) {
            this.mAnimationCallbacks = new ArrayList();
        } else {
            if (this.mAnimationCallbacks.contains(callback)) {
                return;
            }
            this.mAnimationCallbacks = new ArrayList<AnimationCallback>(this.mAnimationCallbacks);
        }
        this.mAnimationCallbacks.add(callback);
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new InternalAnimatorListener();
            this.mAnimatedVectorState.mAnimatorSet.addListener((Animator.AnimatorListener)this.mAnimatorListener);
            this.mAnimatedVectorState.mAnimatorSet.addPauseListener((Animator.AnimatorPauseListener)this.mAnimatorListener);
            this.mAnimatedVectorState.mAnimatorSet.addUpdateListener((Animator.AnimatorUpdateListener)this.mAnimatorListener);
        }
    }

    private void removeAnimatorSetListener() {
        if (this.mAnimatorListener != null) {
            this.mAnimatedVectorState.mAnimatorSet.removeListener((Animator.AnimatorListener)this.mAnimatorListener);
            this.mAnimatedVectorState.mAnimatorSet.removePauseListener((Animator.AnimatorPauseListener)this.mAnimatorListener);
            this.mAnimatedVectorState.mAnimatorSet.removeUpdateListener((Animator.AnimatorUpdateListener)this.mAnimatorListener);
            this.mAnimatorListener = null;
        }
    }

    public boolean unregisterAnimationCallback(@NonNull AnimationCallback callback) {
        if (this.mAnimationCallbacks == null) {
            return false;
        }
        boolean removed = false;
        if (this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks = new ArrayList<AnimationCallback>(this.mAnimationCallbacks);
            this.mAnimationCallbacks.remove(callback);
            removed = true;
        }
        if (this.mAnimationCallbacks.isEmpty()) {
            this.removeAnimatorSetListener();
        }
        return removed;
    }

    public void clearAnimationCallbacks() {
        this.removeAnimatorSetListener();
        if (this.mAnimationCallbacks == null) {
            return;
        }
        this.mAnimationCallbacks.clear();
    }

    class InternalAnimatorListener
    extends AnimatorListenerAdapter
    implements Animator.AnimatorUpdateListener {
        InternalAnimatorListener() {
        }

        public void onAnimationStart(@NonNull Animator animation) {
            ArrayList<AnimationCallback> callbacks = SeekableAnimatedVectorDrawable.this.mAnimationCallbacks;
            if (callbacks != null) {
                int size = callbacks.size();
                for (int i = 0; i < size; ++i) {
                    callbacks.get(i).onAnimationStart(SeekableAnimatedVectorDrawable.this);
                }
            }
        }

        public void onAnimationEnd(@NonNull Animator animation) {
            ArrayList<AnimationCallback> callbacks = SeekableAnimatedVectorDrawable.this.mAnimationCallbacks;
            if (callbacks != null) {
                int size = callbacks.size();
                for (int i = 0; i < size; ++i) {
                    callbacks.get(i).onAnimationEnd(SeekableAnimatedVectorDrawable.this);
                }
            }
        }

        public void onAnimationPause(@NonNull Animator animation) {
            ArrayList<AnimationCallback> callbacks = SeekableAnimatedVectorDrawable.this.mAnimationCallbacks;
            if (callbacks != null) {
                int size = callbacks.size();
                for (int i = 0; i < size; ++i) {
                    callbacks.get(i).onAnimationPause(SeekableAnimatedVectorDrawable.this);
                }
            }
        }

        public void onAnimationResume(@NonNull Animator animation) {
            ArrayList<AnimationCallback> callbacks = SeekableAnimatedVectorDrawable.this.mAnimationCallbacks;
            if (callbacks != null) {
                int size = callbacks.size();
                for (int i = 0; i < size; ++i) {
                    callbacks.get(i).onAnimationResume(SeekableAnimatedVectorDrawable.this);
                }
            }
        }

        public void onAnimationUpdate(@NonNull Animator animation) {
            ArrayList<AnimationCallback> callbacks = SeekableAnimatedVectorDrawable.this.mAnimationCallbacks;
            if (callbacks != null) {
                int size = callbacks.size();
                for (int i = 0; i < size; ++i) {
                    callbacks.get(i).onAnimationUpdate(SeekableAnimatedVectorDrawable.this);
                }
            }
        }
    }

    private static class AnimatedVectorDrawableState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        VectorDrawableCompat mVectorDrawable;
        AnimatorSet mAnimatorSet;
        ArrayList<Animator> mAnimators;
        SimpleArrayMap<Animator, String> mTargetNameMap;

        AnimatedVectorDrawableState(AnimatedVectorDrawableState copy, Drawable.Callback owner, Resources res) {
            if (copy != null) {
                this.mChangingConfigurations = copy.mChangingConfigurations;
                if (copy.mVectorDrawable != null) {
                    Drawable.ConstantState cs = copy.mVectorDrawable.getConstantState();
                    this.mVectorDrawable = res != null ? (VectorDrawableCompat)cs.newDrawable(res) : (VectorDrawableCompat)cs.newDrawable();
                    this.mVectorDrawable = (VectorDrawableCompat)this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setCallback(owner);
                    this.mVectorDrawable.setBounds(copy.mVectorDrawable.getBounds());
                    this.mVectorDrawable.setAllowCaching(false);
                }
                if (copy.mAnimators != null) {
                    int numAnimators = copy.mAnimators.size();
                    this.mAnimators = new ArrayList(numAnimators);
                    this.mTargetNameMap = new SimpleArrayMap(numAnimators);
                    for (int i = 0; i < numAnimators; ++i) {
                        Animator anim = copy.mAnimators.get(i);
                        Animator animClone = anim.clone();
                        String targetName = (String)copy.mTargetNameMap.get((Object)anim);
                        Object targetObject = this.mVectorDrawable.getTargetByName(targetName);
                        animClone.setTarget(targetObject);
                        this.mAnimators.add(animClone);
                        this.mTargetNameMap.put((Object)animClone, (Object)targetName);
                    }
                    this.setupAnimatorSet();
                }
            }
        }

        @NonNull
        public Drawable newDrawable() {
            throw new IllegalStateException("No constant state support for SDK < 24.");
        }

        @NonNull
        public Drawable newDrawable(Resources res) {
            throw new IllegalStateException("No constant state support for SDK < 24.");
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        void setupAnimatorSet() {
            if (this.mAnimatorSet == null) {
                this.mAnimatorSet = new AnimatorSet();
            }
            this.mAnimatorSet.playTogether(this.mAnimators);
        }
    }

    public static abstract class AnimationCallback {
        public void onAnimationStart(@NonNull SeekableAnimatedVectorDrawable drawable) {
        }

        public void onAnimationEnd(@NonNull SeekableAnimatedVectorDrawable drawable) {
        }

        public void onAnimationPause(@NonNull SeekableAnimatedVectorDrawable drawable) {
        }

        public void onAnimationResume(@NonNull SeekableAnimatedVectorDrawable drawable) {
        }

        public void onAnimationUpdate(@NonNull SeekableAnimatedVectorDrawable drawable) {
        }
    }
}

