/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.gcm;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.work.Logger;
import androidx.work.impl.Scheduler;
import androidx.work.impl.background.gcm.GcmTaskConverter;
import androidx.work.impl.background.gcm.WorkManagerGcmService;
import androidx.work.impl.model.WorkSpec;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.Task;

@Keep
public class GcmScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix((String)"GcmScheduler");
    private final GcmNetworkManager mNetworkManager;
    private final GcmTaskConverter mTaskConverter;

    public GcmScheduler(@NonNull Context context) {
        boolean isPlayServicesAvailable;
        boolean bl = isPlayServicesAvailable = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        if (!isPlayServicesAvailable) {
            throw new IllegalStateException("Google Play Services not available");
        }
        this.mNetworkManager = GcmNetworkManager.getInstance((Context)context);
        this.mTaskConverter = new GcmTaskConverter();
    }

    public void schedule(WorkSpec ... workSpecs) {
        for (WorkSpec workSpec : workSpecs) {
            OneoffTask task = this.mTaskConverter.convert(workSpec);
            Logger.get().debug(TAG, String.format("Scheduling %s with %s", workSpec, task), new Throwable[0]);
            this.mNetworkManager.schedule((Task)task);
        }
    }

    public void cancel(@NonNull String workSpecId) {
        Logger.get().debug(TAG, String.format("Cancelling %s", workSpecId), new Throwable[0]);
        this.mNetworkManager.cancelTask(workSpecId, WorkManagerGcmService.class);
    }
}

