/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.gcm;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.impl.background.gcm.WorkManagerGcmService;
import androidx.work.impl.model.WorkSpec;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.Task;
import java.util.concurrent.TimeUnit;

public class GcmTaskConverter {
    @VisibleForTesting
    public static final long EXECUTION_WINDOW_SIZE_IN_SECONDS = 5L;

    OneoffTask convert(@NonNull WorkSpec workSpec) {
        OneoffTask.Builder builder = new OneoffTask.Builder();
        builder.setService(WorkManagerGcmService.class).setTag(workSpec.id).setUpdateCurrent(true).setPersisted(false);
        long now = TimeUnit.SECONDS.convert(this.now(), TimeUnit.MILLISECONDS);
        long nextRunTimeInSeconds = TimeUnit.SECONDS.convert(workSpec.calculateNextRunTime(), TimeUnit.MILLISECONDS);
        long offset = Math.max(nextRunTimeInSeconds - now, 0L);
        builder.setExecutionWindow(offset, offset + 5L);
        GcmTaskConverter.applyConstraints((Task.Builder)builder, workSpec);
        return builder.build();
    }

    @VisibleForTesting
    public long now() {
        return System.currentTimeMillis();
    }

    private static Task.Builder applyConstraints(@NonNull Task.Builder builder, @NonNull WorkSpec workSpec) {
        builder.setRequiresCharging(false);
        builder.setRequiredNetwork(2);
        if (workSpec.hasConstraints()) {
            Constraints constraints = workSpec.constraints;
            NetworkType networkType = constraints.getRequiredNetworkType();
            switch (networkType) {
                case METERED: 
                case NOT_ROAMING: 
                case CONNECTED: {
                    builder.setRequiredNetwork(0);
                    break;
                }
                case UNMETERED: {
                    builder.setRequiredNetwork(1);
                    break;
                }
                case NOT_REQUIRED: {
                    builder.setRequiredNetwork(2);
                    break;
                }
                default: {
                    if (Build.VERSION.SDK_INT < 30 || networkType != NetworkType.TEMPORARILY_UNMETERED) break;
                    builder.setRequiredNetwork(2);
                }
            }
            if (constraints.requiresCharging()) {
                builder.setRequiresCharging(true);
            } else {
                builder.setRequiresCharging(false);
            }
        }
        return builder;
    }
}

