/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.controllers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.work.impl.constraints.ConstraintListener;
import androidx.work.impl.constraints.trackers.ConstraintTracker;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.List;

public abstract class ConstraintController<T>
implements ConstraintListener<T> {
    private final List<String> mMatchingWorkSpecIds = new ArrayList<String>();
    private T mCurrentValue;
    private ConstraintTracker<T> mTracker;
    private OnConstraintUpdatedCallback mCallback;

    ConstraintController(ConstraintTracker<T> tracker) {
        this.mTracker = tracker;
    }

    public void setCallback(OnConstraintUpdatedCallback callback) {
        if (this.mCallback != callback) {
            this.mCallback = callback;
            this.updateCallback();
        }
    }

    abstract boolean hasConstraint(@NonNull WorkSpec var1);

    abstract boolean isConstrained(@NonNull T var1);

    public void replace(@NonNull List<WorkSpec> workSpecs) {
        this.mMatchingWorkSpecIds.clear();
        for (WorkSpec workSpec : workSpecs) {
            if (!this.hasConstraint(workSpec)) continue;
            this.mMatchingWorkSpecIds.add(workSpec.id);
        }
        if (this.mMatchingWorkSpecIds.isEmpty()) {
            this.mTracker.removeListener(this);
        } else {
            this.mTracker.addListener(this);
        }
        this.updateCallback();
    }

    public void reset() {
        if (!this.mMatchingWorkSpecIds.isEmpty()) {
            this.mMatchingWorkSpecIds.clear();
            this.mTracker.removeListener(this);
        }
    }

    public boolean isWorkSpecConstrained(@NonNull String workSpecId) {
        return this.mCurrentValue != null && this.isConstrained(this.mCurrentValue) && this.mMatchingWorkSpecIds.contains(workSpecId);
    }

    private void updateCallback() {
        if (this.mMatchingWorkSpecIds.isEmpty() || this.mCallback == null) {
            return;
        }
        if (this.mCurrentValue == null || this.isConstrained(this.mCurrentValue)) {
            this.mCallback.onConstraintNotMet(this.mMatchingWorkSpecIds);
        } else {
            this.mCallback.onConstraintMet(this.mMatchingWorkSpecIds);
        }
    }

    @Override
    public void onConstraintChanged(@Nullable T newValue) {
        this.mCurrentValue = newValue;
        this.updateCallback();
    }

    public static interface OnConstraintUpdatedCallback {
        public void onConstraintMet(@NonNull List<String> var1);

        public void onConstraintNotMet(@NonNull List<String> var1);
    }
}

