/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.database.Cursor;
import androidx.collection.ArrayMap;
import androidx.lifecycle.LiveData;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.work.Constraints;
import androidx.work.ContentUriTriggers;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTypeConverters;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public final class WorkSpecDao_Impl
implements WorkSpecDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfWorkSpec;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfSetOutput;
    private final SharedSQLiteStatement __preparedStmtOfSetPeriodStartTime;
    private final SharedSQLiteStatement __preparedStmtOfIncrementWorkSpecRunAttemptCount;
    private final SharedSQLiteStatement __preparedStmtOfResetWorkSpecRunAttemptCount;
    private final SharedSQLiteStatement __preparedStmtOfMarkWorkSpecScheduled;
    private final SharedSQLiteStatement __preparedStmtOfResetScheduledState;
    private final SharedSQLiteStatement __preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast;

    public WorkSpecDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfWorkSpec = new EntityInsertionAdapter<WorkSpec>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `WorkSpec`(`id`,`state`,`worker_class_name`,`input_merger_class_name`,`input`,`output`,`initial_delay`,`interval_duration`,`flex_duration`,`run_attempt_count`,`backoff_policy`,`backoff_delay_duration`,`period_start_time`,`minimum_retention_duration`,`schedule_requested_at`,`required_network_type`,`requires_charging`,`requires_device_idle`,`requires_battery_not_low`,`requires_storage_not_low`,`trigger_content_update_delay`,`trigger_max_content_delay`,`content_uri_triggers`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, WorkSpec value) {
                if (value.id == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.id);
                }
                int _tmp = WorkTypeConverters.stateToInt(value.state);
                stmt.bindLong(2, (long)_tmp);
                if (value.workerClassName == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.workerClassName);
                }
                if (value.inputMergerClassName == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.inputMergerClassName);
                }
                byte[] _tmp_1 = Data.toByteArray(value.input);
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, _tmp_1);
                }
                byte[] _tmp_2 = Data.toByteArray(value.output);
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, _tmp_2);
                }
                stmt.bindLong(7, value.initialDelay);
                stmt.bindLong(8, value.intervalDuration);
                stmt.bindLong(9, value.flexDuration);
                stmt.bindLong(10, (long)value.runAttemptCount);
                int _tmp_3 = WorkTypeConverters.backoffPolicyToInt(value.backoffPolicy);
                stmt.bindLong(11, (long)_tmp_3);
                stmt.bindLong(12, value.backoffDelayDuration);
                stmt.bindLong(13, value.periodStartTime);
                stmt.bindLong(14, value.minimumRetentionDuration);
                stmt.bindLong(15, value.scheduleRequestedAt);
                Constraints _tmpConstraints = value.constraints;
                if (_tmpConstraints != null) {
                    int _tmp_4 = WorkTypeConverters.networkTypeToInt(_tmpConstraints.getRequiredNetworkType());
                    stmt.bindLong(16, (long)_tmp_4);
                    int _tmp_5 = _tmpConstraints.requiresCharging() ? 1 : 0;
                    stmt.bindLong(17, (long)_tmp_5);
                    int _tmp_6 = _tmpConstraints.requiresDeviceIdle() ? 1 : 0;
                    stmt.bindLong(18, (long)_tmp_6);
                    int _tmp_7 = _tmpConstraints.requiresBatteryNotLow() ? 1 : 0;
                    stmt.bindLong(19, (long)_tmp_7);
                    int _tmp_8 = _tmpConstraints.requiresStorageNotLow() ? 1 : 0;
                    stmt.bindLong(20, (long)_tmp_8);
                    stmt.bindLong(21, _tmpConstraints.getTriggerContentUpdateDelay());
                    stmt.bindLong(22, _tmpConstraints.getTriggerMaxContentDelay());
                    byte[] _tmp_9 = WorkTypeConverters.contentUriTriggersToByteArray(_tmpConstraints.getContentUriTriggers());
                    if (_tmp_9 == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindBlob(23, _tmp_9);
                    }
                } else {
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM workspec WHERE id=?";
                return "DELETE FROM workspec WHERE id=?";
            }
        };
        this.__preparedStmtOfSetOutput = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE workspec SET output=? WHERE id=?";
                return "UPDATE workspec SET output=? WHERE id=?";
            }
        };
        this.__preparedStmtOfSetPeriodStartTime = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE workspec SET period_start_time=? WHERE id=?";
                return "UPDATE workspec SET period_start_time=? WHERE id=?";
            }
        };
        this.__preparedStmtOfIncrementWorkSpecRunAttemptCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE workspec SET run_attempt_count=run_attempt_count+1 WHERE id=?";
                return "UPDATE workspec SET run_attempt_count=run_attempt_count+1 WHERE id=?";
            }
        };
        this.__preparedStmtOfResetWorkSpecRunAttemptCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE workspec SET run_attempt_count=0 WHERE id=?";
                return "UPDATE workspec SET run_attempt_count=0 WHERE id=?";
            }
        };
        this.__preparedStmtOfMarkWorkSpecScheduled = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE workspec SET schedule_requested_at=? WHERE id=?";
                return "UPDATE workspec SET schedule_requested_at=? WHERE id=?";
            }
        };
        this.__preparedStmtOfResetScheduledState = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE workspec SET schedule_requested_at=-1 WHERE state NOT IN (2, 3, 5)";
                return "UPDATE workspec SET schedule_requested_at=-1 WHERE state NOT IN (2, 3, 5)";
            }
        };
        this.__preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM workspec WHERE state IN (2, 3, 5) AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))";
                return "DELETE FROM workspec WHERE state IN (2, 3, 5) AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))";
            }
        };
    }

    @Override
    public void insertWorkSpec(WorkSpec workSpec) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfWorkSpec.insert((Object)workSpec);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutput(String id, Data output) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetOutput.acquire();
        int _argIndex = 1;
        byte[] _tmp = Data.toByteArray(output);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindBlob(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetOutput.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPeriodStartTime(String id, long periodStartTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetPeriodStartTime.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, periodStartTime);
        _argIndex = 2;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetPeriodStartTime.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int incrementWorkSpecRunAttemptCount(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrementWorkSpecRunAttemptCount.acquire();
        int _argIndex = 1;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfIncrementWorkSpecRunAttemptCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetWorkSpecRunAttemptCount(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetWorkSpecRunAttemptCount.acquire();
        int _argIndex = 1;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetWorkSpecRunAttemptCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int markWorkSpecScheduled(String id, long startTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfMarkWorkSpecScheduled.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, startTime);
        _argIndex = 2;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfMarkWorkSpecScheduled.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetScheduledState() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetScheduledState.acquire();
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetScheduledState.release(_stmt);
        }
    }

    @Override
    public void pruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfPruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkSpec getWorkSpec(String id) {
        String _sql = "SELECT * FROM workspec WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            WorkSpec _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfPeriodStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_start_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfMRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfMRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfMRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfMRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfMRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfMTriggerContentUpdateDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfMTriggerMaxContentDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfMContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                Constraints _tmpConstraints = new Constraints();
                int _tmp = _cursor.getInt(_cursorIndexOfMRequiredNetworkType);
                NetworkType _tmpMRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp);
                _tmpConstraints.setRequiredNetworkType(_tmpMRequiredNetworkType);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfMRequiresCharging);
                boolean _tmpMRequiresCharging = _tmp_1 != 0;
                _tmpConstraints.setRequiresCharging(_tmpMRequiresCharging);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfMRequiresDeviceIdle);
                boolean _tmpMRequiresDeviceIdle = _tmp_2 != 0;
                _tmpConstraints.setRequiresDeviceIdle(_tmpMRequiresDeviceIdle);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfMRequiresBatteryNotLow);
                boolean _tmpMRequiresBatteryNotLow = _tmp_3 != 0;
                _tmpConstraints.setRequiresBatteryNotLow(_tmpMRequiresBatteryNotLow);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMRequiresStorageNotLow);
                boolean _tmpMRequiresStorageNotLow = _tmp_4 != 0;
                _tmpConstraints.setRequiresStorageNotLow(_tmpMRequiresStorageNotLow);
                long _tmpMTriggerContentUpdateDelay = _cursor.getLong(_cursorIndexOfMTriggerContentUpdateDelay);
                _tmpConstraints.setTriggerContentUpdateDelay(_tmpMTriggerContentUpdateDelay);
                long _tmpMTriggerMaxContentDelay = _cursor.getLong(_cursorIndexOfMTriggerMaxContentDelay);
                _tmpConstraints.setTriggerMaxContentDelay(_tmpMTriggerMaxContentDelay);
                byte[] _tmp_5 = _cursor.getBlob(_cursorIndexOfMContentUriTriggers);
                ContentUriTriggers _tmpMContentUriTriggers = WorkTypeConverters.byteArrayToContentUriTriggers(_tmp_5);
                _tmpConstraints.setContentUriTriggers(_tmpMContentUriTriggers);
                _result = new WorkSpec(_tmpId, _tmpWorkerClassName);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfState);
                _result.state = WorkTypeConverters.intToState(_tmp_6);
                _result.inputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfInput);
                _result.input = Data.fromByteArray(_tmp_7);
                byte[] _tmp_8 = _cursor.getBlob(_cursorIndexOfOutput);
                _result.output = Data.fromByteArray(_tmp_8);
                _result.initialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                _result.intervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                _result.flexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                _result.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                _result.backoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_9);
                _result.backoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                _result.periodStartTime = _cursor.getLong(_cursorIndexOfPeriodStartTime);
                _result.minimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                _result.scheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                _result.constraints = _tmpConstraints;
            } else {
                _result = null;
            }
            WorkSpec workSpec = _result;
            return workSpec;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkSpec[] getWorkSpecs(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM workspec WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfPeriodStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_start_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfMRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfMRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfMRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfMRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfMRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfMTriggerContentUpdateDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfMTriggerMaxContentDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfMContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            WorkSpec[] _result = new WorkSpec[_cursor.getCount()];
            int _index = 0;
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                Constraints _tmpConstraints = new Constraints();
                int _tmp = _cursor.getInt(_cursorIndexOfMRequiredNetworkType);
                NetworkType _tmpMRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp);
                _tmpConstraints.setRequiredNetworkType(_tmpMRequiredNetworkType);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfMRequiresCharging);
                boolean _tmpMRequiresCharging = _tmp_1 != 0;
                _tmpConstraints.setRequiresCharging(_tmpMRequiresCharging);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfMRequiresDeviceIdle);
                boolean _tmpMRequiresDeviceIdle = _tmp_2 != 0;
                _tmpConstraints.setRequiresDeviceIdle(_tmpMRequiresDeviceIdle);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfMRequiresBatteryNotLow);
                boolean _tmpMRequiresBatteryNotLow = _tmp_3 != 0;
                _tmpConstraints.setRequiresBatteryNotLow(_tmpMRequiresBatteryNotLow);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMRequiresStorageNotLow);
                boolean _tmpMRequiresStorageNotLow = _tmp_4 != 0;
                _tmpConstraints.setRequiresStorageNotLow(_tmpMRequiresStorageNotLow);
                long _tmpMTriggerContentUpdateDelay = _cursor.getLong(_cursorIndexOfMTriggerContentUpdateDelay);
                _tmpConstraints.setTriggerContentUpdateDelay(_tmpMTriggerContentUpdateDelay);
                long _tmpMTriggerMaxContentDelay = _cursor.getLong(_cursorIndexOfMTriggerMaxContentDelay);
                _tmpConstraints.setTriggerMaxContentDelay(_tmpMTriggerMaxContentDelay);
                byte[] _tmp_5 = _cursor.getBlob(_cursorIndexOfMContentUriTriggers);
                ContentUriTriggers _tmpMContentUriTriggers = WorkTypeConverters.byteArrayToContentUriTriggers(_tmp_5);
                _tmpConstraints.setContentUriTriggers(_tmpMContentUriTriggers);
                WorkSpec _item_1 = new WorkSpec(_tmpId, _tmpWorkerClassName);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfState);
                _item_1.state = WorkTypeConverters.intToState(_tmp_6);
                _item_1.inputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfInput);
                _item_1.input = Data.fromByteArray(_tmp_7);
                byte[] _tmp_8 = _cursor.getBlob(_cursorIndexOfOutput);
                _item_1.output = Data.fromByteArray(_tmp_8);
                _item_1.initialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                _item_1.intervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                _item_1.flexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                _item_1.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                _item_1.backoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_9);
                _item_1.backoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                _item_1.periodStartTime = _cursor.getLong(_cursorIndexOfPeriodStartTime);
                _item_1.minimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                _item_1.scheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                _item_1.constraints = _tmpConstraints;
                _result[_index] = _item_1;
                ++_index;
            }
            WorkSpec[] workSpecArray = _result;
            return workSpecArray;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.IdAndState> getWorkSpecIdAndStatesForName(String name) {
        String _sql = "SELECT id, state FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            ArrayList<WorkSpec.IdAndState> _result = new ArrayList<WorkSpec.IdAndState>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                WorkSpec.IdAndState _item = new WorkSpec.IdAndState();
                _item.id = _cursor.getString(_cursorIndexOfId);
                int _tmp = _cursor.getInt(_cursorIndexOfState);
                _item.state = WorkTypeConverters.intToState(_tmp);
                _result.add(_item);
            }
            ArrayList<WorkSpec.IdAndState> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllWorkSpecIds() {
        String _sql = "SELECT id FROM workspec";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkInfo.State getState(String id) {
        String _sql = "SELECT state FROM workspec WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT state FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            WorkInfo.State _result;
            if (_cursor.moveToFirst()) {
                int _tmp = _cursor.getInt(0);
                _result = WorkTypeConverters.intToState(_tmp);
            } else {
                _result = null;
            }
            WorkInfo.State state = _result;
            return state;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkSpec.WorkInfoPojo getWorkStatusPojoForId(String id) {
        String _sql = "SELECT id, state, output, run_attempt_count FROM workspec WHERE id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count FROM workspec WHERE id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            WorkSpec.WorkInfoPojo workInfoPojo;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
            try {
                WorkSpec.WorkInfoPojo _result;
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                ArrayMap _collectionTags = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTagsCollection;
                    if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                    _tmpTagsCollection = new ArrayList();
                    _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                if (_cursor.moveToFirst()) {
                    ArrayList _tmpTagsCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                        _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                    }
                    if (_tmpTagsCollection_1 == null) {
                        _tmpTagsCollection_1 = new ArrayList();
                    }
                    _result = new WorkSpec.WorkInfoPojo();
                    _result.id = _cursor.getString(_cursorIndexOfId);
                    int _tmp = _cursor.getInt(_cursorIndexOfState);
                    _result.state = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                    _result.output = Data.fromByteArray(_tmp_1);
                    _result.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                    _result.tags = _tmpTagsCollection_1;
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                workInfoPojo = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return workInfoPojo;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<WorkSpec.WorkInfoPojo> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                ArrayMap _collectionTags = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTagsCollection;
                    if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                    _tmpTagsCollection = new ArrayList();
                    _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ArrayList _tmpTagsCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                        _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                    }
                    if (_tmpTagsCollection_1 == null) {
                        _tmpTagsCollection_1 = new ArrayList();
                    }
                    WorkSpec.WorkInfoPojo _item_1 = new WorkSpec.WorkInfoPojo();
                    _item_1.id = _cursor.getString(_cursorIndexOfId);
                    int _tmp = _cursor.getInt(_cursorIndexOfState);
                    _item_1.state = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                    _item_1.output = Data.fromByteArray(_tmp_1);
                    _item_1.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                    _item_1.tags = _tmpTagsCollection_1;
                    _result.add(_item_1);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForIds(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"WorkTag", "workspec"}, true, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                        int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                        int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                        ArrayMap _collectionTags = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey;
                            ArrayList _tmpTagsCollection;
                            if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpTagsCollection = new ArrayList();
                            _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            ArrayList _tmpTagsCollection_1 = null;
                            if (!_cursor.isNull(_cursorIndexOfId)) {
                                String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                                _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                            }
                            if (_tmpTagsCollection_1 == null) {
                                _tmpTagsCollection_1 = new ArrayList();
                            }
                            WorkSpec.WorkInfoPojo _item_1 = new WorkSpec.WorkInfoPojo();
                            _item_1.id = _cursor.getString(_cursorIndexOfId);
                            int _tmp = _cursor.getInt(_cursorIndexOfState);
                            _item_1.state = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                            _item_1.output = Data.fromByteArray(_tmp_1);
                            _item_1.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                            _item_1.tags = _tmpTagsCollection_1;
                            _result.add(_item_1);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForTag(String tag) {
        String _sql = "SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM worktag WHERE tag=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        if (tag == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tag);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<WorkSpec.WorkInfoPojo> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                ArrayMap _collectionTags = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTagsCollection;
                    if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                    _tmpTagsCollection = new ArrayList();
                    _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ArrayList _tmpTagsCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                        _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                    }
                    if (_tmpTagsCollection_1 == null) {
                        _tmpTagsCollection_1 = new ArrayList();
                    }
                    WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo();
                    _item.id = _cursor.getString(_cursorIndexOfId);
                    int _tmp = _cursor.getInt(_cursorIndexOfState);
                    _item.state = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                    _item.output = Data.fromByteArray(_tmp_1);
                    _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                    _item.tags = _tmpTagsCollection_1;
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForTag(String tag) {
        String _sql = "SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM worktag WHERE tag=?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        if (tag == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tag);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"WorkTag", "workspec", "worktag"}, true, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                        int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                        int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                        ArrayMap _collectionTags = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey;
                            ArrayList _tmpTagsCollection;
                            if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpTagsCollection = new ArrayList();
                            _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            ArrayList _tmpTagsCollection_1 = null;
                            if (!_cursor.isNull(_cursorIndexOfId)) {
                                String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                                _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                            }
                            if (_tmpTagsCollection_1 == null) {
                                _tmpTagsCollection_1 = new ArrayList();
                            }
                            WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo();
                            _item.id = _cursor.getString(_cursorIndexOfId);
                            int _tmp = _cursor.getInt(_cursorIndexOfState);
                            _item.state = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                            _item.output = Data.fromByteArray(_tmp_1);
                            _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                            _item.tags = _tmpTagsCollection_1;
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForName(String name) {
        String _sql = "SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            ArrayList<WorkSpec.WorkInfoPojo> arrayList;
            Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
            try {
                int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                ArrayMap _collectionTags = new ArrayMap();
                while (_cursor.moveToNext()) {
                    String _tmpKey;
                    ArrayList _tmpTagsCollection;
                    if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                    _tmpTagsCollection = new ArrayList();
                    _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                }
                _cursor.moveToPosition(-1);
                this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    ArrayList _tmpTagsCollection_1 = null;
                    if (!_cursor.isNull(_cursorIndexOfId)) {
                        String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                        _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                    }
                    if (_tmpTagsCollection_1 == null) {
                        _tmpTagsCollection_1 = new ArrayList();
                    }
                    WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo();
                    _item.id = _cursor.getString(_cursorIndexOfId);
                    int _tmp = _cursor.getInt(_cursorIndexOfState);
                    _item.state = WorkTypeConverters.intToState(_tmp);
                    byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                    _item.output = Data.fromByteArray(_tmp_1);
                    _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                    _item.tags = _tmpTagsCollection_1;
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForName(String name) {
        String _sql = "SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"WorkTag", "workspec", "workname"}, true, (Callable)new Callable<List<WorkSpec.WorkInfoPojo>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WorkSpec.WorkInfoPojo> call() throws Exception {
                WorkSpecDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<WorkSpec.WorkInfoPojo> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)WorkSpecDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true);
                    try {
                        int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                        int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
                        int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
                        int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
                        ArrayMap _collectionTags = new ArrayMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey;
                            ArrayList _tmpTagsCollection;
                            if (_cursor.isNull(_cursorIndexOfId) || (_tmpTagsCollection = (ArrayList)_collectionTags.get((Object)(_tmpKey = _cursor.getString(_cursorIndexOfId)))) != null) continue;
                            _tmpTagsCollection = new ArrayList();
                            _collectionTags.put((Object)_tmpKey, _tmpTagsCollection);
                        }
                        _cursor.moveToPosition(-1);
                        WorkSpecDao_Impl.this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_collectionTags);
                        ArrayList<WorkSpec.WorkInfoPojo> _result = new ArrayList<WorkSpec.WorkInfoPojo>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            ArrayList _tmpTagsCollection_1 = null;
                            if (!_cursor.isNull(_cursorIndexOfId)) {
                                String _tmpKey_1 = _cursor.getString(_cursorIndexOfId);
                                _tmpTagsCollection_1 = (ArrayList)_collectionTags.get((Object)_tmpKey_1);
                            }
                            if (_tmpTagsCollection_1 == null) {
                                _tmpTagsCollection_1 = new ArrayList();
                            }
                            WorkSpec.WorkInfoPojo _item = new WorkSpec.WorkInfoPojo();
                            _item.id = _cursor.getString(_cursorIndexOfId);
                            int _tmp = _cursor.getInt(_cursorIndexOfState);
                            _item.state = WorkTypeConverters.intToState(_tmp);
                            byte[] _tmp_1 = _cursor.getBlob(_cursorIndexOfOutput);
                            _item.output = Data.fromByteArray(_tmp_1);
                            _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                            _item.tags = _tmpTagsCollection_1;
                            _result.add(_item);
                        }
                        WorkSpecDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    WorkSpecDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Data> getInputsFromPrerequisites(String id) {
        String _sql = "SELECT output FROM workspec WHERE id IN (SELECT prerequisite_id FROM dependency WHERE work_spec_id=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT output FROM workspec WHERE id IN (SELECT prerequisite_id FROM dependency WHERE work_spec_id=?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<Data> _result = new ArrayList<Data>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                byte[] _tmp = _cursor.getBlob(0);
                Data _item = Data.fromByteArray(_tmp);
                _result.add(_item);
            }
            ArrayList<Data> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUnfinishedWorkWithTag(String tag) {
        String _sql = "SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM worktag WHERE tag=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM worktag WHERE tag=?)", (int)1);
        int _argIndex = 1;
        if (tag == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tag);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUnfinishedWorkWithName(String name) {
        String _sql = "SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM workname WHERE name=?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM workname WHERE name=?)", (int)1);
        int _argIndex = 1;
        if (name == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, name);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllUnfinishedWork() {
        String _sql = "SELECT id FROM workspec WHERE state NOT IN (2, 3, 5)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT id FROM workspec WHERE state NOT IN (2, 3, 5)", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getEligibleWorkForScheduling(int schedulerLimit) {
        String _sql = "SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 LIMIT (SELECT MAX(?-COUNT(*), 0) FROM workspec WHERE schedule_requested_at<>-1 AND state NOT IN (2, 3, 5))";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 LIMIT (SELECT MAX(?-COUNT(*), 0) FROM workspec WHERE schedule_requested_at<>-1 AND state NOT IN (2, 3, 5))", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)schedulerLimit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfPeriodStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_start_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfMRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfMRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfMRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfMRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfMRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfMTriggerContentUpdateDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfMTriggerMaxContentDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfMContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                Constraints _tmpConstraints = new Constraints();
                int _tmp = _cursor.getInt(_cursorIndexOfMRequiredNetworkType);
                NetworkType _tmpMRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp);
                _tmpConstraints.setRequiredNetworkType(_tmpMRequiredNetworkType);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfMRequiresCharging);
                boolean _tmpMRequiresCharging = _tmp_1 != 0;
                _tmpConstraints.setRequiresCharging(_tmpMRequiresCharging);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfMRequiresDeviceIdle);
                boolean _tmpMRequiresDeviceIdle = _tmp_2 != 0;
                _tmpConstraints.setRequiresDeviceIdle(_tmpMRequiresDeviceIdle);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfMRequiresBatteryNotLow);
                boolean _tmpMRequiresBatteryNotLow = _tmp_3 != 0;
                _tmpConstraints.setRequiresBatteryNotLow(_tmpMRequiresBatteryNotLow);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMRequiresStorageNotLow);
                boolean _tmpMRequiresStorageNotLow = _tmp_4 != 0;
                _tmpConstraints.setRequiresStorageNotLow(_tmpMRequiresStorageNotLow);
                long _tmpMTriggerContentUpdateDelay = _cursor.getLong(_cursorIndexOfMTriggerContentUpdateDelay);
                _tmpConstraints.setTriggerContentUpdateDelay(_tmpMTriggerContentUpdateDelay);
                long _tmpMTriggerMaxContentDelay = _cursor.getLong(_cursorIndexOfMTriggerMaxContentDelay);
                _tmpConstraints.setTriggerMaxContentDelay(_tmpMTriggerMaxContentDelay);
                byte[] _tmp_5 = _cursor.getBlob(_cursorIndexOfMContentUriTriggers);
                ContentUriTriggers _tmpMContentUriTriggers = WorkTypeConverters.byteArrayToContentUriTriggers(_tmp_5);
                _tmpConstraints.setContentUriTriggers(_tmpMContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpWorkerClassName);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfState);
                _item.state = WorkTypeConverters.intToState(_tmp_6);
                _item.inputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfInput);
                _item.input = Data.fromByteArray(_tmp_7);
                byte[] _tmp_8 = _cursor.getBlob(_cursorIndexOfOutput);
                _item.output = Data.fromByteArray(_tmp_8);
                _item.initialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                _item.intervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                _item.flexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                _item.backoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_9);
                _item.backoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                _item.periodStartTime = _cursor.getLong(_cursorIndexOfPeriodStartTime);
                _item.minimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                _item.scheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                _item.constraints = _tmpConstraints;
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getScheduledWork() {
        String _sql = "SELECT * FROM workspec WHERE state=0 AND schedule_requested_at<>-1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0 AND schedule_requested_at<>-1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfPeriodStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_start_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfMRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfMRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfMRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfMRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfMRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfMTriggerContentUpdateDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfMTriggerMaxContentDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfMContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                Constraints _tmpConstraints = new Constraints();
                int _tmp = _cursor.getInt(_cursorIndexOfMRequiredNetworkType);
                NetworkType _tmpMRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp);
                _tmpConstraints.setRequiredNetworkType(_tmpMRequiredNetworkType);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfMRequiresCharging);
                boolean _tmpMRequiresCharging = _tmp_1 != 0;
                _tmpConstraints.setRequiresCharging(_tmpMRequiresCharging);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfMRequiresDeviceIdle);
                boolean _tmpMRequiresDeviceIdle = _tmp_2 != 0;
                _tmpConstraints.setRequiresDeviceIdle(_tmpMRequiresDeviceIdle);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfMRequiresBatteryNotLow);
                boolean _tmpMRequiresBatteryNotLow = _tmp_3 != 0;
                _tmpConstraints.setRequiresBatteryNotLow(_tmpMRequiresBatteryNotLow);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMRequiresStorageNotLow);
                boolean _tmpMRequiresStorageNotLow = _tmp_4 != 0;
                _tmpConstraints.setRequiresStorageNotLow(_tmpMRequiresStorageNotLow);
                long _tmpMTriggerContentUpdateDelay = _cursor.getLong(_cursorIndexOfMTriggerContentUpdateDelay);
                _tmpConstraints.setTriggerContentUpdateDelay(_tmpMTriggerContentUpdateDelay);
                long _tmpMTriggerMaxContentDelay = _cursor.getLong(_cursorIndexOfMTriggerMaxContentDelay);
                _tmpConstraints.setTriggerMaxContentDelay(_tmpMTriggerMaxContentDelay);
                byte[] _tmp_5 = _cursor.getBlob(_cursorIndexOfMContentUriTriggers);
                ContentUriTriggers _tmpMContentUriTriggers = WorkTypeConverters.byteArrayToContentUriTriggers(_tmp_5);
                _tmpConstraints.setContentUriTriggers(_tmpMContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpWorkerClassName);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfState);
                _item.state = WorkTypeConverters.intToState(_tmp_6);
                _item.inputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfInput);
                _item.input = Data.fromByteArray(_tmp_7);
                byte[] _tmp_8 = _cursor.getBlob(_cursorIndexOfOutput);
                _item.output = Data.fromByteArray(_tmp_8);
                _item.initialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                _item.intervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                _item.flexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                _item.backoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_9);
                _item.backoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                _item.periodStartTime = _cursor.getLong(_cursorIndexOfPeriodStartTime);
                _item.minimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                _item.scheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                _item.constraints = _tmpConstraints;
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkSpec> getEnqueuedWork() {
        String _sql = "SELECT * FROM workspec WHERE state=0";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM workspec WHERE state=0", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"state");
            int _cursorIndexOfWorkerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"worker_class_name");
            int _cursorIndexOfInputMergerClassName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input_merger_class_name");
            int _cursorIndexOfInput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"input");
            int _cursorIndexOfOutput = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"output");
            int _cursorIndexOfInitialDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initial_delay");
            int _cursorIndexOfIntervalDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"interval_duration");
            int _cursorIndexOfFlexDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flex_duration");
            int _cursorIndexOfRunAttemptCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"run_attempt_count");
            int _cursorIndexOfBackoffPolicy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_policy");
            int _cursorIndexOfBackoffDelayDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"backoff_delay_duration");
            int _cursorIndexOfPeriodStartTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"period_start_time");
            int _cursorIndexOfMinimumRetentionDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minimum_retention_duration");
            int _cursorIndexOfScheduleRequestedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"schedule_requested_at");
            int _cursorIndexOfMRequiredNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"required_network_type");
            int _cursorIndexOfMRequiresCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_charging");
            int _cursorIndexOfMRequiresDeviceIdle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_device_idle");
            int _cursorIndexOfMRequiresBatteryNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_battery_not_low");
            int _cursorIndexOfMRequiresStorageNotLow = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requires_storage_not_low");
            int _cursorIndexOfMTriggerContentUpdateDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_content_update_delay");
            int _cursorIndexOfMTriggerMaxContentDelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"trigger_max_content_delay");
            int _cursorIndexOfMContentUriTriggers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content_uri_triggers");
            ArrayList<WorkSpec> _result = new ArrayList<WorkSpec>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpWorkerClassName = _cursor.getString(_cursorIndexOfWorkerClassName);
                Constraints _tmpConstraints = new Constraints();
                int _tmp = _cursor.getInt(_cursorIndexOfMRequiredNetworkType);
                NetworkType _tmpMRequiredNetworkType = WorkTypeConverters.intToNetworkType(_tmp);
                _tmpConstraints.setRequiredNetworkType(_tmpMRequiredNetworkType);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfMRequiresCharging);
                boolean _tmpMRequiresCharging = _tmp_1 != 0;
                _tmpConstraints.setRequiresCharging(_tmpMRequiresCharging);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfMRequiresDeviceIdle);
                boolean _tmpMRequiresDeviceIdle = _tmp_2 != 0;
                _tmpConstraints.setRequiresDeviceIdle(_tmpMRequiresDeviceIdle);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfMRequiresBatteryNotLow);
                boolean _tmpMRequiresBatteryNotLow = _tmp_3 != 0;
                _tmpConstraints.setRequiresBatteryNotLow(_tmpMRequiresBatteryNotLow);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMRequiresStorageNotLow);
                boolean _tmpMRequiresStorageNotLow = _tmp_4 != 0;
                _tmpConstraints.setRequiresStorageNotLow(_tmpMRequiresStorageNotLow);
                long _tmpMTriggerContentUpdateDelay = _cursor.getLong(_cursorIndexOfMTriggerContentUpdateDelay);
                _tmpConstraints.setTriggerContentUpdateDelay(_tmpMTriggerContentUpdateDelay);
                long _tmpMTriggerMaxContentDelay = _cursor.getLong(_cursorIndexOfMTriggerMaxContentDelay);
                _tmpConstraints.setTriggerMaxContentDelay(_tmpMTriggerMaxContentDelay);
                byte[] _tmp_5 = _cursor.getBlob(_cursorIndexOfMContentUriTriggers);
                ContentUriTriggers _tmpMContentUriTriggers = WorkTypeConverters.byteArrayToContentUriTriggers(_tmp_5);
                _tmpConstraints.setContentUriTriggers(_tmpMContentUriTriggers);
                WorkSpec _item = new WorkSpec(_tmpId, _tmpWorkerClassName);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfState);
                _item.state = WorkTypeConverters.intToState(_tmp_6);
                _item.inputMergerClassName = _cursor.getString(_cursorIndexOfInputMergerClassName);
                byte[] _tmp_7 = _cursor.getBlob(_cursorIndexOfInput);
                _item.input = Data.fromByteArray(_tmp_7);
                byte[] _tmp_8 = _cursor.getBlob(_cursorIndexOfOutput);
                _item.output = Data.fromByteArray(_tmp_8);
                _item.initialDelay = _cursor.getLong(_cursorIndexOfInitialDelay);
                _item.intervalDuration = _cursor.getLong(_cursorIndexOfIntervalDuration);
                _item.flexDuration = _cursor.getLong(_cursorIndexOfFlexDuration);
                _item.runAttemptCount = _cursor.getInt(_cursorIndexOfRunAttemptCount);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfBackoffPolicy);
                _item.backoffPolicy = WorkTypeConverters.intToBackoffPolicy(_tmp_9);
                _item.backoffDelayDuration = _cursor.getLong(_cursorIndexOfBackoffDelayDuration);
                _item.periodStartTime = _cursor.getLong(_cursorIndexOfPeriodStartTime);
                _item.minimumRetentionDuration = _cursor.getLong(_cursorIndexOfMinimumRetentionDuration);
                _item.scheduleRequestedAt = _cursor.getLong(_cursorIndexOfScheduleRequestedAt);
                _item.constraints = _tmpConstraints;
                _result.add(_item);
            }
            ArrayList<WorkSpec> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setState(WorkInfo.State state, String ... ids) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE workspec SET state=");
        _stringBuilder.append("?");
        _stringBuilder.append(" WHERE id IN (");
        int _inputSize = ids.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        int _tmp = WorkTypeConverters.stateToInt(state);
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        for (String _item : ids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            int _result = _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
            int n = _result;
            return n;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipWorkTagAsjavaLangString(ArrayMap<String, ArrayList<String>> _map) {
        Set __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            ArrayMap _tmpInnerMap = new ArrayMap(999);
            int _tmpIndex = 0;
            int _limit = _map.size();
            for (int _mapIndex = 0; _mapIndex < _limit; ++_mapIndex) {
                _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_tmpInnerMap);
                _tmpInnerMap = new ArrayMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipWorkTagAsjavaLangString((ArrayMap<String, ArrayList<String>>)_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `tag`,`work_spec_id` FROM `WorkTag` WHERE `work_spec_id` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"work_spec_id");
            if (_itemKeyIndex == -1) {
                return;
            }
            while (_cursor.moveToNext()) {
                String _tmpKey;
                ArrayList _tmpCollection;
                if (_cursor.isNull(_itemKeyIndex) || (_tmpCollection = (ArrayList)_map.get((Object)(_tmpKey = _cursor.getString(_itemKeyIndex)))) == null) continue;
                String _item_1 = _cursor.getString(0);
                _tmpCollection.add(_item_1);
            }
        }
    }
}

