/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.os.Build;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.WorkRequest;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.workers.ConstraintTrackingWorker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001e\u0010\u0012\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a8\u0006\u0013"}, d2={"checkContentUriTriggerWorkerLimits", "", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "configuration", "Landroidx/work/Configuration;", "continuation", "Landroidx/work/impl/WorkContinuationImpl;", "tryDelegateConstrainedWorkSpec", "Landroidx/work/impl/model/WorkSpec;", "workSpec", "usesScheduler", "", "schedulers", "", "Landroidx/work/impl/Scheduler;", "className", "", "wrapInConstraintTrackingWorkerIfNeeded", "work-runtime_release"})
@SourceDebugExtension(value={"SMAP\nEnqueueUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnqueueUtils.kt\nandroidx/work/impl/utils/EnqueueUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1774#2,4:118\n1747#2,3:123\n1#3:122\n*S KotlinDebug\n*F\n+ 1 EnqueueUtils.kt\nandroidx/work/impl/utils/EnqueueUtilsKt\n*L\n44#1:118,4\n112#1:123,3\n*E\n"})
public final class EnqueueUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkContentUriTriggerWorkerLimits(@NotNull WorkDatabase workDatabase, @NotNull Configuration configuration, @NotNull WorkContinuationImpl continuation) {
        int limit;
        Intrinsics.checkNotNullParameter((Object)((Object)workDatabase), (String)"workDatabase");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        Object[] objectArray = new WorkContinuationImpl[]{continuation};
        List continuations = CollectionsKt.mutableListOf((Object[])objectArray);
        int newCount = 0;
        while (!((Collection)continuations).isEmpty()) {
            List<WorkContinuationImpl> it;
            int n;
            void $this$count$iv;
            WorkContinuationImpl current = (WorkContinuationImpl)CollectionsKt.removeLast((List)continuations);
            List<? extends WorkRequest> list = current.getWork();
            Intrinsics.checkNotNullExpressionValue(list, (String)"current.work");
            Iterable iterable = list;
            int n2 = newCount;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    WorkRequest it2 = (WorkRequest)element$iv;
                    boolean bl = false;
                    if (!it2.getWorkSpec().constraints.hasContentUriTriggers() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            newCount = n2 + n3;
            if (current.getParents() == null) continue;
            boolean bl = false;
            continuations.addAll((Collection)it);
        }
        if (newCount == 0) {
            return;
        }
        int alreadyEnqueuedCount = workDatabase.workSpecDao().countNonFinishedContentUriTriggerWorkers();
        if (alreadyEnqueuedCount + newCount > (limit = configuration.getContentUriTriggerWorkersLimit())) {
            throw new IllegalArgumentException("Too many workers with contentUriTriggers are enqueued:\ncontentUriTrigger workers limit: " + limit + ";\nalready enqueued count: " + alreadyEnqueuedCount + ";\ncurrent enqueue operation count: " + newCount + ".\nTo address this issue you can: \n1. enqueue less workers or batch some of workers with content uri triggers together;\n2. increase limit via Configuration.Builder.setContentUriTriggerWorkersLimit;\nPlease beware that workers with content uri triggers immediately occupy slots in JobScheduler so no updates to content uris are missed.");
        }
    }

    @NotNull
    public static final WorkSpec tryDelegateConstrainedWorkSpec(@NotNull WorkSpec workSpec) {
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Constraints constraints = workSpec.constraints;
        String workerClassName = workSpec.workerClassName;
        boolean isConstraintTrackingWorker = Intrinsics.areEqual((Object)workerClassName, (Object)ConstraintTrackingWorker.class.getName());
        if (!isConstraintTrackingWorker && (constraints.requiresBatteryNotLow() || constraints.requiresStorageNotLow())) {
            Data newInputData = new Data.Builder().putAll(workSpec.input).putString("androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME", workerClassName).build();
            String string = ConstraintTrackingWorker.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return WorkSpec.copy$default(workSpec, null, null, string, null, newInputData, null, 0L, 0L, 0L, null, 0, null, 0L, 0L, 0L, 0L, false, null, 0, 0, 0L, 0, 0, 8388587, null);
        }
        return workSpec;
    }

    @NotNull
    public static final WorkSpec wrapInConstraintTrackingWorkerIfNeeded(@NotNull List<? extends Scheduler> schedulers2, @NotNull WorkSpec workSpec) {
        Intrinsics.checkNotNullParameter(schedulers2, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        int n = Build.VERSION.SDK_INT;
        return (23 <= n ? n < 26 : false) ? EnqueueUtilsKt.tryDelegateConstrainedWorkSpec(workSpec) : (Build.VERSION.SDK_INT <= 22 && EnqueueUtilsKt.usesScheduler(schedulers2, "androidx.work.impl.background.gcm.GcmScheduler") ? EnqueueUtilsKt.tryDelegateConstrainedWorkSpec(workSpec) : workSpec);
    }

    private static final boolean usesScheduler(List<? extends Scheduler> schedulers2, String className) {
        try {
            boolean bl;
            block5: {
                Class<?> klass = Class.forName(className);
                Iterable $this$any$iv = schedulers2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Scheduler scheduler = (Scheduler)element$iv;
                        boolean bl2 = false;
                        if (!klass.isAssignableFrom(scheduler.getClass())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

