/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/work/lint/SpecifyJobSchedulerIdRangeIssueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "hasOtherJobServices", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "specifiesJobIdRange", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableSuperClasses", "", "", "getApplicableMethodNames", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "work-runtime-lint"})
public final class SpecifyJobSchedulerIdRangeIssueDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasOtherJobServices;
    private boolean specifiesJobIdRange;
    @Nullable
    private Location location;
    @NotNull
    private static final Issue ISSUE;
    @NotNull
    private static final List<String> WELL_KNOWN_JOB_SERVICES;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"setJobSchedulerJobIdRange");
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"android.app.job.JobService");
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.hasOtherJobServices) {
            return;
        }
        String name = declaration.getQualifiedName();
        if (!CollectionsKt.contains((Iterable)WELL_KNOWN_JOB_SERVICES, (Object)name)) {
            this.hasOtherJobServices = true;
            this.location = context.getNameLocation(declaration);
        }
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "androidx.work.Configuration.Builder")) {
            this.specifiesJobIdRange = true;
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.hasOtherJobServices && !this.specifiesJobIdRange) {
            Location location = this.location;
            if (location == null) {
                location = Location.Companion.create(context.file);
            }
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)"Specify a valid range of job id's for `WorkManager` to use.", null, (int)8, null);
        }
    }

    static {
        Object[] objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SpecifyJobSchedulerIdRangeIssueDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"SpecifyJobSchedulerIdRange", (String)"Specify a range of JobScheduler ids", (String)"\n                When using `JobScheduler` APIs directly, `WorkManager` requires that developers \\\n                specify a range of `JobScheduler` ids that are safe for `WorkManager` to use \\\n                so the `id`s do not collide. \\\n\n                For more information look at \\\n                `androidx.work.Configuration.Builder.setJobSchedulerJobIdRange(int, int)`.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
        objectArray = new String[]{"android.app.job.JobService", "androidx.work.impl.background.systemjob.SystemJobService"};
        WELL_KNOWN_JOB_SERVICES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/work/lint/SpecifyJobSchedulerIdRangeIssueDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "WELL_KNOWN_JOB_SERVICES", "", "", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

