/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Clock;
import androidx.work.Configuration;
import androidx.work.Data;
import androidx.work.ForegroundUpdater;
import androidx.work.ListenableFutureKt;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkInfo;
import androidx.work.WorkerExceptionInfo;
import androidx.work.WorkerParameters;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkerStoppedException;
import androidx.work.impl.WorkerWrapper;
import androidx.work.impl.WorkerWrapperKt;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.utils.WorkForegroundKt;
import androidx.work.impl.utils.WorkForegroundUpdater;
import androidx.work.impl.utils.WorkProgressUpdater;
import androidx.work.impl.utils.WorkerExceptionUtilsKt;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002>?B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010(\u001a\u00020\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020.2\u0006\u0010#\u001a\u00020\u0015H\u0002J\f\u00102\u001a\b\u0012\u0004\u0012\u00020*03J\u0010\u00104\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00105\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0002J\b\u00106\u001a\u00020*H\u0002J\u0010\u00107\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0002J\u000e\u00108\u001a\u000209H\u0082@\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u0010<\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010=\u001a\u00020*H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Landroidx/work/impl/WorkerWrapper;", "", "builder", "Landroidx/work/impl/WorkerWrapper$Builder;", "(Landroidx/work/impl/WorkerWrapper$Builder;)V", "appContext", "Landroid/content/Context;", "builderWorker", "Landroidx/work/ListenableWorker;", "clock", "Landroidx/work/Clock;", "configuration", "Landroidx/work/Configuration;", "dependencyDao", "Landroidx/work/impl/model/DependencyDao;", "foregroundProcessor", "Landroidx/work/impl/foreground/ForegroundProcessor;", "runtimeExtras", "Landroidx/work/WorkerParameters$RuntimeExtras;", "tags", "", "", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "workDescription", "workGenerationalId", "Landroidx/work/impl/model/WorkGenerationalId;", "getWorkGenerationalId", "()Landroidx/work/impl/model/WorkGenerationalId;", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "getWorkSpec", "()Landroidx/work/impl/model/WorkSpec;", "workSpecDao", "Landroidx/work/impl/model/WorkSpecDao;", "workSpecId", "workTaskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "workerJob", "Lkotlinx/coroutines/CompletableJob;", "createWorkDescription", "handleResult", "", "result", "Landroidx/work/ListenableWorker$Result;", "interrupt", "", "stopReason", "", "iterativelyFailWorkAndDependents", "launch", "Lcom/google/common/util/concurrent/ListenableFuture;", "onWorkFinished", "reschedule", "resetPeriodic", "resetWorkerStatus", "runWorker", "Landroidx/work/impl/WorkerWrapper$Resolution;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setFailed", "setSucceeded", "trySetRunning", "Builder", "Resolution", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nWorkerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerWrapper.kt\nandroidx/work/impl/WorkerWrapper\n+ 2 LoggerExt.kt\nandroidx/work/LoggerExtKt\n*L\n1#1,607:1\n29#2:608\n29#2:609\n27#2:610\n32#2:611\n19#2:612\n19#2:613\n24#2:614\n24#2:615\n24#2:616\n24#2:617\n19#2:618\n*S KotlinDebug\n*F\n+ 1 WorkerWrapper.kt\nandroidx/work/impl/WorkerWrapper\n*L\n206#1:608\n240#1:609\n315#1:610\n318#1:611\n354#1:612\n367#1:613\n374#1:614\n381#1:615\n384#1:616\n477#1:617\n151#1:618\n*E\n"})
public final class WorkerWrapper {
    @NotNull
    private final WorkSpec workSpec;
    @NotNull
    private final Context appContext;
    @NotNull
    private final String workSpecId;
    @NotNull
    private final WorkerParameters.RuntimeExtras runtimeExtras;
    @Nullable
    private final ListenableWorker builderWorker;
    @NotNull
    private final TaskExecutor workTaskExecutor;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ForegroundProcessor foregroundProcessor;
    @NotNull
    private final WorkDatabase workDatabase;
    @NotNull
    private final WorkSpecDao workSpecDao;
    @NotNull
    private final DependencyDao dependencyDao;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final String workDescription;
    @NotNull
    private final CompletableJob workerJob;

    public WorkerWrapper(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.workSpec = builder.getWorkSpec();
        this.appContext = builder.getAppContext();
        this.workSpecId = this.workSpec.id;
        this.runtimeExtras = builder.getRuntimeExtras();
        this.builderWorker = builder.getWorker();
        this.workTaskExecutor = builder.getWorkTaskExecutor();
        this.configuration = builder.getConfiguration();
        this.clock = this.configuration.getClock();
        this.foregroundProcessor = builder.getForegroundProcessor();
        this.workDatabase = builder.getWorkDatabase();
        this.workSpecDao = this.workDatabase.workSpecDao();
        this.dependencyDao = this.workDatabase.dependencyDao();
        this.tags = builder.getTags();
        this.workDescription = this.createWorkDescription(this.tags);
        this.workerJob = JobKt.Job$default(null, (int)1, null);
    }

    @NotNull
    public final WorkSpec getWorkSpec() {
        return this.workSpec;
    }

    @NotNull
    public final WorkGenerationalId getWorkGenerationalId() {
        return WorkSpecKt.generationalId(this.workSpec);
    }

    @NotNull
    public final ListenableFuture<Boolean> launch() {
        return ListenableFutureKt.launchFuture$default(this.workTaskExecutor.getTaskCoroutineDispatcher().plus((CoroutineContext)JobKt.Job$default(null, (int)1, null)), null, (Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ WorkerWrapper this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)WorkerWrapper.access$getWorkerJob$p(this.this$0)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Resolution>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ WorkerWrapper this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = WorkerWrapper.access$runWorker(this.this$0, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Resolution> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var11_2) goto lbl11
lbl10:
                        // 1 sources

                        return var11_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            var3_3 = (Resolution)v0;
                        }
                        catch (WorkerStoppedException workerStoppedException) {
                            var3_3 = new Resolution.ResetWorkerStatus(workerStoppedException.getReason());
                        }
                        catch (CancellationException workerStoppedException) {
                            var3_3 = new Resolution.Failed(null, 1, null);
                        }
                        catch (Throwable throwable) {
                            tag$iv = WorkerWrapperKt.access$getTAG$p();
                            $i$f$loge = false;
                            var9_9 = tag$iv;
                            var8_10 = Logger.get();
                            $i$a$-loge-WorkerWrapper$launch$1$resolution$2 = false;
                            var10_12 = "Unexpected error in WorkerWrapper";
                            var8_10.error(var9_9, var10_12, throwable);
                            var3_3 = new Resolution.Failed(null, 1, null);
                        }
                        resolution = var3_3;
                        v1 = WorkerWrapper.access$getWorkDatabase$p(this.this$0).runInTransaction((Callable<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(androidx.work.impl.WorkerWrapper$Resolution androidx.work.impl.WorkerWrapper ), ()Ljava/lang/Boolean;)((Resolution)resolution, (WorkerWrapper)this.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"workDatabase.runInTransa\u2026          }\n            )");
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Boolean invokeSuspend$lambda$1(Resolution $resolution, WorkerWrapper this$0) {
                boolean bl;
                Resolution resolution2 = $resolution;
                if (resolution2 instanceof Resolution.Finished) {
                    bl = WorkerWrapper.access$onWorkFinished(this$0, ((Resolution.Finished)$resolution).getResult());
                } else if (resolution2 instanceof Resolution.Failed) {
                    this$0.setFailed(((Resolution.Failed)$resolution).getResult());
                    bl = false;
                } else if (resolution2 instanceof Resolution.ResetWorkerStatus) {
                    bl = WorkerWrapper.access$resetWorkerStatus(this$0, ((Resolution.ResetWorkerStatus)$resolution).getReason());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return bl;
            }
        }, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object runWorker(Continuation<? super Resolution> $completion) {
        if (!($completion instanceof runWorker.1)) ** GOTO lbl-1000
        var19_2 = $completion;
        if ((var19_2.label & -2147483648) != 0) {
            var19_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ WorkerWrapper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WorkerWrapper.access$runWorker(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                isTracingEnabled = this.configuration.getTracer().isEnabled();
                traceTag = this.workSpec.getTraceTag();
                if (isTracingEnabled && traceTag != null) {
                    this.configuration.getTracer().beginAsyncSection(traceTag, this.workSpec.hashCode());
                }
                shouldExit = (Boolean)this.workDatabase.runInTransaction((Callable<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, runWorker$lambda$1(androidx.work.impl.WorkerWrapper ), ()Ljava/lang/Boolean;)((WorkerWrapper)this));
                Intrinsics.checkNotNullExpressionValue((Object)shouldExit, (String)"shouldExit");
                if (shouldExit.booleanValue()) {
                    return new Resolution.ResetWorkerStatus(0, 1, null);
                }
                if (this.workSpec.isPeriodic()) {
                    v0 = this.workSpec.input;
                } else {
                    inputMergerFactory = this.configuration.getInputMergerFactory();
                    inputMerger = inputMergerFactory.createInputMergerWithDefaultFallback(inputMergerClassName = this.workSpec.inputMergerClassName);
                    if (inputMerger == null) {
                        tag$iv = WorkerWrapperKt.access$getTAG$p();
                        $i$f$loge = false;
                        var16_16 = tag$iv;
                        var15_20 = Logger.get();
                        $i$a$-loge-WorkerWrapper$runWorker$input$1 = false;
                        var17_29 = "Could not create Input Merger " + this.workSpec.inputMergerClassName;
                        var15_20.error(var16_16, var17_29);
                        return new Resolution.Failed(null, 1, null);
                    }
                    inputs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.workSpec.input), (Iterable)this.workSpecDao.getInputsFromPrerequisites(this.workSpecId));
                    v0 = inputMerger.merge((List<Data>)inputs);
                }
                input = v0;
                params = new WorkerParameters(UUID.fromString(this.workSpecId), input, (Collection<String>)this.tags, this.runtimeExtras, this.workSpec.runAttemptCount, this.workSpec.getGeneration(), this.configuration.getExecutor(), this.configuration.getWorkerCoroutineContext(), this.workTaskExecutor, this.configuration.getWorkerFactory(), new WorkProgressUpdater(this.workDatabase, this.workTaskExecutor), new WorkForegroundUpdater(this.workDatabase, this.foregroundProcessor, this.workTaskExecutor));
                v1 = this.builderWorker;
                if (v1 == null) {
                    try {
                        inputs = this.configuration.getWorkerFactory().createWorkerWithDefaultFallback(this.appContext, this.workSpec.workerClassName, params);
                    }
                    catch (Throwable e) {
                        tag$iv = WorkerWrapperKt.access$getTAG$p();
                        $i$f$loge = false;
                        var16_17 = tag$iv;
                        var15_21 = Logger.get();
                        $i$a$-loge-WorkerWrapper$runWorker$worker$1 = false;
                        var17_30 = "Could not create Worker " + this.workSpec.workerClassName;
                        var15_21.error(var16_17, var17_30);
                        v2 = this.configuration.getWorkerInitializationExceptionHandler();
                        if (v2 != null) {
                            WorkerExceptionUtilsKt.safeAccept(v2, new WorkerExceptionInfo(this.workSpec.workerClassName, params, e), WorkerWrapperKt.access$getTAG$p());
                        }
                        return new Resolution.Failed(null, 1, null);
                    }
                    v1 = inputs;
                }
                worker = v1;
                worker.setUsed();
                v3 = $continuation.getContext().get((CoroutineContext.Key)Job.Key);
                Intrinsics.checkNotNull((Object)v3);
                job = (Job)v3;
                job.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(worker, isTracingEnabled != false, traceTag, this){
                    final /* synthetic */ ListenableWorker $worker;
                    final /* synthetic */ boolean $isTracingEnabled;
                    final /* synthetic */ String $traceTag;
                    final /* synthetic */ WorkerWrapper this$0;
                    {
                        this.$worker = $worker;
                        this.$isTracingEnabled = $isTracingEnabled;
                        this.$traceTag = $traceTag;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Throwable it) {
                        if (it instanceof WorkerStoppedException) {
                            this.$worker.stop(((WorkerStoppedException)it).getReason());
                        }
                        if (this.$isTracingEnabled && this.$traceTag != null) {
                            WorkerWrapper.access$getConfiguration$p(this.this$0).getTracer().endAsyncSection(this.$traceTag, this.this$0.getWorkSpec().hashCode());
                        }
                    }
                });
                if (!this.trySetRunning()) {
                    return new Resolution.ResetWorkerStatus(0, 1, null);
                }
                if (job.isCancelled()) {
                    return new Resolution.ResetWorkerStatus(0, 1, null);
                }
                v4 = params.getForegroundUpdater();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"params.foregroundUpdater");
                foregroundUpdater = v4;
                v5 = this.workTaskExecutor.getMainThreadExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"workTaskExecutor.getMainThreadExecutor()");
                mainDispatcher = ExecutorsKt.from((Executor)v5);
                $continuation.L$0 = this;
                $continuation.L$1 = params;
                $continuation.label = 1;
                v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)mainDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ListenableWorker.Result>, Object>(this, worker, foregroundUpdater, null){
                    int label;
                    final /* synthetic */ WorkerWrapper this$0;
                    final /* synthetic */ ListenableWorker $worker;
                    final /* synthetic */ ForegroundUpdater $foregroundUpdater;
                    {
                        this.this$0 = $receiver;
                        this.$worker = $worker;
                        this.$foregroundUpdater = $foregroundUpdater;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = WorkForegroundKt.workForeground(WorkerWrapper.access$getAppContext$p(this.this$0), this.this$0.getWorkSpec(), this.$worker, this.$foregroundUpdater, WorkerWrapper.access$getWorkTaskExecutor$p(this.this$0), (Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                var2_3 = WorkerWrapperKt.access$getTAG$p();
                                var3_4 = this.this$0;
                                $i$f$logd = false;
                                var7_6 = tag$iv;
                                var6_7 = Logger.get();
                                $i$a$-logd-WorkerWrapper$runWorker$result$1$1 = false;
                                var8_9 = "Starting work for " + var3_4.getWorkSpec().workerClassName;
                                var6_7.debug((String)var7_6, var8_9);
                                v1 = this.$worker.startWork();
                                Intrinsics.checkNotNullExpressionValue(v1, (String)"worker.startWork()");
                                this.label = 2;
                                v2 = WorkerWrapperKt.awaitWithin(v1, this.$worker, (Continuation)this);
                                if (v2 == var9_2) {
                                    return var9_2;
                                }
                                ** GOTO lbl31
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl31:
                                // 2 sources

                                return v2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ListenableWorker.Result> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v6 != var20_4) goto lbl82
lbl81:
                // 1 sources

                return var20_4;
lbl82:
                // 1 sources

                ** GOTO lbl90
            }
            case 1: {
                params = (WorkerParameters)$continuation.L$1;
                this = (WorkerWrapper)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl90:
                    // 2 sources

                    result = (ListenableWorker.Result)v6;
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                    return new Resolution.Finished(result);
                }
                catch (CancellationException cancellation) {
                    tag$iv = WorkerWrapperKt.access$getTAG$p();
                    $i$f$logi = false;
                    var16_18 = tag$iv;
                    var15_22 = Logger.get();
                    $i$a$-logi-WorkerWrapper$runWorker$3 = false;
                    var17_31 = this.workDescription + " was cancelled";
                    var15_22.info(var16_18, var17_31, cancellation);
                    throw cancellation;
                }
                catch (Throwable throwable) {
                    tag$iv = WorkerWrapperKt.access$getTAG$p();
                    $i$f$loge = false;
                    var16_19 = tag$iv;
                    var15_23 = Logger.get();
                    $i$a$-loge-WorkerWrapper$runWorker$4 = false;
                    var17_32 = this.workDescription + " failed because it threw an exception/error";
                    var15_23.error(var16_19, var17_32, throwable);
                    v7 = this.configuration.getWorkerExecutionExceptionHandler();
                    if (v7 != null) {
                        WorkerExceptionUtilsKt.safeAccept(v7, new WorkerExceptionInfo(this.workSpec.workerClassName, params, throwable), WorkerWrapperKt.access$getTAG$p());
                    }
                    return new Resolution.Failed(null, 1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean onWorkFinished(ListenableWorker.Result result2) {
        WorkInfo.State state = this.workSpecDao.getState(this.workSpecId);
        this.workDatabase.workProgressDao().delete(this.workSpecId);
        return state == null ? false : (state == WorkInfo.State.RUNNING ? this.handleResult(result2) : (!state.isFinished() ? this.reschedule(-512) : false));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void interrupt(int stopReason) {
        this.workerJob.cancel((CancellationException)new WorkerStoppedException(stopReason));
    }

    private final boolean resetWorkerStatus(int stopReason) {
        boolean bl;
        WorkInfo.State state = this.workSpecDao.getState(this.workSpecId);
        if (state != null && !state.isFinished()) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl2 = false;
            String string2 = "Status for " + this.workSpecId + " is " + (Object)((Object)state) + "; not doing any work and rescheduling for later execution";
            logger.debug(string, string2);
            this.workSpecDao.setState(WorkInfo.State.ENQUEUED, this.workSpecId);
            this.workSpecDao.setStopReason(this.workSpecId, stopReason);
            this.workSpecDao.markWorkSpecScheduled(this.workSpecId, -1L);
            bl = true;
        } else {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl3 = false;
            String string3 = "Status for " + this.workSpecId + " is " + (Object)((Object)state) + " ; not doing any work";
            logger.debug(string, string3);
            bl = false;
        }
        return bl;
    }

    private final boolean handleResult(ListenableWorker.Result result2) {
        boolean bl;
        if (result2 instanceof ListenableWorker.Result.Success) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl2 = false;
            String string2 = "Worker result SUCCESS for " + this.workDescription;
            logger.info(string, string2);
            bl = this.workSpec.isPeriodic() ? this.resetPeriodic() : this.setSucceeded(result2);
        } else if (result2 instanceof ListenableWorker.Result.Retry) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl3 = false;
            String string3 = "Worker result RETRY for " + this.workDescription;
            logger.info(string, string3);
            bl = this.reschedule(-256);
        } else {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl4 = false;
            String string4 = "Worker result FAILURE for " + this.workDescription;
            logger.info(string, string4);
            if (this.workSpec.isPeriodic()) {
                bl = this.resetPeriodic();
            } else {
                ListenableWorker.Result result3 = result2;
                if (result3 == null) {
                    result3 = new ListenableWorker.Result.Failure();
                }
                bl = this.setFailed(result3);
            }
        }
        return bl;
    }

    private final boolean trySetRunning() {
        Object object = this.workDatabase.runInTransaction(() -> WorkerWrapper.trySetRunning$lambda$11(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"workDatabase.runInTransa\u2026e\n            }\n        )");
        return (Boolean)object;
    }

    @VisibleForTesting
    public final boolean setFailed(@NotNull ListenableWorker.Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.iterativelyFailWorkAndDependents(this.workSpecId);
        ListenableWorker.Result.Failure failure = (ListenableWorker.Result.Failure)result2;
        Data data = failure.getOutputData();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"failure.outputData");
        Data output = data;
        this.workSpecDao.resetWorkSpecNextScheduleTimeOverride(this.workSpecId, this.workSpec.getNextScheduleTimeOverrideGeneration());
        this.workSpecDao.setOutput(this.workSpecId, output);
        return false;
    }

    private final void iterativelyFailWorkAndDependents(String workSpecId) {
        Object[] objectArray = new String[]{workSpecId};
        List idsToProcess = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)idsToProcess).isEmpty()) {
            String id = (String)CollectionsKt.removeLast((List)idsToProcess);
            if (this.workSpecDao.getState(id) != WorkInfo.State.CANCELLED) {
                this.workSpecDao.setState(WorkInfo.State.FAILED, id);
            }
            idsToProcess.addAll((Collection)this.dependencyDao.getDependentWorkIds(id));
        }
    }

    private final boolean reschedule(int stopReason) {
        this.workSpecDao.setState(WorkInfo.State.ENQUEUED, this.workSpecId);
        this.workSpecDao.setLastEnqueueTime(this.workSpecId, this.clock.currentTimeMillis());
        this.workSpecDao.resetWorkSpecNextScheduleTimeOverride(this.workSpecId, this.workSpec.getNextScheduleTimeOverrideGeneration());
        this.workSpecDao.markWorkSpecScheduled(this.workSpecId, -1L);
        this.workSpecDao.setStopReason(this.workSpecId, stopReason);
        return true;
    }

    private final boolean resetPeriodic() {
        this.workSpecDao.setLastEnqueueTime(this.workSpecId, this.clock.currentTimeMillis());
        this.workSpecDao.setState(WorkInfo.State.ENQUEUED, this.workSpecId);
        this.workSpecDao.resetWorkSpecRunAttemptCount(this.workSpecId);
        this.workSpecDao.resetWorkSpecNextScheduleTimeOverride(this.workSpecId, this.workSpec.getNextScheduleTimeOverrideGeneration());
        this.workSpecDao.incrementPeriodCount(this.workSpecId);
        this.workSpecDao.markWorkSpecScheduled(this.workSpecId, -1L);
        return false;
    }

    private final boolean setSucceeded(ListenableWorker.Result result2) {
        this.workSpecDao.setState(WorkInfo.State.SUCCEEDED, this.workSpecId);
        Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type androidx.work.ListenableWorker.Result.Success");
        ListenableWorker.Result.Success success = (ListenableWorker.Result.Success)result2;
        Data data = success.getOutputData();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"success.outputData");
        Data output = data;
        this.workSpecDao.setOutput(this.workSpecId, output);
        long currentTimeMillis = this.clock.currentTimeMillis();
        List<String> dependentWorkIds = this.dependencyDao.getDependentWorkIds(this.workSpecId);
        for (String dependentWorkId : dependentWorkIds) {
            if (this.workSpecDao.getState(dependentWorkId) != WorkInfo.State.BLOCKED || !this.dependencyDao.hasCompletedAllPrerequisites(dependentWorkId)) continue;
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logi = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "Setting status to enqueued for " + dependentWorkId;
            logger.info(string, string2);
            this.workSpecDao.setState(WorkInfo.State.ENQUEUED, dependentWorkId);
            this.workSpecDao.setLastEnqueueTime(dependentWorkId, currentTimeMillis);
        }
        return false;
    }

    private final String createWorkDescription(List<String> tags) {
        return "Work [ id=" + this.workSpecId + ", tags={ " + CollectionsKt.joinToString$default((Iterable)tags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + " } ]";
    }

    private static final Boolean runWorker$lambda$1(WorkerWrapper this$0) {
        long now;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.workSpec.state != WorkInfo.State.ENQUEUED) {
            String tag$iv = WorkerWrapperKt.access$getTAG$p();
            boolean $i$f$logd = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = this$0.workSpec.workerClassName + " is not in ENQUEUED state. Nothing more to do";
            logger.debug(string, string2);
            return true;
        }
        if ((this$0.workSpec.isPeriodic() || this$0.workSpec.isBackedOff()) && (now = this$0.clock.currentTimeMillis()) < this$0.workSpec.calculateNextRunTime()) {
            Logger.get().debug(WorkerWrapperKt.access$getTAG$p(), "Delaying execution for " + this$0.workSpec.workerClassName + " because it is being executed before schedule.");
            return true;
        }
        return false;
    }

    private static final Boolean trySetRunning$lambda$11(WorkerWrapper this$0) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        WorkInfo.State currentState = this$0.workSpecDao.getState(this$0.workSpecId);
        if (currentState == WorkInfo.State.ENQUEUED) {
            this$0.workSpecDao.setState(WorkInfo.State.RUNNING, this$0.workSpecId);
            this$0.workSpecDao.incrementWorkSpecRunAttemptCount(this$0.workSpecId);
            this$0.workSpecDao.setStopReason(this$0.workSpecId, -256);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ CompletableJob access$getWorkerJob$p(WorkerWrapper $this) {
        return $this.workerJob;
    }

    public static final /* synthetic */ Object access$runWorker(WorkerWrapper $this, Continuation $completion) {
        return $this.runWorker((Continuation<? super Resolution>)$completion);
    }

    public static final /* synthetic */ WorkDatabase access$getWorkDatabase$p(WorkerWrapper $this) {
        return $this.workDatabase;
    }

    public static final /* synthetic */ boolean access$onWorkFinished(WorkerWrapper $this, ListenableWorker.Result result2) {
        return $this.onWorkFinished(result2);
    }

    public static final /* synthetic */ boolean access$resetWorkerStatus(WorkerWrapper $this, int stopReason) {
        return $this.resetWorkerStatus(stopReason);
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(WorkerWrapper $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ Context access$getAppContext$p(WorkerWrapper $this) {
        return $this.appContext;
    }

    public static final /* synthetic */ TaskExecutor access$getWorkTaskExecutor$p(WorkerWrapper $this) {
        return $this.workTaskExecutor;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u00100\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(H\u0007R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u00061"}, d2={"Landroidx/work/impl/WorkerWrapper$Builder;", "", "context", "Landroid/content/Context;", "configuration", "Landroidx/work/Configuration;", "workTaskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "foregroundProcessor", "Landroidx/work/impl/foreground/ForegroundProcessor;", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "tags", "", "", "(Landroid/content/Context;Landroidx/work/Configuration;Landroidx/work/impl/utils/taskexecutor/TaskExecutor;Landroidx/work/impl/foreground/ForegroundProcessor;Landroidx/work/impl/WorkDatabase;Landroidx/work/impl/model/WorkSpec;Ljava/util/List;)V", "appContext", "getAppContext", "()Landroid/content/Context;", "getConfiguration", "()Landroidx/work/Configuration;", "getForegroundProcessor", "()Landroidx/work/impl/foreground/ForegroundProcessor;", "runtimeExtras", "Landroidx/work/WorkerParameters$RuntimeExtras;", "getRuntimeExtras", "()Landroidx/work/WorkerParameters$RuntimeExtras;", "setRuntimeExtras", "(Landroidx/work/WorkerParameters$RuntimeExtras;)V", "getTags", "()Ljava/util/List;", "getWorkDatabase", "()Landroidx/work/impl/WorkDatabase;", "getWorkSpec", "()Landroidx/work/impl/model/WorkSpec;", "getWorkTaskExecutor", "()Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "worker", "Landroidx/work/ListenableWorker;", "getWorker", "()Landroidx/work/ListenableWorker;", "setWorker", "(Landroidx/work/ListenableWorker;)V", "build", "Landroidx/work/impl/WorkerWrapper;", "withRuntimeExtras", "withWorker", "work-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Builder {
        @NotNull
        private final Configuration configuration;
        @NotNull
        private final TaskExecutor workTaskExecutor;
        @NotNull
        private final ForegroundProcessor foregroundProcessor;
        @NotNull
        private final WorkDatabase workDatabase;
        @NotNull
        private final WorkSpec workSpec;
        @NotNull
        private final List<String> tags;
        @NotNull
        private final Context appContext;
        @Nullable
        private ListenableWorker worker;
        @NotNull
        private WorkerParameters.RuntimeExtras runtimeExtras;

        @SuppressLint(value={"LambdaLast"})
        public Builder(@NotNull Context context, @NotNull Configuration configuration, @NotNull TaskExecutor workTaskExecutor, @NotNull ForegroundProcessor foregroundProcessor, @NotNull WorkDatabase workDatabase, @NotNull WorkSpec workSpec, @NotNull List<String> tags) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)workTaskExecutor, (String)"workTaskExecutor");
            Intrinsics.checkNotNullParameter((Object)foregroundProcessor, (String)"foregroundProcessor");
            Intrinsics.checkNotNullParameter((Object)((Object)workDatabase), (String)"workDatabase");
            Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            this.configuration = configuration;
            this.workTaskExecutor = workTaskExecutor;
            this.foregroundProcessor = foregroundProcessor;
            this.workDatabase = workDatabase;
            this.workSpec = workSpec;
            this.tags = tags;
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            this.appContext = context2;
            this.runtimeExtras = new WorkerParameters.RuntimeExtras();
        }

        @NotNull
        public final Configuration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final TaskExecutor getWorkTaskExecutor() {
            return this.workTaskExecutor;
        }

        @NotNull
        public final ForegroundProcessor getForegroundProcessor() {
            return this.foregroundProcessor;
        }

        @NotNull
        public final WorkDatabase getWorkDatabase() {
            return this.workDatabase;
        }

        @NotNull
        public final WorkSpec getWorkSpec() {
            return this.workSpec;
        }

        @NotNull
        public final List<String> getTags() {
            return this.tags;
        }

        @NotNull
        public final Context getAppContext() {
            return this.appContext;
        }

        @Nullable
        public final ListenableWorker getWorker() {
            return this.worker;
        }

        public final void setWorker(@Nullable ListenableWorker listenableWorker) {
            this.worker = listenableWorker;
        }

        @NotNull
        public final WorkerParameters.RuntimeExtras getRuntimeExtras() {
            return this.runtimeExtras;
        }

        public final void setRuntimeExtras(@NotNull WorkerParameters.RuntimeExtras runtimeExtras) {
            Intrinsics.checkNotNullParameter((Object)runtimeExtras, (String)"<set-?>");
            this.runtimeExtras = runtimeExtras;
        }

        @NotNull
        public final Builder withRuntimeExtras(@Nullable WorkerParameters.RuntimeExtras runtimeExtras) {
            if (runtimeExtras != null) {
                this.runtimeExtras = runtimeExtras;
            }
            return this;
        }

        @VisibleForTesting
        @NotNull
        public final Builder withWorker(@NotNull ListenableWorker worker) {
            Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
            this.worker = worker;
            return this;
        }

        @NotNull
        public final WorkerWrapper build() {
            return new WorkerWrapper(this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Landroidx/work/impl/WorkerWrapper$Resolution;", "", "()V", "Failed", "Finished", "ResetWorkerStatus", "Landroidx/work/impl/WorkerWrapper$Resolution$Failed;", "Landroidx/work/impl/WorkerWrapper$Resolution$Finished;", "Landroidx/work/impl/WorkerWrapper$Resolution$ResetWorkerStatus;", "work-runtime_release"})
    private static abstract class Resolution {
        private Resolution() {
        }

        public /* synthetic */ Resolution(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/impl/WorkerWrapper$Resolution$Failed;", "Landroidx/work/impl/WorkerWrapper$Resolution;", "result", "Landroidx/work/ListenableWorker$Result;", "(Landroidx/work/ListenableWorker$Result;)V", "getResult", "()Landroidx/work/ListenableWorker$Result;", "work-runtime_release"})
        public static final class Failed
        extends Resolution {
            @NotNull
            private final ListenableWorker.Result result;

            public Failed(@NotNull ListenableWorker.Result result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                super(null);
                this.result = result2;
            }

            public /* synthetic */ Failed(ListenableWorker.Result result2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    result2 = new ListenableWorker.Result.Failure();
                }
                this(result2);
            }

            @NotNull
            public final ListenableWorker.Result getResult() {
                return this.result;
            }

            public Failed() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/impl/WorkerWrapper$Resolution$Finished;", "Landroidx/work/impl/WorkerWrapper$Resolution;", "result", "Landroidx/work/ListenableWorker$Result;", "(Landroidx/work/ListenableWorker$Result;)V", "getResult", "()Landroidx/work/ListenableWorker$Result;", "work-runtime_release"})
        public static final class Finished
        extends Resolution {
            @NotNull
            private final ListenableWorker.Result result;

            public Finished(@NotNull ListenableWorker.Result result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                super(null);
                this.result = result2;
            }

            @NotNull
            public final ListenableWorker.Result getResult() {
                return this.result;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/impl/WorkerWrapper$Resolution$ResetWorkerStatus;", "Landroidx/work/impl/WorkerWrapper$Resolution;", "reason", "", "(I)V", "getReason", "()I", "work-runtime_release"})
        public static final class ResetWorkerStatus
        extends Resolution {
            private final int reason;

            public ResetWorkerStatus(int reason) {
                super(null);
                this.reason = reason;
            }

            public /* synthetic */ ResetWorkerStatus(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    n = -256;
                }
                this(n);
            }

            public final int getReason() {
                return this.reason;
            }

            public ResetWorkerStatus() {
                this(0, 1, null);
            }
        }
    }
}

