/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemjob;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.background.systemjob.JobScheduler21;
import androidx.work.impl.background.systemjob.JobScheduler34;
import androidx.work.impl.background.systemjob.SystemJobScheduler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0006*\u00020\n8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"TAG", "", "WORKMANAGER_NAMESPACE", "safePendingJobs", "", "Landroid/app/job/JobInfo;", "Landroid/app/job/JobScheduler;", "getSafePendingJobs", "(Landroid/app/job/JobScheduler;)Ljava/util/List;", "wmJobScheduler", "Landroid/content/Context;", "getWmJobScheduler", "(Landroid/content/Context;)Landroid/app/job/JobScheduler;", "createErrorMessage", "context", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "configuration", "Landroidx/work/Configuration;", "work-runtime_release"})
@SourceDebugExtension(value={"SMAP\nJobSchedulerExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobSchedulerExt.kt\nandroidx/work/impl/background/systemjob/JobSchedulerExtKt\n+ 2 LoggerExt.kt\nandroidx/work/LoggerExtKt\n*L\n1#1,127:1\n32#2:128\n*S KotlinDebug\n*F\n+ 1 JobSchedulerExt.kt\nandroidx/work/impl/background/systemjob/JobSchedulerExtKt\n*L\n70#1:128\n*E\n"})
public final class JobSchedulerExtKt {
    @NotNull
    public static final String WORKMANAGER_NAMESPACE = "androidx.work.systemjobscheduler";
    @NotNull
    private static final String TAG;

    @RequiresApi(value=21)
    @NotNull
    public static final JobScheduler getWmJobScheduler(@NotNull Context $this$wmJobScheduler) {
        Intrinsics.checkNotNullParameter((Object)$this$wmJobScheduler, (String)"<this>");
        Object object = $this$wmJobScheduler.getSystemService("jobscheduler");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.job.JobScheduler");
        JobScheduler defaultJobScheduler = (JobScheduler)object;
        return Build.VERSION.SDK_INT >= 34 ? JobScheduler34.INSTANCE.forNamespace(defaultJobScheduler) : defaultJobScheduler;
    }

    @RequiresApi(value=21)
    @Nullable
    public static final List<JobInfo> getSafePendingJobs(@NotNull JobScheduler $this$safePendingJobs) {
        List<JobInfo> list;
        Intrinsics.checkNotNullParameter((Object)$this$safePendingJobs, (String)"<this>");
        try {
            list = JobScheduler21.INSTANCE.getAllPendingJobs($this$safePendingJobs);
        }
        catch (Throwable exception) {
            String tag$iv = TAG;
            boolean $i$f$loge = false;
            String string = tag$iv;
            Logger logger = Logger.get();
            boolean bl = false;
            String string2 = "getAllPendingJobs() is not reliable on this device.";
            logger.error(string, string2, exception);
            list = null;
        }
        return list;
    }

    @RequiresApi(value=23)
    @NotNull
    public static final String createErrorMessage(@NotNull Context context, @NotNull WorkDatabase workDatabase, @NotNull Configuration configuration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)workDatabase), (String)"workDatabase");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        int totalLimit = Build.VERSION.SDK_INT >= 31 ? 150 : 100;
        int dbScheduledCount = workDatabase.workSpecDao().getScheduledWork().size();
        if (Build.VERSION.SDK_INT >= 34) {
            JobScheduler namespacedScheduler = JobSchedulerExtKt.getWmJobScheduler(context);
            List<JobInfo> allJobsInNamespace = JobSchedulerExtKt.getSafePendingJobs(namespacedScheduler);
            if (allJobsInNamespace != null) {
                List<JobInfo> pendingJobs = SystemJobScheduler.getPendingJobs(context, namespacedScheduler);
                int diff = pendingJobs != null ? allJobsInNamespace.size() - pendingJobs.size() : 0;
                String nonWmJobsMessage = diff == 0 ? null : diff + " of which are not owned by WorkManager";
                Object object = context.getSystemService("jobscheduler");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.job.JobScheduler");
                JobScheduler defaultJobScheduler = (JobScheduler)object;
                List<JobInfo> list = SystemJobScheduler.getPendingJobs(context, defaultJobScheduler);
                int wmJobsInDefault = list != null ? list.size() : 0;
                String defaultNamespaceMessage = wmJobsInDefault == 0 ? null : wmJobsInDefault + " from WorkManager in the default namespace";
                Object[] objectArray = new String[]{allJobsInNamespace.size() + " jobs in \"androidx.work.systemjobscheduler\" namespace", nonWmJobsMessage, defaultNamespaceMessage};
                string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)",\n", null, null, (int)0, null, null, (int)62, null);
            } else {
                string = "<faulty JobScheduler failed to getPendingJobs>";
            }
        } else {
            List<JobInfo> pendingJobs = SystemJobScheduler.getPendingJobs(context, JobSchedulerExtKt.getWmJobScheduler(context));
            string = pendingJobs == null ? "<faulty JobScheduler failed to getPendingJobs>" : pendingJobs.size() + " jobs from WorkManager";
        }
        String jobSchedulerStats = string;
        return "JobScheduler " + totalLimit + " job limit exceeded.\nIn JobScheduler there are " + jobSchedulerStats + ".\nThere are " + dbScheduledCount + " jobs tracked by WorkManager's database;\nthe Configuration limit is " + configuration.getMaxSchedulerLimit() + '.';
    }

    static {
        String string = Logger.tagWithPrefix("SystemJobScheduler");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"SystemJobScheduler\")");
        TAG = string;
    }
}

