/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerFactory;
import androidx.work.WorkerParameters;
import java.util.LinkedList;
import java.util.List;

public class DelegatingWorkerFactory
extends WorkerFactory {
    private static final String TAG = Logger.tagWithPrefix("DelegatingWkrFctry");
    private final List<WorkerFactory> mFactories = new LinkedList<WorkerFactory>();

    @VisibleForTesting
    @NonNull
    List<WorkerFactory> getFactories() {
        return this.mFactories;
    }

    public final void addFactory(@NonNull WorkerFactory workerFactory) {
        this.mFactories.add(workerFactory);
    }

    @Override
    @Nullable
    public final ListenableWorker createWorker(@NonNull Context context, @NonNull String workerClass, @NonNull WorkerParameters parameters) {
        for (WorkerFactory factory : this.mFactories) {
            try {
                ListenableWorker worker = factory.createWorker(context, workerClass, parameters);
                if (worker == null) continue;
                return worker;
            }
            catch (Throwable throwable) {
                String message = String.format("Unable to instantiate a ListenableWorker (%s)", workerClass);
                Logger.get().error(TAG, message, throwable);
                throw throwable;
            }
        }
        return null;
    }
}

