/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.work.impl.utils.IdGenerator;
import androidx.work.impl.utils.PreferenceUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkDatabaseMigrations {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_6 = 6;
    public static final int VERSION_7 = 7;
    public static final int VERSION_8 = 8;
    public static final int VERSION_9 = 9;
    public static final int VERSION_10 = 10;
    private static final String CREATE_SYSTEM_ID_INFO = "CREATE TABLE IF NOT EXISTS `SystemIdInfo` (`work_spec_id` TEXT NOT NULL, `system_id` INTEGER NOT NULL, PRIMARY KEY(`work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )";
    private static final String MIGRATE_ALARM_INFO_TO_SYSTEM_ID_INFO = "INSERT INTO SystemIdInfo(work_spec_id, system_id) SELECT work_spec_id, alarm_id AS system_id FROM alarmInfo";
    private static final String PERIODIC_WORK_SET_SCHEDULE_REQUESTED_AT = "UPDATE workspec SET schedule_requested_at=0 WHERE state NOT IN (2, 3, 5) AND schedule_requested_at=-1 AND interval_duration<>0";
    private static final String REMOVE_ALARM_INFO = "DROP TABLE IF EXISTS alarmInfo";
    private static final String WORKSPEC_ADD_TRIGGER_UPDATE_DELAY = "ALTER TABLE workspec ADD COLUMN `trigger_content_update_delay` INTEGER NOT NULL DEFAULT -1";
    private static final String WORKSPEC_ADD_TRIGGER_MAX_CONTENT_DELAY = "ALTER TABLE workspec ADD COLUMN `trigger_max_content_delay` INTEGER NOT NULL DEFAULT -1";
    private static final String CREATE_WORK_PROGRESS = "CREATE TABLE IF NOT EXISTS `WorkProgress` (`work_spec_id` TEXT NOT NULL, `progress` BLOB NOT NULL, PRIMARY KEY(`work_spec_id`), FOREIGN KEY(`work_spec_id`) REFERENCES `WorkSpec`(`id`) ON UPDATE CASCADE ON DELETE CASCADE )";
    private static final String CREATE_INDEX_PERIOD_START_TIME = "CREATE INDEX IF NOT EXISTS `index_WorkSpec_period_start_time` ON `workspec` (`period_start_time`)";
    private static final String CREATE_RUN_IN_FOREGROUND = "ALTER TABLE workspec ADD COLUMN `run_in_foreground` INTEGER NOT NULL DEFAULT 0";
    public static final String INSERT_PREFERENCE = "INSERT OR REPLACE INTO `Preference` (`key`, `long_value`) VALUES (@key, @long_value)";
    private static final String CREATE_PREFERENCE = "CREATE TABLE IF NOT EXISTS `Preference` (`key` TEXT NOT NULL, `long_value` INTEGER, PRIMARY KEY(`key`))";
    @NonNull
    public static Migration MIGRATION_1_2 = new Migration(1, 2){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL(WorkDatabaseMigrations.CREATE_SYSTEM_ID_INFO);
            database.execSQL(WorkDatabaseMigrations.MIGRATE_ALARM_INFO_TO_SYSTEM_ID_INFO);
            database.execSQL(WorkDatabaseMigrations.REMOVE_ALARM_INFO);
            database.execSQL("INSERT OR IGNORE INTO worktag(tag, work_spec_id) SELECT worker_class_name AS tag, id AS work_spec_id FROM workspec");
        }
    };
    @NonNull
    public static Migration MIGRATION_3_4 = new Migration(3, 4){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            if (Build.VERSION.SDK_INT >= 23) {
                database.execSQL(WorkDatabaseMigrations.PERIODIC_WORK_SET_SCHEDULE_REQUESTED_AT);
            }
        }
    };
    @NonNull
    public static Migration MIGRATION_4_5 = new Migration(4, 5){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL(WorkDatabaseMigrations.WORKSPEC_ADD_TRIGGER_UPDATE_DELAY);
            database.execSQL(WorkDatabaseMigrations.WORKSPEC_ADD_TRIGGER_MAX_CONTENT_DELAY);
        }
    };
    @NonNull
    public static Migration MIGRATION_6_7 = new Migration(6, 7){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL(WorkDatabaseMigrations.CREATE_WORK_PROGRESS);
        }
    };
    @NonNull
    public static Migration MIGRATION_7_8 = new Migration(7, 8){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL(WorkDatabaseMigrations.CREATE_INDEX_PERIOD_START_TIME);
        }
    };
    @NonNull
    public static Migration MIGRATION_8_9 = new Migration(8, 9){

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL(WorkDatabaseMigrations.CREATE_RUN_IN_FOREGROUND);
        }
    };

    private WorkDatabaseMigrations() {
    }

    public static class WorkMigration9To10
    extends Migration {
        final Context mContext;

        public WorkMigration9To10(@NonNull Context context) {
            super(9, 10);
            this.mContext = context;
        }

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL(WorkDatabaseMigrations.CREATE_PREFERENCE);
            PreferenceUtils.migrateLegacyPreferences(this.mContext, database);
            IdGenerator.migrateLegacyIdGenerator(this.mContext, database);
        }
    }

    public static class RescheduleMigration
    extends Migration {
        final Context mContext;

        public RescheduleMigration(@NonNull Context context, int startVersion, int endVersion) {
            super(startVersion, endVersion);
            this.mContext = context;
        }

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            if (this.endVersion >= 10) {
                database.execSQL(WorkDatabaseMigrations.INSERT_PREFERENCE, new Object[]{"reschedule_needed", 1});
            } else {
                SharedPreferences preferences = this.mContext.getSharedPreferences("androidx.work.util.preferences", 0);
                preferences.edit().putBoolean("reschedule_needed", true).apply();
            }
        }
    }
}

