/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.constraints.ConstraintListener;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ConstraintTracker<T> {
    private static final String TAG = Logger.tagWithPrefix("ConstraintTracker");
    protected final TaskExecutor mTaskExecutor;
    protected final Context mAppContext;
    private final Object mLock = new Object();
    private final Set<ConstraintListener<T>> mListeners = new LinkedHashSet<ConstraintListener<T>>();
    T mCurrentState;

    ConstraintTracker(@NonNull Context context, @NonNull TaskExecutor taskExecutor) {
        this.mAppContext = context.getApplicationContext();
        this.mTaskExecutor = taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConstraintListener<T> listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.add(listener)) {
                if (this.mListeners.size() == 1) {
                    this.mCurrentState = this.getInitialState();
                    Logger.get().debug(TAG, String.format("%s: initial state = %s", this.getClass().getSimpleName(), this.mCurrentState), new Throwable[0]);
                    this.startTracking();
                }
                listener.onConstraintChanged(this.mCurrentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConstraintListener<T> listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.remove(listener) && this.mListeners.isEmpty()) {
                this.stopTracking();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(T newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentState == newState || this.mCurrentState != null && this.mCurrentState.equals(newState)) {
                return;
            }
            this.mCurrentState = newState;
            final ArrayList<ConstraintListener<T>> listenersList = new ArrayList<ConstraintListener<T>>(this.mListeners);
            this.mTaskExecutor.getMainThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    for (ConstraintListener listener : listenersList) {
                        listener.onConstraintChanged(ConstraintTracker.this.mCurrentState);
                    }
                }
            });
        }
    }

    public abstract T getInitialState();

    public abstract void startTracking();

    public abstract void stopTracking();
}

