/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.work.WorkInfo;
import java.util.ArrayList;
import java.util.List;

public final class WorkQuery {
    private final List<String> mUniqueWorkNames;
    private final List<String> mTags;
    private final List<WorkInfo.State> mStates;

    WorkQuery(@NonNull Builder builder) {
        this.mUniqueWorkNames = builder.mUniqueWorkNames;
        this.mTags = builder.mTags;
        this.mStates = builder.mStates;
    }

    @NonNull
    public List<String> getUniqueWorkNames() {
        return this.mUniqueWorkNames;
    }

    @NonNull
    public List<String> getTags() {
        return this.mTags;
    }

    @NonNull
    public List<WorkInfo.State> getStates() {
        return this.mStates;
    }

    public static final class Builder {
        List<String> mUniqueWorkNames = new ArrayList<String>();
        List<String> mTags = new ArrayList<String>();
        List<WorkInfo.State> mStates = new ArrayList<WorkInfo.State>();

        private Builder() {
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle"})
        public static Builder fromUniqueWorkNames(@NonNull List<String> uniqueWorkNames) {
            Builder builder = new Builder();
            builder.addUniqueWorkNames(uniqueWorkNames);
            return builder;
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle"})
        public static Builder fromTags(@NonNull List<String> tags) {
            Builder builder = new Builder();
            builder.addTags(tags);
            return builder;
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle"})
        public static Builder fromStates(@NonNull List<WorkInfo.State> states) {
            Builder builder = new Builder();
            builder.addStates(states);
            return builder;
        }

        @NonNull
        public Builder addUniqueWorkNames(@NonNull List<String> uniqueWorkNames) {
            this.mUniqueWorkNames.addAll(uniqueWorkNames);
            return this;
        }

        @NonNull
        public Builder addTags(@NonNull List<String> tags) {
            this.mTags.addAll(tags);
            return this;
        }

        @NonNull
        public Builder addStates(@NonNull List<WorkInfo.State> states) {
            this.mStates.addAll(states);
            return this;
        }

        @NonNull
        public WorkQuery build() {
            if (this.mUniqueWorkNames.isEmpty() && this.mTags.isEmpty() && this.mStates.isEmpty()) {
                String message = "Must specify uniqueNames, tags or states when building a WorkQuery";
                throw new IllegalArgumentException(message);
            }
            return new WorkQuery(this);
        }
    }
}

