/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkDatabasePathHelper {
    private static final String TAG = Logger.tagWithPrefix("WrkDbPathHelper");
    private static final String WORK_DATABASE_NAME = "androidx.work.workdb";
    private static final String[] DATABASE_EXTRA_FILES = new String[]{"-journal", "-shm", "-wal"};

    private WorkDatabasePathHelper() {
    }

    @NonNull
    public static String getWorkDatabaseName() {
        return WORK_DATABASE_NAME;
    }

    public static void migrateDatabase(@NonNull Context context) {
        File defaultDatabasePath = WorkDatabasePathHelper.getDefaultDatabasePath(context);
        if (Build.VERSION.SDK_INT >= 23 && defaultDatabasePath.exists()) {
            Logger.get().debug(TAG, "Migrating WorkDatabase to the no-backup directory", new Throwable[0]);
            Map<File, File> paths = WorkDatabasePathHelper.migrationPaths(context);
            for (File source : paths.keySet()) {
                boolean renamed;
                File destination = paths.get(source);
                if (!source.exists() || destination == null) continue;
                if (destination.exists()) {
                    String message = String.format("Over-writing contents of %s", destination);
                    Logger.get().warning(TAG, message, new Throwable[0]);
                }
                String message = (renamed = source.renameTo(destination)) ? String.format("Migrated %s to %s", source, destination) : String.format("Renaming %s to %s failed", source, destination);
                Logger.get().debug(TAG, message, new Throwable[0]);
            }
        }
    }

    @NonNull
    @VisibleForTesting
    public static Map<File, File> migrationPaths(@NonNull Context context) {
        HashMap<File, File> paths = new HashMap<File, File>();
        if (Build.VERSION.SDK_INT >= 23) {
            File databasePath = WorkDatabasePathHelper.getDefaultDatabasePath(context);
            File migratedPath = WorkDatabasePathHelper.getDatabasePath(context);
            paths.put(databasePath, migratedPath);
            for (String extra : DATABASE_EXTRA_FILES) {
                File source = new File(databasePath.getPath() + extra);
                File destination = new File(migratedPath.getPath() + extra);
                paths.put(source, destination);
            }
        }
        return paths;
    }

    @NonNull
    @VisibleForTesting
    public static File getDefaultDatabasePath(@NonNull Context context) {
        return context.getDatabasePath(WORK_DATABASE_NAME);
    }

    @NonNull
    @VisibleForTesting
    public static File getDatabasePath(@NonNull Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return WorkDatabasePathHelper.getDefaultDatabasePath(context);
        }
        return WorkDatabasePathHelper.getNoBackupPath(context, WORK_DATABASE_NAME);
    }

    @RequiresApi(value=23)
    private static File getNoBackupPath(@NonNull Context context, @NonNull String filePath) {
        return new File(context.getNoBackupFilesDir(), filePath);
    }
}

