/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.work.Data;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkSpec;
import java.util.List;

@Dao
@SuppressLint(value={"UnknownNullness"})
public interface WorkSpecDao {
    @Insert(onConflict=5)
    public void insertWorkSpec(WorkSpec var1);

    @Query(value="DELETE FROM workspec WHERE id=:id")
    public void delete(String var1);

    @Query(value="SELECT * FROM workspec WHERE id=:id")
    public WorkSpec getWorkSpec(String var1);

    @Query(value="SELECT * FROM workspec WHERE id IN (:ids)")
    public WorkSpec[] getWorkSpecs(List<String> var1);

    @Query(value="SELECT id, state FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    public List<WorkSpec.IdAndState> getWorkSpecIdAndStatesForName(String var1);

    @Query(value="SELECT id FROM workspec")
    public List<String> getAllWorkSpecIds();

    @Transaction
    @Query(value="SELECT id FROM workspec")
    public LiveData<List<String>> getAllWorkSpecIdsLiveData();

    @Query(value="UPDATE workspec SET state=:state WHERE id IN (:ids)")
    public int setState(WorkInfo.State var1, String ... var2);

    @Query(value="UPDATE workspec SET output=:output WHERE id=:id")
    public void setOutput(String var1, Data var2);

    @Query(value="UPDATE workspec SET period_start_time=:periodStartTime WHERE id=:id")
    public void setPeriodStartTime(String var1, long var2);

    @Query(value="UPDATE workspec SET run_attempt_count=run_attempt_count+1 WHERE id=:id")
    public int incrementWorkSpecRunAttemptCount(String var1);

    @Query(value="UPDATE workspec SET run_attempt_count=0 WHERE id=:id")
    public int resetWorkSpecRunAttemptCount(String var1);

    @Query(value="SELECT state FROM workspec WHERE id=:id")
    public WorkInfo.State getState(String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id=:id")
    public WorkSpec.WorkInfoPojo getWorkStatusPojoForId(String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (:ids)")
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForIds(List<String> var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (:ids)")
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForIds(List<String> var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForTag(String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForTag(String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    public List<WorkSpec.WorkInfoPojo> getWorkStatusPojoForName(String var1);

    @Transaction
    @Query(value="SELECT id, state, output, run_attempt_count FROM workspec WHERE id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    public LiveData<List<WorkSpec.WorkInfoPojo>> getWorkStatusPojoLiveDataForName(String var1);

    @Query(value="SELECT output FROM workspec WHERE id IN (SELECT prerequisite_id FROM dependency WHERE work_spec_id=:id)")
    public List<Data> getInputsFromPrerequisites(String var1);

    @Query(value="SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM worktag WHERE tag=:tag)")
    public List<String> getUnfinishedWorkWithTag(@NonNull String var1);

    @Query(value="SELECT id FROM workspec WHERE state NOT IN (2, 3, 5) AND id IN (SELECT work_spec_id FROM workname WHERE name=:name)")
    public List<String> getUnfinishedWorkWithName(@NonNull String var1);

    @Query(value="SELECT id FROM workspec WHERE state NOT IN (2, 3, 5)")
    public List<String> getAllUnfinishedWork();

    @Query(value="UPDATE workspec SET schedule_requested_at=:startTime WHERE id=:id")
    public int markWorkSpecScheduled(@NonNull String var1, long var2);

    @Query(value="SELECT schedule_requested_at FROM workspec WHERE id=:id")
    public LiveData<Long> getScheduleRequestedAtLiveData(@NonNull String var1);

    @Query(value="UPDATE workspec SET schedule_requested_at=-1 WHERE state NOT IN (2, 3, 5)")
    public int resetScheduledState();

    @Query(value="SELECT * FROM workspec WHERE state=0 AND schedule_requested_at=-1 ORDER BY period_start_time LIMIT (SELECT MAX(:schedulerLimit-COUNT(*), 0) FROM workspec WHERE schedule_requested_at<>-1 AND state NOT IN (2, 3, 5))")
    public List<WorkSpec> getEligibleWorkForScheduling(int var1);

    @Query(value="SELECT * FROM workspec WHERE state=0 ORDER BY period_start_time")
    public List<WorkSpec> getAllEligibleWorkSpecsForScheduling();

    @Query(value="SELECT * FROM workspec WHERE state=0 AND schedule_requested_at<>-1")
    public List<WorkSpec> getScheduledWork();

    @Query(value="SELECT * FROM workspec WHERE state=1")
    public List<WorkSpec> getRunningWork();

    @Query(value="SELECT * FROM workspec WHERE period_start_time >= :startingAt AND state IN (2, 3, 5) ORDER BY period_start_time DESC")
    public List<WorkSpec> getRecentlyCompletedWork(long var1);

    @Query(value="DELETE FROM workspec WHERE state IN (2, 3, 5) AND (SELECT COUNT(*)=0 FROM dependency WHERE     prerequisite_id=id AND     work_spec_id NOT IN         (SELECT id FROM workspec WHERE state IN (2, 3, 5)))")
    public void pruneFinishedWorkWithZeroDependentsIgnoringKeepForAtLeast();
}

