/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.Logger;
import androidx.work.Operation;
import androidx.work.WorkInfo;
import androidx.work.WorkRequest;
import androidx.work.impl.OperationImpl;
import androidx.work.impl.Scheduler;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemalarm.RescheduleReceiver;
import androidx.work.impl.model.Dependency;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.WorkName;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTag;
import androidx.work.impl.utils.CancelWorkRunnable;
import androidx.work.impl.utils.PackageManagerHelper;
import androidx.work.impl.workers.ConstraintTrackingWorker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EnqueueRunnable
implements Runnable {
    private static final String TAG = Logger.tagWithPrefix("EnqueueRunnable");
    private final WorkContinuationImpl mWorkContinuation;
    private final OperationImpl mOperation;

    public EnqueueRunnable(@NonNull WorkContinuationImpl workContinuation) {
        this.mWorkContinuation = workContinuation;
        this.mOperation = new OperationImpl();
    }

    @Override
    public void run() {
        try {
            if (this.mWorkContinuation.hasCycles()) {
                throw new IllegalStateException(String.format("WorkContinuation has cycles (%s)", this.mWorkContinuation));
            }
            boolean needsScheduling = this.addToDatabase();
            if (needsScheduling) {
                Context context = this.mWorkContinuation.getWorkManagerImpl().getApplicationContext();
                PackageManagerHelper.setComponentEnabled(context, RescheduleReceiver.class, true);
                this.scheduleWorkInBackground();
            }
            this.mOperation.setState(Operation.SUCCESS);
        }
        catch (Throwable exception) {
            this.mOperation.setState(new Operation.State.FAILURE(exception));
        }
    }

    @NonNull
    public Operation getOperation() {
        return this.mOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean addToDatabase() {
        WorkManagerImpl workManagerImpl = this.mWorkContinuation.getWorkManagerImpl();
        WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
        workDatabase.beginTransaction();
        try {
            boolean needsScheduling = EnqueueRunnable.processContinuation(this.mWorkContinuation);
            workDatabase.setTransactionSuccessful();
            boolean bl = needsScheduling;
            return bl;
        }
        finally {
            workDatabase.endTransaction();
        }
    }

    @VisibleForTesting
    public void scheduleWorkInBackground() {
        WorkManagerImpl workManager = this.mWorkContinuation.getWorkManagerImpl();
        Schedulers.schedule(workManager.getConfiguration(), workManager.getWorkDatabase(), workManager.getSchedulers());
    }

    private static boolean processContinuation(@NonNull WorkContinuationImpl workContinuation) {
        boolean needsScheduling = false;
        List<WorkContinuationImpl> parents = workContinuation.getParents();
        if (parents != null) {
            for (WorkContinuationImpl parent : parents) {
                if (!parent.isEnqueued()) {
                    needsScheduling |= EnqueueRunnable.processContinuation(parent);
                    continue;
                }
                Logger.get().warning(TAG, String.format("Already enqueued work ids (%s).", TextUtils.join((CharSequence)", ", parent.getIds())), new Throwable[0]);
            }
        }
        return needsScheduling |= EnqueueRunnable.enqueueContinuation(workContinuation);
    }

    private static boolean enqueueContinuation(@NonNull WorkContinuationImpl workContinuation) {
        Set<String> prerequisiteIds = WorkContinuationImpl.prerequisitesFor(workContinuation);
        boolean needsScheduling = EnqueueRunnable.enqueueWorkWithPrerequisites(workContinuation.getWorkManagerImpl(), workContinuation.getWork(), prerequisiteIds.toArray(new String[0]), workContinuation.getName(), workContinuation.getExistingWorkPolicy());
        workContinuation.markEnqueued();
        return needsScheduling;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean enqueueWorkWithPrerequisites(WorkManagerImpl workManagerImpl, @NonNull List<? extends WorkRequest> workList, String[] prerequisiteIds, String name, ExistingWorkPolicy existingWorkPolicy) {
        List<WorkSpec.IdAndState> existingWorkSpecIdAndStates;
        boolean shouldApplyExistingWorkPolicy;
        boolean needsScheduling = false;
        long currentTimeMillis = System.currentTimeMillis();
        WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
        boolean hasPrerequisite = prerequisiteIds != null && prerequisiteIds.length > 0;
        boolean hasCompletedAllPrerequisites = true;
        boolean hasFailedPrerequisites = false;
        boolean hasCancelledPrerequisites = false;
        if (hasPrerequisite) {
            for (String string : prerequisiteIds) {
                WorkSpec workSpec = workDatabase.workSpecDao().getWorkSpec(string);
                if (workSpec == null) {
                    Logger.get().error(TAG, String.format("Prerequisite %s doesn't exist; not enqueuing", string), new Throwable[0]);
                    return false;
                }
                Object prerequisiteState = workSpec.state;
                hasCompletedAllPrerequisites &= prerequisiteState == WorkInfo.State.SUCCEEDED;
                if (prerequisiteState == WorkInfo.State.FAILED) {
                    hasFailedPrerequisites = true;
                    continue;
                }
                if (prerequisiteState != WorkInfo.State.CANCELLED) continue;
                hasCancelledPrerequisites = true;
            }
        }
        boolean isNamed = !TextUtils.isEmpty((CharSequence)name);
        boolean bl = shouldApplyExistingWorkPolicy = isNamed && !hasPrerequisite;
        if (shouldApplyExistingWorkPolicy && !(existingWorkSpecIdAndStates = workDatabase.workSpecDao().getWorkSpecIdAndStatesForName(name)).isEmpty()) {
            if (existingWorkPolicy == ExistingWorkPolicy.APPEND || existingWorkPolicy == ExistingWorkPolicy.APPEND_OR_REPLACE) {
                void var17_29;
                DependencyDao dependencyDao = workDatabase.dependencyDao();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (WorkSpec.IdAndState idAndState : existingWorkSpecIdAndStates) {
                    if (dependencyDao.hasDependents(idAndState.id)) continue;
                    hasCompletedAllPrerequisites &= idAndState.state == WorkInfo.State.SUCCEEDED;
                    if (idAndState.state == WorkInfo.State.FAILED) {
                        hasFailedPrerequisites = true;
                    } else if (idAndState.state == WorkInfo.State.CANCELLED) {
                        hasCancelledPrerequisites = true;
                    }
                    arrayList.add(idAndState.id);
                }
                if (existingWorkPolicy == ExistingWorkPolicy.APPEND_OR_REPLACE && (hasCancelledPrerequisites || hasFailedPrerequisites)) {
                    WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                    List<WorkSpec.IdAndState> idAndStates = workSpecDao.getWorkSpecIdAndStatesForName(name);
                    for (WorkSpec.IdAndState idAndState : idAndStates) {
                        workSpecDao.delete(idAndState.id);
                    }
                    List list = Collections.emptyList();
                    hasCancelledPrerequisites = false;
                    hasFailedPrerequisites = false;
                }
                hasPrerequisite = (prerequisiteIds = var17_29.toArray(prerequisiteIds)).length > 0;
            } else {
                if (existingWorkPolicy == ExistingWorkPolicy.KEEP) {
                    for (WorkSpec.IdAndState idAndState : existingWorkSpecIdAndStates) {
                        if (idAndState.state != WorkInfo.State.ENQUEUED && idAndState.state != WorkInfo.State.RUNNING) continue;
                        return false;
                    }
                }
                CancelWorkRunnable.forName(name, workManagerImpl, false).run();
                needsScheduling = true;
                WorkSpecDao workSpecDao = workDatabase.workSpecDao();
                for (WorkSpec.IdAndState idAndState : existingWorkSpecIdAndStates) {
                    workSpecDao.delete(idAndState.id);
                }
            }
        }
        for (WorkRequest workRequest : workList) {
            WorkSpec workSpec = workRequest.getWorkSpec();
            if (hasPrerequisite && !hasCompletedAllPrerequisites) {
                workSpec.state = hasFailedPrerequisites ? WorkInfo.State.FAILED : (hasCancelledPrerequisites ? WorkInfo.State.CANCELLED : WorkInfo.State.BLOCKED);
            } else {
                workSpec.periodStartTime = !workSpec.isPeriodic() ? currentTimeMillis : 0L;
            }
            if (Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT <= 25) {
                EnqueueRunnable.tryDelegateConstrainedWorkSpec(workSpec);
            } else if (Build.VERSION.SDK_INT <= 22 && EnqueueRunnable.usesScheduler(workManagerImpl, "androidx.work.impl.background.gcm.GcmScheduler")) {
                EnqueueRunnable.tryDelegateConstrainedWorkSpec(workSpec);
            }
            if (workSpec.state == WorkInfo.State.ENQUEUED) {
                needsScheduling = true;
            }
            workDatabase.workSpecDao().insertWorkSpec(workSpec);
            if (hasPrerequisite) {
                for (String prerequisiteId : prerequisiteIds) {
                    Dependency dep = new Dependency(workRequest.getStringId(), prerequisiteId);
                    workDatabase.dependencyDao().insertDependency(dep);
                }
            }
            for (String tag : workRequest.getTags()) {
                workDatabase.workTagDao().insert(new WorkTag(tag, workRequest.getStringId()));
            }
            if (!isNamed) continue;
            workDatabase.workNameDao().insert(new WorkName(name, workRequest.getStringId()));
        }
        return needsScheduling;
    }

    private static void tryDelegateConstrainedWorkSpec(WorkSpec workSpec) {
        Constraints constraints = workSpec.constraints;
        String workerClassName = workSpec.workerClassName;
        boolean isConstraintTrackingWorker = workerClassName.equals(ConstraintTrackingWorker.class.getName());
        if (!isConstraintTrackingWorker && (constraints.requiresBatteryNotLow() || constraints.requiresStorageNotLow())) {
            Data.Builder builder = new Data.Builder();
            builder.putAll(workSpec.input).putString("androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME", workerClassName);
            workSpec.workerClassName = ConstraintTrackingWorker.class.getName();
            workSpec.input = builder.build();
        }
    }

    private static boolean usesScheduler(@NonNull WorkManagerImpl workManager, @NonNull String className) {
        try {
            Class<?> klass = Class.forName(className);
            for (Scheduler scheduler : workManager.getSchedulers()) {
                if (!klass.isAssignableFrom(scheduler.getClass())) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

