/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.work.Configuration;
import androidx.work.ForegroundInfo;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkerWrapper;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.foreground.SystemForegroundDispatcher;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Processor
implements ExecutionListener,
ForegroundProcessor {
    private static final String TAG = Logger.tagWithPrefix("Processor");
    private static final String FOREGROUND_WAKELOCK_TAG = "ProcessorForegroundLck";
    @Nullable
    private PowerManager.WakeLock mForegroundLock;
    private Context mAppContext;
    private Configuration mConfiguration;
    private TaskExecutor mWorkTaskExecutor;
    private WorkDatabase mWorkDatabase;
    private Map<String, WorkerWrapper> mForegroundWorkMap;
    private Map<String, WorkerWrapper> mEnqueuedWorkMap;
    private List<Scheduler> mSchedulers;
    private Set<String> mCancelledIds;
    private final List<ExecutionListener> mOuterListeners;
    private final Object mLock;

    public Processor(@NonNull Context appContext, @NonNull Configuration configuration, @NonNull TaskExecutor workTaskExecutor, @NonNull WorkDatabase workDatabase, @NonNull List<Scheduler> schedulers) {
        this.mAppContext = appContext;
        this.mConfiguration = configuration;
        this.mWorkTaskExecutor = workTaskExecutor;
        this.mWorkDatabase = workDatabase;
        this.mEnqueuedWorkMap = new HashMap<String, WorkerWrapper>();
        this.mForegroundWorkMap = new HashMap<String, WorkerWrapper>();
        this.mSchedulers = schedulers;
        this.mCancelledIds = new HashSet<String>();
        this.mOuterListeners = new ArrayList<ExecutionListener>();
        this.mForegroundLock = null;
        this.mLock = new Object();
    }

    public boolean startWork(@NonNull String id) {
        return this.startWork(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWork(@NonNull String id, @Nullable WorkerParameters.RuntimeExtras runtimeExtras) {
        WorkerWrapper workWrapper;
        Object object = this.mLock;
        synchronized (object) {
            if (this.isEnqueued(id)) {
                Logger.get().debug(TAG, "Work " + id + " is already enqueued for processing");
                return false;
            }
            workWrapper = new WorkerWrapper.Builder(this.mAppContext, this.mConfiguration, this.mWorkTaskExecutor, this, this.mWorkDatabase, id).withSchedulers(this.mSchedulers).withRuntimeExtras(runtimeExtras).build();
            ListenableFuture<Boolean> future = workWrapper.getFuture();
            future.addListener((Runnable)new FutureListener(this, id, future), this.mWorkTaskExecutor.getMainThreadExecutor());
            this.mEnqueuedWorkMap.put(id, workWrapper);
        }
        this.mWorkTaskExecutor.getSerialTaskExecutor().execute(workWrapper);
        Logger.get().debug(TAG, this.getClass().getSimpleName() + ": processing " + id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startForeground(@NonNull String workSpecId, @NonNull ForegroundInfo foregroundInfo) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().info(TAG, "Moving WorkSpec (" + workSpecId + ") to the foreground");
            WorkerWrapper wrapper = this.mEnqueuedWorkMap.remove(workSpecId);
            if (wrapper != null) {
                if (this.mForegroundLock == null) {
                    this.mForegroundLock = WakeLocks.newWakeLock(this.mAppContext, FOREGROUND_WAKELOCK_TAG);
                    this.mForegroundLock.acquire();
                }
                this.mForegroundWorkMap.put(workSpecId, wrapper);
                Intent intent = SystemForegroundDispatcher.createStartForegroundIntent(this.mAppContext, workSpecId, foregroundInfo);
                ContextCompat.startForegroundService((Context)this.mAppContext, (Intent)intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopForegroundWork(@NonNull String id) {
        WorkerWrapper wrapper = null;
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Processor stopping foreground work " + id);
            wrapper = this.mForegroundWorkMap.remove(id);
        }
        return Processor.interrupt(id, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopWork(@NonNull String id) {
        WorkerWrapper wrapper = null;
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Processor stopping background work " + id);
            wrapper = this.mEnqueuedWorkMap.remove(id);
        }
        return Processor.interrupt(id, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAndCancelWork(@NonNull String id) {
        WorkerWrapper wrapper = null;
        boolean isForegroundWork = false;
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Processor cancelling " + id);
            this.mCancelledIds.add(id);
            wrapper = this.mForegroundWorkMap.remove(id);
            boolean bl = isForegroundWork = wrapper != null;
            if (wrapper == null) {
                wrapper = this.mEnqueuedWorkMap.remove(id);
            }
        }
        boolean interrupted = Processor.interrupt(id, wrapper);
        if (isForegroundWork) {
            this.stopForegroundService();
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopForeground(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mForegroundWorkMap.remove(workSpecId);
            this.stopForegroundService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled(@NonNull String id) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCancelledIds.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWork() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mEnqueuedWorkMap.isEmpty() || !this.mForegroundWorkMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnqueuedWorkMap.containsKey(workSpecId) || this.mForegroundWorkMap.containsKey(workSpecId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnqueuedInForeground(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mForegroundWorkMap.containsKey(workSpecId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionListener(@NonNull ExecutionListener executionListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOuterListeners.add(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionListener(@NonNull ExecutionListener executionListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOuterListeners.remove(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEnqueuedWorkMap.remove(workSpecId);
            Logger.get().debug(TAG, this.getClass().getSimpleName() + " " + workSpecId + " executed; reschedule = " + needsReschedule);
            for (ExecutionListener executionListener : this.mOuterListeners) {
                executionListener.onExecuted(workSpecId, needsReschedule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopForegroundService() {
        Object object = this.mLock;
        synchronized (object) {
            boolean hasForegroundWork;
            boolean bl = hasForegroundWork = !this.mForegroundWorkMap.isEmpty();
            if (!hasForegroundWork) {
                Intent intent = SystemForegroundDispatcher.createStopForegroundIntent(this.mAppContext);
                try {
                    this.mAppContext.startService(intent);
                }
                catch (Throwable throwable) {
                    Logger.get().error(TAG, "Unable to stop foreground service", throwable);
                }
                if (this.mForegroundLock != null) {
                    this.mForegroundLock.release();
                    this.mForegroundLock = null;
                }
            }
        }
    }

    private static boolean interrupt(@NonNull String id, @Nullable WorkerWrapper wrapper) {
        if (wrapper != null) {
            wrapper.interrupt();
            Logger.get().debug(TAG, "WorkerWrapper interrupted for " + id);
            return true;
        }
        Logger.get().debug(TAG, "WorkerWrapper could not be found for " + id);
        return false;
    }

    private static class FutureListener
    implements Runnable {
        @NonNull
        private ExecutionListener mExecutionListener;
        @NonNull
        private String mWorkSpecId;
        @NonNull
        private ListenableFuture<Boolean> mFuture;

        FutureListener(@NonNull ExecutionListener executionListener, @NonNull String workSpecId, @NonNull ListenableFuture<Boolean> future) {
            this.mExecutionListener = executionListener;
            this.mWorkSpecId = workSpecId;
            this.mFuture = future;
        }

        @Override
        public void run() {
            boolean needsReschedule;
            try {
                needsReschedule = (Boolean)this.mFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                needsReschedule = true;
            }
            this.mExecutionListener.onExecuted(this.mWorkSpecId, needsReschedule);
        }
    }
}

