/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.work.Logger;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.background.systemalarm.SystemAlarmDispatcher;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTrackerImpl;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.WorkTimer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DelayMetCommandHandler
implements WorkConstraintsCallback,
ExecutionListener,
WorkTimer.TimeLimitExceededListener {
    private static final String TAG = Logger.tagWithPrefix("DelayMetCommandHandler");
    private static final int STATE_INITIAL = 0;
    private static final int STATE_START_REQUESTED = 1;
    private static final int STATE_STOP_REQUESTED = 2;
    private final Context mContext;
    private final int mStartId;
    private final String mWorkSpecId;
    private final SystemAlarmDispatcher mDispatcher;
    private final WorkConstraintsTrackerImpl mWorkConstraintsTracker;
    private final Object mLock;
    private int mCurrentState;
    private final Executor mSerialExecutor;
    private final Executor mMainThreadExecutor;
    @Nullable
    private PowerManager.WakeLock mWakeLock;
    private boolean mHasConstraints;

    DelayMetCommandHandler(@NonNull Context context, int startId, @NonNull String workSpecId, @NonNull SystemAlarmDispatcher dispatcher) {
        this.mContext = context;
        this.mStartId = startId;
        this.mDispatcher = dispatcher;
        this.mWorkSpecId = workSpecId;
        Trackers trackers = dispatcher.getWorkManager().getTrackers();
        this.mSerialExecutor = dispatcher.getTaskExecutor().getSerialTaskExecutor();
        this.mMainThreadExecutor = dispatcher.getTaskExecutor().getMainThreadExecutor();
        this.mWorkConstraintsTracker = new WorkConstraintsTrackerImpl(trackers, this);
        this.mHasConstraints = false;
        this.mCurrentState = 0;
        this.mLock = new Object();
    }

    @Override
    public void onAllConstraintsMet(@NonNull List<String> workSpecIds) {
        if (!workSpecIds.contains(this.mWorkSpecId)) {
            return;
        }
        this.mSerialExecutor.execute(this::startWork);
    }

    private void startWork() {
        if (this.mCurrentState == 0) {
            this.mCurrentState = 1;
            Logger.get().debug(TAG, "onAllConstraintsMet for " + this.mWorkSpecId);
            boolean isEnqueued = this.mDispatcher.getProcessor().startWork(this.mWorkSpecId);
            if (isEnqueued) {
                this.mDispatcher.getWorkTimer().startTimer(this.mWorkSpecId, 600000L, this);
            } else {
                this.cleanUp();
            }
        } else {
            Logger.get().debug(TAG, "Already started work for " + this.mWorkSpecId);
        }
    }

    @Override
    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        Logger.get().debug(TAG, "onExecuted " + workSpecId + ", " + needsReschedule);
        this.cleanUp();
        if (needsReschedule) {
            Intent reschedule = CommandHandler.createScheduleWorkIntent(this.mContext, this.mWorkSpecId);
            this.mMainThreadExecutor.execute(new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, reschedule, this.mStartId));
        }
        if (this.mHasConstraints) {
            Intent intent = CommandHandler.createConstraintsChangedIntent(this.mContext);
            this.mMainThreadExecutor.execute(new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, intent, this.mStartId));
        }
    }

    @Override
    public void onTimeLimitExceeded(@NonNull String workSpecId) {
        Logger.get().debug(TAG, "Exceeded time limits on execution for " + workSpecId);
        this.mSerialExecutor.execute(this::stopWork);
    }

    @Override
    public void onAllConstraintsNotMet(@NonNull List<String> workSpecIds) {
        this.mSerialExecutor.execute(this::stopWork);
    }

    @WorkerThread
    void handleProcessWork() {
        this.mWakeLock = WakeLocks.newWakeLock(this.mContext, this.mWorkSpecId + " (" + this.mStartId + ")");
        Logger.get().debug(TAG, "Acquiring wakelock " + this.mWakeLock + "for WorkSpec " + this.mWorkSpecId);
        this.mWakeLock.acquire();
        WorkSpec workSpec = this.mDispatcher.getWorkManager().getWorkDatabase().workSpecDao().getWorkSpec(this.mWorkSpecId);
        if (workSpec == null) {
            this.mSerialExecutor.execute(this::stopWork);
            return;
        }
        this.mHasConstraints = workSpec.hasConstraints();
        if (!this.mHasConstraints) {
            Logger.get().debug(TAG, "No constraints for " + this.mWorkSpecId);
            this.onAllConstraintsMet(Collections.singletonList(this.mWorkSpecId));
        } else {
            this.mWorkConstraintsTracker.replace(Collections.singletonList(workSpec));
        }
    }

    private void stopWork() {
        if (this.mCurrentState < 2) {
            this.mCurrentState = 2;
            Logger.get().debug(TAG, "Stopping work for WorkSpec " + this.mWorkSpecId);
            Intent stopWork = CommandHandler.createStopWorkIntent(this.mContext, this.mWorkSpecId);
            this.mMainThreadExecutor.execute(new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, stopWork, this.mStartId));
            if (this.mDispatcher.getProcessor().isEnqueued(this.mWorkSpecId)) {
                Logger.get().debug(TAG, "WorkSpec " + this.mWorkSpecId + " needs to be rescheduled");
                Intent reschedule = CommandHandler.createScheduleWorkIntent(this.mContext, this.mWorkSpecId);
                this.mMainThreadExecutor.execute(new SystemAlarmDispatcher.AddRunnable(this.mDispatcher, reschedule, this.mStartId));
            } else {
                Logger.get().debug(TAG, "Processor does not have WorkSpec " + this.mWorkSpecId + ". No need to reschedule");
            }
        } else {
            Logger.get().debug(TAG, "Already stopped work for " + this.mWorkSpecId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Object object = this.mLock;
        synchronized (object) {
            this.mWorkConstraintsTracker.reset();
            this.mDispatcher.getWorkTimer().stopTimer(this.mWorkSpecId);
            if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
                Logger.get().debug(TAG, "Releasing wakelock " + this.mWakeLock + "for WorkSpec " + this.mWorkSpecId);
                this.mWakeLock.release();
            }
        }
    }
}

