/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class Logger {
    private static final Object sLock = new Object();
    private static volatile Logger sLogger;
    private static final String TAG_PREFIX = "WM-";
    private static final int MAX_TAG_LENGTH = 23;
    private static final int MAX_PREFIXED_TAG_LENGTH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogger(@NonNull Logger logger) {
        Object object = sLock;
        synchronized (object) {
            sLogger = logger;
        }
    }

    @NonNull
    public static String tagWithPrefix(@NonNull String tag) {
        int length = tag.length();
        StringBuilder withPrefix = new StringBuilder(23);
        withPrefix.append(TAG_PREFIX);
        if (length >= MAX_PREFIXED_TAG_LENGTH) {
            withPrefix.append(tag.substring(0, MAX_PREFIXED_TAG_LENGTH));
        } else {
            withPrefix.append(tag);
        }
        return withPrefix.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Logger get() {
        Object object = sLock;
        synchronized (object) {
            if (sLogger == null) {
                sLogger = new LogcatLogger(3);
            }
            return sLogger;
        }
    }

    public Logger(int loggingLevel) {
    }

    public abstract void verbose(@NonNull String var1, @NonNull String var2);

    public abstract void verbose(@NonNull String var1, @NonNull String var2, @NonNull Throwable var3);

    public abstract void debug(@NonNull String var1, @NonNull String var2);

    public abstract void debug(@NonNull String var1, @NonNull String var2, @NonNull Throwable var3);

    public abstract void info(@NonNull String var1, @NonNull String var2);

    public abstract void info(@NonNull String var1, @NonNull String var2, @NonNull Throwable var3);

    public abstract void warning(@NonNull String var1, @NonNull String var2);

    public abstract void warning(@NonNull String var1, @NonNull String var2, @NonNull Throwable var3);

    public abstract void error(@NonNull String var1, @NonNull String var2);

    public abstract void error(@NonNull String var1, @NonNull String var2, @NonNull Throwable var3);

    static {
        MAX_PREFIXED_TAG_LENGTH = 23 - TAG_PREFIX.length();
    }

    public static class LogcatLogger
    extends Logger {
        private final int mLoggingLevel;

        public LogcatLogger(int loggingLevel) {
            super(loggingLevel);
            this.mLoggingLevel = loggingLevel;
        }

        @Override
        public void verbose(@NonNull String tag, @NonNull String message) {
            if (this.mLoggingLevel <= 2) {
                Log.v((String)tag, (String)message);
            }
        }

        @Override
        public void verbose(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
            if (this.mLoggingLevel <= 2) {
                Log.v((String)tag, (String)message, (Throwable)throwable);
            }
        }

        @Override
        public void debug(@NonNull String tag, @NonNull String message) {
            if (this.mLoggingLevel <= 3) {
                Log.d((String)tag, (String)message);
            }
        }

        @Override
        public void debug(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
            if (this.mLoggingLevel <= 3) {
                Log.d((String)tag, (String)message, (Throwable)throwable);
            }
        }

        @Override
        public void info(@NonNull String tag, @NonNull String message) {
            if (this.mLoggingLevel <= 4) {
                Log.i((String)tag, (String)message);
            }
        }

        @Override
        public void info(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
            if (this.mLoggingLevel <= 4) {
                Log.i((String)tag, (String)message, (Throwable)throwable);
            }
        }

        @Override
        public void warning(@NonNull String tag, @NonNull String message) {
            if (this.mLoggingLevel <= 5) {
                Log.w((String)tag, (String)message);
            }
        }

        @Override
        public void warning(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
            if (this.mLoggingLevel <= 5) {
                Log.w((String)tag, (String)message, (Throwable)throwable);
            }
        }

        @Override
        public void error(@NonNull String tag, @NonNull String message) {
            if (this.mLoggingLevel <= 6) {
                Log.e((String)tag, (String)message);
            }
        }

        @Override
        public void error(@NonNull String tag, @NonNull String message, @NonNull Throwable throwable) {
            if (this.mLoggingLevel <= 6) {
                Log.e((String)tag, (String)message, (Throwable)throwable);
            }
        }
    }
}

