/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class WorkInfo {
    @NonNull
    private UUID mId;
    @NonNull
    private State mState;
    @NonNull
    private Data mOutputData;
    @NonNull
    private Set<String> mTags;
    @NonNull
    private Data mProgress;
    private int mRunAttemptCount;
    private final int mGeneration;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public WorkInfo(@NonNull UUID id, @NonNull State state, @NonNull Data outputData, @NonNull List<String> tags, @NonNull Data progress, int runAttemptCount, int generation) {
        this.mId = id;
        this.mState = state;
        this.mOutputData = outputData;
        this.mTags = new HashSet<String>(tags);
        this.mProgress = progress;
        this.mRunAttemptCount = runAttemptCount;
        this.mGeneration = generation;
    }

    @NonNull
    public UUID getId() {
        return this.mId;
    }

    @NonNull
    public State getState() {
        return this.mState;
    }

    @NonNull
    public Data getOutputData() {
        return this.mOutputData;
    }

    @NonNull
    public Set<String> getTags() {
        return this.mTags;
    }

    @NonNull
    public Data getProgress() {
        return this.mProgress;
    }

    @IntRange(from=0L)
    public int getRunAttemptCount() {
        return this.mRunAttemptCount;
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkInfo workInfo = (WorkInfo)o;
        if (this.mRunAttemptCount != workInfo.mRunAttemptCount) {
            return false;
        }
        if (!this.mId.equals(workInfo.mId)) {
            return false;
        }
        if (this.mState != workInfo.mState) {
            return false;
        }
        if (!this.mOutputData.equals(workInfo.mOutputData)) {
            return false;
        }
        if (!this.mTags.equals(workInfo.mTags)) {
            return false;
        }
        return this.mProgress.equals(workInfo.mProgress);
    }

    public int hashCode() {
        int result = this.mId.hashCode();
        result = 31 * result + this.mState.hashCode();
        result = 31 * result + this.mOutputData.hashCode();
        result = 31 * result + this.mTags.hashCode();
        result = 31 * result + this.mProgress.hashCode();
        result = 31 * result + this.mRunAttemptCount;
        return result;
    }

    public String toString() {
        return "WorkInfo{mId='" + this.mId + '\'' + ", mState=" + (Object)((Object)this.mState) + ", mOutputData=" + this.mOutputData + ", mTags=" + this.mTags + ", mProgress=" + this.mProgress + '}';
    }

    public static enum State {
        ENQUEUED,
        RUNNING,
        SUCCEEDED,
        FAILED,
        BLOCKED,
        CANCELLED;


        public boolean isFinished() {
            return this == SUCCEEDED || this == FAILED || this == CANCELLED;
        }
    }
}

