/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import java.lang.reflect.Constructor;

public abstract class WorkerFactory {
    private static final String TAG = Logger.tagWithPrefix("WorkerFactory");

    @Nullable
    public abstract ListenableWorker createWorker(@NonNull Context var1, @NonNull String var2, @NonNull WorkerParameters var3);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final ListenableWorker createWorkerWithDefaultFallback(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        ListenableWorker worker = this.createWorker(appContext, workerClassName, workerParameters);
        if (worker == null) {
            Class<ListenableWorker> clazz = null;
            try {
                clazz = Class.forName(workerClassName).asSubclass(ListenableWorker.class);
            }
            catch (Throwable throwable) {
                Logger.get().error(TAG, "Invalid class: " + workerClassName, throwable);
            }
            if (clazz != null) {
                try {
                    Constructor<ListenableWorker> constructor = clazz.getDeclaredConstructor(Context.class, WorkerParameters.class);
                    worker = constructor.newInstance(appContext, workerParameters);
                }
                catch (Throwable e) {
                    Logger.get().error(TAG, "Could not instantiate " + workerClassName, e);
                }
            }
        }
        if (worker != null && worker.isUsed()) {
            String factoryName = this.getClass().getName();
            String message = "WorkerFactory (" + factoryName + ") returned an instance of a ListenableWorker (" + workerClassName + ") which has already been invoked. createWorker() must always return a new instance of a ListenableWorker.";
            throw new IllegalStateException(message);
        }
        return worker;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static WorkerFactory getDefaultWorkerFactory() {
        return new WorkerFactory(){

            @Override
            @Nullable
            public ListenableWorker createWorker(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
                return null;
            }
        };
    }
}

