/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.work.Clock;
import androidx.work.Logger;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.StartStopTokens;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemalarm.Alarms;
import androidx.work.impl.background.systemalarm.ConstraintsCommandHandler;
import androidx.work.impl.background.systemalarm.DelayMetCommandHandler;
import androidx.work.impl.background.systemalarm.SystemAlarmDispatcher;
import androidx.work.impl.background.systemalarm.SystemAlarmService;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CommandHandler
implements ExecutionListener {
    private static final String TAG = Logger.tagWithPrefix("CommandHandler");
    static final String ACTION_SCHEDULE_WORK = "ACTION_SCHEDULE_WORK";
    static final String ACTION_DELAY_MET = "ACTION_DELAY_MET";
    static final String ACTION_STOP_WORK = "ACTION_STOP_WORK";
    static final String ACTION_CONSTRAINTS_CHANGED = "ACTION_CONSTRAINTS_CHANGED";
    static final String ACTION_RESCHEDULE = "ACTION_RESCHEDULE";
    static final String ACTION_EXECUTION_COMPLETED = "ACTION_EXECUTION_COMPLETED";
    private static final String KEY_WORKSPEC_ID = "KEY_WORKSPEC_ID";
    private static final String KEY_WORKSPEC_GENERATION = "KEY_WORKSPEC_GENERATION";
    private static final String KEY_NEEDS_RESCHEDULE = "KEY_NEEDS_RESCHEDULE";
    static final long WORK_PROCESSING_TIME_IN_MS = 600000L;
    private final Context mContext;
    private final Map<WorkGenerationalId, DelayMetCommandHandler> mPendingDelayMet;
    private final Object mLock;
    private final Clock mClock;
    private final StartStopTokens mStartStopTokens;

    static Intent createScheduleWorkIntent(@NonNull Context context, @NonNull WorkGenerationalId id) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_SCHEDULE_WORK);
        return CommandHandler.writeWorkGenerationalId(intent, id);
    }

    private static Intent writeWorkGenerationalId(@NonNull Intent intent, @NonNull WorkGenerationalId id) {
        intent.putExtra(KEY_WORKSPEC_ID, id.getWorkSpecId());
        intent.putExtra(KEY_WORKSPEC_GENERATION, id.getGeneration());
        return intent;
    }

    static WorkGenerationalId readWorkGenerationalId(@NonNull Intent intent) {
        return new WorkGenerationalId(intent.getStringExtra(KEY_WORKSPEC_ID), intent.getIntExtra(KEY_WORKSPEC_GENERATION, 0));
    }

    static Intent createDelayMetIntent(@NonNull Context context, @NonNull WorkGenerationalId id) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_DELAY_MET);
        return CommandHandler.writeWorkGenerationalId(intent, id);
    }

    static Intent createStopWorkIntent(@NonNull Context context, @NonNull String workSpecId) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_STOP_WORK);
        intent.putExtra(KEY_WORKSPEC_ID, workSpecId);
        return intent;
    }

    static Intent createStopWorkIntent(@NonNull Context context, @NonNull WorkGenerationalId id) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_STOP_WORK);
        return CommandHandler.writeWorkGenerationalId(intent, id);
    }

    static Intent createConstraintsChangedIntent(@NonNull Context context) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_CONSTRAINTS_CHANGED);
        return intent;
    }

    static Intent createRescheduleIntent(@NonNull Context context) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_RESCHEDULE);
        return intent;
    }

    static Intent createExecutionCompletedIntent(@NonNull Context context, @NonNull WorkGenerationalId id, boolean needsReschedule) {
        Intent intent = new Intent(context, SystemAlarmService.class);
        intent.setAction(ACTION_EXECUTION_COMPLETED);
        intent.putExtra(KEY_NEEDS_RESCHEDULE, needsReschedule);
        return CommandHandler.writeWorkGenerationalId(intent, id);
    }

    CommandHandler(@NonNull Context context, Clock clock, @NonNull StartStopTokens startStopTokens) {
        this.mContext = context;
        this.mClock = clock;
        this.mStartStopTokens = startStopTokens;
        this.mPendingDelayMet = new HashMap<WorkGenerationalId, DelayMetCommandHandler>();
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        Object object = this.mLock;
        synchronized (object) {
            DelayMetCommandHandler listener2 = this.mPendingDelayMet.remove(id);
            this.mStartStopTokens.remove(id);
            if (listener2 != null) {
                listener2.onExecuted(needsReschedule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPendingCommands() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mPendingDelayMet.isEmpty();
        }
    }

    @WorkerThread
    void onHandleIntent(@NonNull Intent intent, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        String action = intent.getAction();
        if (ACTION_CONSTRAINTS_CHANGED.equals(action)) {
            this.handleConstraintsChanged(intent, startId, dispatcher);
        } else if (ACTION_RESCHEDULE.equals(action)) {
            this.handleReschedule(intent, startId, dispatcher);
        } else {
            Bundle extras = intent.getExtras();
            if (!CommandHandler.hasKeys(extras, KEY_WORKSPEC_ID)) {
                Logger.get().error(TAG, "Invalid request for " + action + " , requires " + KEY_WORKSPEC_ID + " .");
            } else if (ACTION_SCHEDULE_WORK.equals(action)) {
                this.handleScheduleWorkIntent(intent, startId, dispatcher);
            } else if (ACTION_DELAY_MET.equals(action)) {
                this.handleDelayMet(intent, startId, dispatcher);
            } else if (ACTION_STOP_WORK.equals(action)) {
                this.handleStopWork(intent, dispatcher);
            } else if (ACTION_EXECUTION_COMPLETED.equals(action)) {
                this.handleExecutionCompleted(intent, startId);
            } else {
                Logger.get().warning(TAG, "Ignoring intent " + intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleScheduleWorkIntent(@NonNull Intent intent, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        WorkGenerationalId id = CommandHandler.readWorkGenerationalId(intent);
        Logger.get().debug(TAG, "Handling schedule work for " + id);
        WorkManagerImpl workManager = dispatcher.getWorkManager();
        WorkDatabase workDatabase = workManager.getWorkDatabase();
        workDatabase.beginTransaction();
        try {
            WorkSpecDao workSpecDao = workDatabase.workSpecDao();
            WorkSpec workSpec = workSpecDao.getWorkSpec(id.getWorkSpecId());
            if (workSpec == null) {
                Logger.get().warning(TAG, "Skipping scheduling " + id + " because it's no longer in the DB");
                return;
            }
            if (workSpec.state.isFinished()) {
                Logger.get().warning(TAG, "Skipping scheduling " + id + "because it is finished.");
                return;
            }
            long triggerAt = workSpec.calculateNextRunTime();
            if (!workSpec.hasConstraints()) {
                Logger.get().debug(TAG, "Setting up Alarms for " + id + "at " + triggerAt);
                Alarms.setAlarm(this.mContext, workDatabase, id, triggerAt);
            } else {
                Logger.get().debug(TAG, "Opportunistically setting an alarm for " + id + "at " + triggerAt);
                Alarms.setAlarm(this.mContext, workDatabase, id, triggerAt);
                Intent constraintsUpdate = CommandHandler.createConstraintsChangedIntent(this.mContext);
                dispatcher.getTaskExecutor().getMainThreadExecutor().execute(new SystemAlarmDispatcher.AddRunnable(dispatcher, constraintsUpdate, startId));
            }
            workDatabase.setTransactionSuccessful();
        }
        finally {
            workDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDelayMet(@NonNull Intent intent, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        Object object = this.mLock;
        synchronized (object) {
            WorkGenerationalId id = CommandHandler.readWorkGenerationalId(intent);
            Logger.get().debug(TAG, "Handing delay met for " + id);
            if (!this.mPendingDelayMet.containsKey(id)) {
                DelayMetCommandHandler delayMetCommandHandler = new DelayMetCommandHandler(this.mContext, startId, dispatcher, this.mStartStopTokens.tokenFor(id));
                this.mPendingDelayMet.put(id, delayMetCommandHandler);
                delayMetCommandHandler.handleProcessWork();
            } else {
                Logger.get().debug(TAG, "WorkSpec " + id + " is is already being handled for ACTION_DELAY_MET");
            }
        }
    }

    private void handleStopWork(@NonNull Intent intent, @NonNull SystemAlarmDispatcher dispatcher) {
        List<StartStopToken> tokens;
        Bundle extras = intent.getExtras();
        String workSpecId = extras.getString(KEY_WORKSPEC_ID);
        if (extras.containsKey(KEY_WORKSPEC_GENERATION)) {
            int generation = extras.getInt(KEY_WORKSPEC_GENERATION);
            tokens = new ArrayList<StartStopToken>(1);
            StartStopToken id = this.mStartStopTokens.remove(new WorkGenerationalId(workSpecId, generation));
            if (id != null) {
                tokens.add(id);
            }
        } else {
            tokens = this.mStartStopTokens.remove(workSpecId);
        }
        for (StartStopToken token : tokens) {
            Logger.get().debug(TAG, "Handing stopWork work for " + workSpecId);
            dispatcher.getWorkerLauncher().stopWork(token);
            Alarms.cancelAlarm(this.mContext, dispatcher.getWorkManager().getWorkDatabase(), token.getId());
            dispatcher.onExecuted(token.getId(), false);
        }
    }

    private void handleConstraintsChanged(@NonNull Intent intent, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        Logger.get().debug(TAG, "Handling constraints changed " + intent);
        ConstraintsCommandHandler changedCommandHandler = new ConstraintsCommandHandler(this.mContext, this.mClock, startId, dispatcher);
        changedCommandHandler.handleConstraintsChanged();
    }

    private void handleReschedule(@NonNull Intent intent, int startId, @NonNull SystemAlarmDispatcher dispatcher) {
        Logger.get().debug(TAG, "Handling reschedule " + intent + ", " + startId);
        dispatcher.getWorkManager().rescheduleEligibleWork();
    }

    private void handleExecutionCompleted(@NonNull Intent intent, int startId) {
        WorkGenerationalId id = CommandHandler.readWorkGenerationalId(intent);
        boolean needsReschedule = intent.getExtras().getBoolean(KEY_NEEDS_RESCHEDULE);
        Logger.get().debug(TAG, "Handling onExecutionCompleted " + intent + ", " + startId);
        this.onExecuted(id, needsReschedule);
    }

    private static boolean hasKeys(@Nullable Bundle bundle, String ... keys) {
        if (bundle == null || bundle.isEmpty()) {
            return false;
        }
        for (String key : keys) {
            if (bundle.get(key) != null) continue;
            return false;
        }
        return true;
    }
}

