/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.Scheduler;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecKt;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SystemAlarmScheduler
implements Scheduler {
    private static final String TAG = Logger.tagWithPrefix("SystemAlarmScheduler");
    private final Context mContext;

    public SystemAlarmScheduler(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    @Override
    public void schedule(WorkSpec ... workSpecs) {
        for (WorkSpec workSpec : workSpecs) {
            this.scheduleWorkSpec(workSpec);
        }
    }

    @Override
    public void cancel(@NonNull String workSpecId) {
        Intent cancelIntent = CommandHandler.createStopWorkIntent(this.mContext, workSpecId);
        this.mContext.startService(cancelIntent);
    }

    @Override
    public boolean hasLimitedSchedulingSlots() {
        return true;
    }

    private void scheduleWorkSpec(@NonNull WorkSpec workSpec) {
        Logger.get().debug(TAG, "Scheduling work with workSpecId " + workSpec.id);
        Intent scheduleIntent = CommandHandler.createScheduleWorkIntent(this.mContext, WorkSpecKt.generationalId(workSpec));
        this.mContext.startService(scheduleIntent);
    }
}

