/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.RawQueries;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class StatusRunnable<T>
implements Runnable {
    private final SettableFuture<T> mFuture = SettableFuture.create();

    @Override
    public void run() {
        try {
            T value = this.runInternal();
            this.mFuture.set(value);
        }
        catch (Throwable throwable) {
            this.mFuture.setException(throwable);
        }
    }

    @WorkerThread
    abstract T runInternal();

    @NonNull
    public ListenableFuture<T> getFuture() {
        return this.mFuture;
    }

    @NonNull
    public static StatusRunnable<List<WorkInfo>> forStringIds(final @NonNull WorkManagerImpl workManager, final @NonNull List<String> ids) {
        return new StatusRunnable<List<WorkInfo>>(){

            @Override
            public List<WorkInfo> runInternal() {
                WorkDatabase workDatabase = workManager.getWorkDatabase();
                List<WorkSpec.WorkInfoPojo> workInfoPojos = workDatabase.workSpecDao().getWorkStatusPojoForIds(ids);
                return (List)WorkSpec.WORK_INFO_MAPPER.apply(workInfoPojos);
            }
        };
    }

    @NonNull
    public static StatusRunnable<WorkInfo> forUUID(final @NonNull WorkManagerImpl workManager, final @NonNull UUID id) {
        return new StatusRunnable<WorkInfo>(){

            @Override
            WorkInfo runInternal() {
                WorkDatabase workDatabase = workManager.getWorkDatabase();
                WorkSpec.WorkInfoPojo workInfoPojo = workDatabase.workSpecDao().getWorkStatusPojoForId(id.toString());
                return workInfoPojo != null ? workInfoPojo.toWorkInfo() : null;
            }
        };
    }

    @NonNull
    public static StatusRunnable<List<WorkInfo>> forTag(final @NonNull WorkManagerImpl workManager, final @NonNull String tag) {
        return new StatusRunnable<List<WorkInfo>>(){

            @Override
            List<WorkInfo> runInternal() {
                WorkDatabase workDatabase = workManager.getWorkDatabase();
                List<WorkSpec.WorkInfoPojo> workInfoPojos = workDatabase.workSpecDao().getWorkStatusPojoForTag(tag);
                return (List)WorkSpec.WORK_INFO_MAPPER.apply(workInfoPojos);
            }
        };
    }

    @NonNull
    public static StatusRunnable<List<WorkInfo>> forUniqueWork(final @NonNull WorkManagerImpl workManager, final @NonNull String name) {
        return new StatusRunnable<List<WorkInfo>>(){

            @Override
            List<WorkInfo> runInternal() {
                WorkDatabase workDatabase = workManager.getWorkDatabase();
                List<WorkSpec.WorkInfoPojo> workInfoPojos = workDatabase.workSpecDao().getWorkStatusPojoForName(name);
                return (List)WorkSpec.WORK_INFO_MAPPER.apply(workInfoPojos);
            }
        };
    }

    @NonNull
    public static StatusRunnable<List<WorkInfo>> forWorkQuerySpec(final @NonNull WorkManagerImpl workManager, final @NonNull WorkQuery querySpec) {
        return new StatusRunnable<List<WorkInfo>>(){

            @Override
            List<WorkInfo> runInternal() {
                WorkDatabase workDatabase = workManager.getWorkDatabase();
                List<WorkSpec.WorkInfoPojo> workInfoPojos = workDatabase.rawWorkInfoDao().getWorkInfoPojos(RawQueries.toRawQuery(querySpec));
                return (List)WorkSpec.WORK_INFO_MAPPER.apply(workInfoPojos);
            }
        };
    }
}

