/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/work/lint/InvalidPeriodicWorkRequestIntervalDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Companion", "work-runtime-lint"})
public final class InvalidPeriodicWorkRequestIntervalDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"androidx.work.PeriodicWorkRequest.Builder");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Long l;
        UCallExpression callExpression;
        UExpression timeUnitType;
        UExpression units;
        String type;
        UExpression repeatInterval;
        block51: {
            Long l2;
            Object v3;
            Object object;
            Object object22;
            block50: {
                Object object3;
                block49: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
                    if (node.getValueArgumentCount() < 2) return;
                    Iterable iterable = node.getValueArguments();
                    for (Object object22 : iterable) {
                        UExpression uExpression = (UExpression)object22;
                        boolean bl = false;
                        PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)uExpression);
                        if (!Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"repeatInterval")) continue;
                        object3 = object22;
                        break block49;
                    }
                    object3 = null;
                }
                UExpression uExpression = (UExpression)object3;
                repeatInterval = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                object = node.getValueArguments();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    Object e = object22.next();
                    UExpression uExpression2 = (UExpression)e;
                    boolean bl = false;
                    PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)uExpression2);
                    if (!Intrinsics.areEqual((Object)(psiParameter != null ? psiParameter.getName() : null), (Object)"repeatIntervalTimeUnit")) continue;
                    v3 = e;
                    break block50;
                }
                v3 = null;
            }
            UExpression uExpression = v3;
            UExpression timeUnit = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
            UExpression uExpression3 = repeatInterval;
            String string = uExpression3 != null && (uExpression3 = uExpression3.getExpressionType()) != null ? uExpression3.getCanonicalText() : (type = null);
            if (!Intrinsics.areEqual((Object)"long", (Object)type)) break block51;
            object = repeatInterval.evaluate();
            Long value = object instanceof Long ? (Long)object : null;
            UExpression uExpression4 = timeUnit;
            object22 = uExpression4 != null ? uExpression4.evaluate() : null;
            units = object22 instanceof Pair ? (Pair)object22 : null;
            if (value == null) return;
            if (units == null) return;
            timeUnitType = (Name)units.component2();
            switch (timeUnitType.getIdentifier()) {
                case "NANOSECONDS": {
                    l2 = TimeUnit.MINUTES.convert(value, TimeUnit.NANOSECONDS);
                    break;
                }
                case "MICROSECONDS": {
                    l2 = TimeUnit.MINUTES.convert(value, TimeUnit.MICROSECONDS);
                    break;
                }
                case "MILLISECONDS": {
                    l2 = TimeUnit.MINUTES.convert(value, TimeUnit.MILLISECONDS);
                    break;
                }
                case "SECONDS": {
                    l2 = TimeUnit.MINUTES.convert(value, TimeUnit.SECONDS);
                    break;
                }
                case "MINUTES": {
                    l2 = value;
                    break;
                }
                case "HOURS": {
                    l2 = TimeUnit.MINUTES.convert(value, TimeUnit.HOURS);
                    break;
                }
                case "DAYS": {
                    l2 = TimeUnit.MINUTES.convert(value, TimeUnit.DAYS);
                    break;
                }
                default: {
                    return;
                }
            }
            Long l3 = l2;
            if (l3 == null) return;
            if (l3 >= 15L) return;
            Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)"Interval duration for `PeriodicWorkRequest`s must be at least 15 \\\nminutes.", null, (int)8, null);
            return;
        }
        if (!Intrinsics.areEqual((Object)"java.time.Duration", (Object)type)) return;
        units = repeatInterval;
        Object object = units instanceof UCallExpression ? (UCallExpression)repeatInterval : (units instanceof UQualifiedReferenceExpression ? ((timeUnitType = ((UQualifiedReferenceExpression)repeatInterval).getSelector()) instanceof UCallExpression ? (UCallExpression)timeUnitType : null) : null);
        UCallExpression uCallExpression = callExpression = object;
        String unit = uCallExpression != null ? uCallExpression.getMethodName() : null;
        Object object4 = callExpression;
        Object object5 = object4 != null && (object4 = object4.getValueArguments()) != null && (object4 = (UExpression)CollectionsKt.firstOrNull((List)object4)) != null ? object4.evaluate() : null;
        if (!(object5 instanceof Long)) return;
        Long l4 = (Long)object5;
        Long value = l4;
        if (value == null) return;
        String string = unit;
        if (string == null) return;
        int n = -1;
        switch (string.hashCode()) {
            case -1480747267: {
                if (string.equals("ofMillis")) {
                    n = 1;
                }
                break;
            }
            case -2046171992: {
                if (string.equals("ofSeconds")) {
                    n = 2;
                }
                break;
            }
            case -1571099480: {
                if (string.equals("ofNanos")) {
                    n = 3;
                }
                break;
            }
            case -1576216712: {
                if (string.equals("ofHours")) {
                    n = 4;
                }
                break;
            }
            case -1020809522: {
                if (string.equals("ofDays")) {
                    n = 5;
                }
                break;
            }
            case 1343600392: {
                if (string.equals("ofMinutes")) {
                    n = 6;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                l = TimeUnit.MINUTES.convert(value, TimeUnit.NANOSECONDS);
                break;
            }
            case 1: {
                l = TimeUnit.MINUTES.convert(value, TimeUnit.MILLISECONDS);
                break;
            }
            case 2: {
                l = TimeUnit.MINUTES.convert(value, TimeUnit.SECONDS);
                break;
            }
            case 6: {
                l = value;
                break;
            }
            case 4: {
                l = TimeUnit.MINUTES.convert(value, TimeUnit.HOURS);
                break;
            }
            case 5: {
                l = TimeUnit.MINUTES.convert(value, TimeUnit.DAYS);
                break;
            }
            default: {
                return;
            }
        }
        Long l5 = l;
        if (l5 == null) return;
        if (l5 >= 15L) return;
        Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)node), (String)"Interval duration for `PeriodicWorkRequest`s must be at least 15 \\\nminutes.", null, (int)8, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(InvalidPeriodicWorkRequestIntervalDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"InvalidPeriodicWorkRequestInterval", (String)"Invalid interval duration", (String)"\n                The interval duration for a `PeriodicWorkRequest` must be at least 15 minutes.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/lint/InvalidPeriodicWorkRequestIntervalDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

