/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.work.ListenableWorker;
import androidx.work.WorkRequest;
import androidx.work.impl.utils.DurationApi26Impl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00062\u00020\u0001:\u0002\u0005\u0006B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0007"}, d2={"Landroidx/work/PeriodicWorkRequest;", "Landroidx/work/WorkRequest;", "builder", "Landroidx/work/PeriodicWorkRequest$Builder;", "(Landroidx/work/PeriodicWorkRequest$Builder;)V", "Builder", "Companion", "work-runtime_release"})
public final class PeriodicWorkRequest
extends WorkRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MIN_PERIODIC_INTERVAL_MILLIS = 900000L;
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MIN_PERIODIC_FLEX_MILLIS = 300000L;

    public PeriodicWorkRequest(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(builder.getId$work_runtime_release(), builder.getWorkSpec$work_runtime_release(), builder.getTags$work_runtime_release());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B)\b\u0016\u0012\u0010\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB9\b\u0016\u0012\u0010\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fB)\b\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0014\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0007R\u0014\u0010\u0011\u001a\u00020\u00008PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Landroidx/work/PeriodicWorkRequest$Builder;", "Landroidx/work/WorkRequest$Builder;", "Landroidx/work/PeriodicWorkRequest;", "workerClass", "Ljava/lang/Class;", "Landroidx/work/ListenableWorker;", "repeatInterval", "", "repeatIntervalTimeUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/lang/Class;JLjava/util/concurrent/TimeUnit;)V", "Ljava/time/Duration;", "(Ljava/lang/Class;Ljava/time/Duration;)V", "flexInterval", "flexIntervalTimeUnit", "(Ljava/lang/Class;JLjava/util/concurrent/TimeUnit;JLjava/util/concurrent/TimeUnit;)V", "(Ljava/lang/Class;Ljava/time/Duration;Ljava/time/Duration;)V", "thisObject", "getThisObject$work_runtime_release", "()Landroidx/work/PeriodicWorkRequest$Builder;", "buildInternal", "buildInternal$work_runtime_release", "clearNextScheduleTimeOverride", "setNextScheduleTimeOverride", "nextScheduleTimeOverrideMillis", "work-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nPeriodicWorkRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeriodicWorkRequest.kt\nandroidx/work/PeriodicWorkRequest$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
    public static final class Builder
    extends WorkRequest.Builder<Builder, PeriodicWorkRequest> {
        public Builder(@NotNull Class<? extends ListenableWorker> workerClass, long repeatInterval, @NotNull TimeUnit repeatIntervalTimeUnit) {
            Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
            Intrinsics.checkNotNullParameter((Object)((Object)repeatIntervalTimeUnit), (String)"repeatIntervalTimeUnit");
            super(workerClass);
            this.getWorkSpec$work_runtime_release().setPeriodic(repeatIntervalTimeUnit.toMillis(repeatInterval));
        }

        @RequiresApi(value=26)
        public Builder(@NotNull Class<? extends ListenableWorker> workerClass, @NotNull Duration repeatInterval) {
            Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
            Intrinsics.checkNotNullParameter((Object)repeatInterval, (String)"repeatInterval");
            super(workerClass);
            this.getWorkSpec$work_runtime_release().setPeriodic(DurationApi26Impl.toMillisCompat(repeatInterval));
        }

        public Builder(@NotNull Class<? extends ListenableWorker> workerClass, long repeatInterval, @NotNull TimeUnit repeatIntervalTimeUnit, long flexInterval, @NotNull TimeUnit flexIntervalTimeUnit) {
            Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
            Intrinsics.checkNotNullParameter((Object)((Object)repeatIntervalTimeUnit), (String)"repeatIntervalTimeUnit");
            Intrinsics.checkNotNullParameter((Object)((Object)flexIntervalTimeUnit), (String)"flexIntervalTimeUnit");
            super(workerClass);
            this.getWorkSpec$work_runtime_release().setPeriodic(repeatIntervalTimeUnit.toMillis(repeatInterval), flexIntervalTimeUnit.toMillis(flexInterval));
        }

        @RequiresApi(value=26)
        public Builder(@NotNull Class<? extends ListenableWorker> workerClass, @NotNull Duration repeatInterval, @NotNull Duration flexInterval) {
            Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
            Intrinsics.checkNotNullParameter((Object)repeatInterval, (String)"repeatInterval");
            Intrinsics.checkNotNullParameter((Object)flexInterval, (String)"flexInterval");
            super(workerClass);
            this.getWorkSpec$work_runtime_release().setPeriodic(DurationApi26Impl.toMillisCompat(repeatInterval), DurationApi26Impl.toMillisCompat(flexInterval));
        }

        @NotNull
        public final Builder setNextScheduleTimeOverride(long nextScheduleTimeOverrideMillis) {
            if (!(nextScheduleTimeOverrideMillis != Long.MAX_VALUE)) {
                boolean bl = false;
                String string = "Cannot set Long.MAX_VALUE as the schedule override time";
                throw new IllegalArgumentException(string.toString());
            }
            this.getWorkSpec$work_runtime_release().setNextScheduleTimeOverride(nextScheduleTimeOverrideMillis);
            this.getWorkSpec$work_runtime_release().setNextScheduleTimeOverrideGeneration(1);
            return this;
        }

        @NotNull
        public final Builder clearNextScheduleTimeOverride() {
            this.getWorkSpec$work_runtime_release().setNextScheduleTimeOverride(Long.MAX_VALUE);
            this.getWorkSpec$work_runtime_release().setNextScheduleTimeOverrideGeneration(1);
            return this;
        }

        @Override
        @NotNull
        public PeriodicWorkRequest buildInternal$work_runtime_release() {
            if (!(!this.getBackoffCriteriaSet$work_runtime_release() || Build.VERSION.SDK_INT < 23 || !this.getWorkSpec$work_runtime_release().constraints.requiresDeviceIdle())) {
                boolean $i$a$-require-PeriodicWorkRequest$Builder$buildInternal$32 = false;
                String $i$a$-require-PeriodicWorkRequest$Builder$buildInternal$32 = "Cannot set backoff criteria on an idle mode job";
                throw new IllegalArgumentException($i$a$-require-PeriodicWorkRequest$Builder$buildInternal$32.toString());
            }
            if (!(!this.getWorkSpec$work_runtime_release().expedited)) {
                boolean bl = false;
                String string = "PeriodicWorkRequests cannot be expedited";
                throw new IllegalArgumentException(string.toString());
            }
            return new PeriodicWorkRequest(this);
        }

        @Override
        @NotNull
        public Builder getThisObject$work_runtime_release() {
            return this;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/work/PeriodicWorkRequest$Companion;", "", "()V", "MIN_PERIODIC_FLEX_MILLIS", "", "MIN_PERIODIC_INTERVAL_MILLIS", "work-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

