/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.net.Uri;
import android.os.Build;
import androidx.room.TypeConverter;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OutOfQuotaPolicy;
import androidx.work.WorkInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J\u0016\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0013H\u0007\u00a8\u0006 "}, d2={"Landroidx/work/impl/model/WorkTypeConverters;", "", "()V", "backoffPolicyToInt", "", "backoffPolicy", "Landroidx/work/BackoffPolicy;", "byteArrayToSetOfTriggers", "", "Landroidx/work/Constraints$ContentUriTrigger;", "bytes", "", "intToBackoffPolicy", "value", "intToNetworkType", "Landroidx/work/NetworkType;", "intToOutOfQuotaPolicy", "Landroidx/work/OutOfQuotaPolicy;", "intToState", "Landroidx/work/WorkInfo$State;", "networkTypeToInt", "networkType", "outOfQuotaPolicyToInt", "policy", "setOfTriggersToByteArray", "triggers", "stateToInt", "state", "BackoffPolicyIds", "NetworkTypeIds", "OutOfPolicyIds", "StateIds", "work-runtime_release"})
public final class WorkTypeConverters {
    @NotNull
    public static final WorkTypeConverters INSTANCE = new WorkTypeConverters();

    private WorkTypeConverters() {
    }

    @JvmStatic
    @TypeConverter
    public static final int stateToInt(@NotNull WorkInfo.State state) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @JvmStatic
    @TypeConverter
    @NotNull
    public static final WorkInfo.State intToState(int value) {
        WorkInfo.State state;
        switch (value) {
            case 0: {
                state = WorkInfo.State.ENQUEUED;
                break;
            }
            case 1: {
                state = WorkInfo.State.RUNNING;
                break;
            }
            case 2: {
                state = WorkInfo.State.SUCCEEDED;
                break;
            }
            case 3: {
                state = WorkInfo.State.FAILED;
                break;
            }
            case 4: {
                state = WorkInfo.State.BLOCKED;
                break;
            }
            case 5: {
                state = WorkInfo.State.CANCELLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not convert " + value + " to State");
            }
        }
        return state;
    }

    @JvmStatic
    @TypeConverter
    public static final int backoffPolicyToInt(@NotNull BackoffPolicy backoffPolicy) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)backoffPolicy), (String)"backoffPolicy");
        switch (WhenMappings.$EnumSwitchMapping$1[backoffPolicy.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @JvmStatic
    @TypeConverter
    @NotNull
    public static final BackoffPolicy intToBackoffPolicy(int value) {
        BackoffPolicy backoffPolicy;
        switch (value) {
            case 0: {
                backoffPolicy = BackoffPolicy.EXPONENTIAL;
                break;
            }
            case 1: {
                backoffPolicy = BackoffPolicy.LINEAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not convert " + value + " to BackoffPolicy");
            }
        }
        return backoffPolicy;
    }

    @JvmStatic
    @TypeConverter
    public static final int networkTypeToInt(@NotNull NetworkType networkType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
        switch (WhenMappings.$EnumSwitchMapping$2[networkType.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            default: {
                if (Build.VERSION.SDK_INT >= 30 && networkType == NetworkType.TEMPORARILY_UNMETERED) {
                    n = 5;
                    break;
                }
                throw new IllegalArgumentException("Could not convert " + (Object)((Object)networkType) + " to int");
            }
        }
        return n;
    }

    @JvmStatic
    @TypeConverter
    @NotNull
    public static final NetworkType intToNetworkType(int value) {
        NetworkType networkType;
        switch (value) {
            case 0: {
                networkType = NetworkType.NOT_REQUIRED;
                break;
            }
            case 1: {
                networkType = NetworkType.CONNECTED;
                break;
            }
            case 2: {
                networkType = NetworkType.UNMETERED;
                break;
            }
            case 3: {
                networkType = NetworkType.NOT_ROAMING;
                break;
            }
            case 4: {
                networkType = NetworkType.METERED;
                break;
            }
            default: {
                if (Build.VERSION.SDK_INT >= 30 && value == 5) {
                    return NetworkType.TEMPORARILY_UNMETERED;
                }
                throw new IllegalArgumentException("Could not convert " + value + " to NetworkType");
            }
        }
        return networkType;
    }

    @JvmStatic
    @TypeConverter
    public static final int outOfQuotaPolicyToInt(@NotNull OutOfQuotaPolicy policy) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        switch (WhenMappings.$EnumSwitchMapping$3[policy.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @JvmStatic
    @TypeConverter
    @NotNull
    public static final OutOfQuotaPolicy intToOutOfQuotaPolicy(int value) {
        OutOfQuotaPolicy outOfQuotaPolicy;
        switch (value) {
            case 0: {
                outOfQuotaPolicy = OutOfQuotaPolicy.RUN_AS_NON_EXPEDITED_WORK_REQUEST;
                break;
            }
            case 1: {
                outOfQuotaPolicy = OutOfQuotaPolicy.DROP_WORK_REQUEST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not convert " + value + " to OutOfQuotaPolicy");
            }
        }
        return outOfQuotaPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @TypeConverter
    @NotNull
    public static final byte[] setOfTriggersToByteArray(@NotNull Set<Constraints.ContentUriTrigger> triggers) {
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        if (triggers.isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ObjectOutputStream(outputStream);
            Throwable throwable2 = null;
            try {
                ObjectOutputStream objectOutputStream = (ObjectOutputStream)closeable2;
                boolean bl2 = false;
                objectOutputStream.writeInt(triggers.size());
                for (Constraints.ContentUriTrigger trigger : triggers) {
                    objectOutputStream.writeUTF(trigger.getUri().toString());
                    objectOutputStream.writeBoolean(trigger.isTriggeredForDescendants());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @TypeConverter
    @NotNull
    public static final Set<Constraints.ContentUriTrigger> byteArrayToSetOfTriggers(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Set triggers = new LinkedHashSet();
        if (bytes.length == 0) {
            return triggers;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            try {
                Closeable closeable2 = new ObjectInputStream(inputStream);
                Throwable throwable2 = null;
                try {
                    ObjectInputStream objectInputStream = (ObjectInputStream)closeable2;
                    boolean bl2 = false;
                    int n = objectInputStream.readInt();
                    int n2 = 0;
                    while (n2 < n) {
                        int it2 = n2++;
                        boolean bl3 = false;
                        Uri uri = Uri.parse((String)objectInputStream.readUTF());
                        boolean triggersForDescendants = objectInputStream.readBoolean();
                        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                        triggers.add(new Constraints.ContentUriTrigger(uri, triggersForDescendants));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return triggers;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/work/impl/model/WorkTypeConverters$BackoffPolicyIds;", "", "()V", "EXPONENTIAL", "", "LINEAR", "work-runtime_release"})
    private static final class BackoffPolicyIds {
        @NotNull
        public static final BackoffPolicyIds INSTANCE = new BackoffPolicyIds();
        public static final int EXPONENTIAL = 0;
        public static final int LINEAR = 1;

        private BackoffPolicyIds() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/work/impl/model/WorkTypeConverters$NetworkTypeIds;", "", "()V", "CONNECTED", "", "METERED", "NOT_REQUIRED", "NOT_ROAMING", "TEMPORARILY_UNMETERED", "UNMETERED", "work-runtime_release"})
    private static final class NetworkTypeIds {
        @NotNull
        public static final NetworkTypeIds INSTANCE = new NetworkTypeIds();
        public static final int NOT_REQUIRED = 0;
        public static final int CONNECTED = 1;
        public static final int UNMETERED = 2;
        public static final int NOT_ROAMING = 3;
        public static final int METERED = 4;
        public static final int TEMPORARILY_UNMETERED = 5;

        private NetworkTypeIds() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/work/impl/model/WorkTypeConverters$OutOfPolicyIds;", "", "()V", "DROP_WORK_REQUEST", "", "RUN_AS_NON_EXPEDITED_WORK_REQUEST", "work-runtime_release"})
    private static final class OutOfPolicyIds {
        @NotNull
        public static final OutOfPolicyIds INSTANCE = new OutOfPolicyIds();
        public static final int RUN_AS_NON_EXPEDITED_WORK_REQUEST = 0;
        public static final int DROP_WORK_REQUEST = 1;

        private OutOfPolicyIds() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/work/impl/model/WorkTypeConverters$StateIds;", "", "()V", "BLOCKED", "", "CANCELLED", "COMPLETED_STATES", "", "ENQUEUED", "FAILED", "RUNNING", "SUCCEEDED", "work-runtime_release"})
    public static final class StateIds {
        @NotNull
        public static final StateIds INSTANCE = new StateIds();
        public static final int ENQUEUED = 0;
        public static final int RUNNING = 1;
        public static final int SUCCEEDED = 2;
        public static final int FAILED = 3;
        public static final int BLOCKED = 4;
        public static final int CANCELLED = 5;
        @NotNull
        public static final String COMPLETED_STATES = "(2, 3, 5)";

        private StateIds() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[WorkInfo.State.values().length];
            try {
                nArray[WorkInfo.State.ENQUEUED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkInfo.State.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkInfo.State.SUCCEEDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkInfo.State.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkInfo.State.BLOCKED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkInfo.State.CANCELLED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BackoffPolicy.values().length];
            try {
                nArray[BackoffPolicy.EXPONENTIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackoffPolicy.LINEAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[NetworkType.values().length];
            try {
                nArray[NetworkType.NOT_REQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkType.CONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkType.UNMETERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkType.NOT_ROAMING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkType.METERED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[OutOfQuotaPolicy.values().length];
            try {
                nArray[OutOfQuotaPolicy.RUN_AS_NON_EXPEDITED_WORK_REQUEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OutOfQuotaPolicy.DROP_WORK_REQUEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

