/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.RunnableScheduler;
import androidx.work.impl.model.WorkGenerationalId;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkTimer {
    private static final String TAG = Logger.tagWithPrefix("WorkTimer");
    final RunnableScheduler mRunnableScheduler;
    final Map<WorkGenerationalId, WorkTimerRunnable> mTimerMap = new HashMap<WorkGenerationalId, WorkTimerRunnable>();
    final Map<WorkGenerationalId, TimeLimitExceededListener> mListeners = new HashMap<WorkGenerationalId, TimeLimitExceededListener>();
    final Object mLock = new Object();

    public WorkTimer(@NonNull RunnableScheduler scheduler) {
        this.mRunnableScheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer(@NonNull WorkGenerationalId id, long processingTimeMillis, @NonNull TimeLimitExceededListener listener2) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Starting timer for " + id);
            this.stopTimer(id);
            WorkTimerRunnable runnable = new WorkTimerRunnable(this, id);
            this.mTimerMap.put(id, runnable);
            this.mListeners.put(id, listener2);
            this.mRunnableScheduler.scheduleWithDelay(processingTimeMillis, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer(@NonNull WorkGenerationalId id) {
        Object object = this.mLock;
        synchronized (object) {
            WorkTimerRunnable removed = this.mTimerMap.remove(id);
            if (removed != null) {
                Logger.get().debug(TAG, "Stopping timer for " + id);
                this.mListeners.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    public Map<WorkGenerationalId, WorkTimerRunnable> getTimerMap() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTimerMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    public Map<WorkGenerationalId, TimeLimitExceededListener> getListeners() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListeners;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class WorkTimerRunnable
    implements Runnable {
        static final String TAG = "WrkTimerRunnable";
        private final WorkTimer mWorkTimer;
        private final WorkGenerationalId mWorkGenerationalId;

        WorkTimerRunnable(@NonNull WorkTimer workTimer, @NonNull WorkGenerationalId id) {
            this.mWorkTimer = workTimer;
            this.mWorkGenerationalId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.mWorkTimer.mLock;
            synchronized (object) {
                WorkTimerRunnable removed = this.mWorkTimer.mTimerMap.remove(this.mWorkGenerationalId);
                if (removed != null) {
                    TimeLimitExceededListener listener2 = this.mWorkTimer.mListeners.remove(this.mWorkGenerationalId);
                    if (listener2 != null) {
                        listener2.onTimeLimitExceeded(this.mWorkGenerationalId);
                    }
                } else {
                    Logger.get().debug(TAG, String.format("Timer with %s is already marked as complete.", this.mWorkGenerationalId));
                }
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface TimeLimitExceededListener {
        public void onTimeLimitExceeded(@NonNull WorkGenerationalId var1);
    }
}

