/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.work.Data;
import androidx.work.ForegroundInfo;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import androidx.work.impl.utils.SynchronousExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public abstract class RxWorker
extends ListenableWorker {
    static final Executor INSTANT_EXECUTOR = new SynchronousExecutor();

    public RxWorker(@NonNull Context appContext, @NonNull WorkerParameters workerParams) {
        super(appContext, workerParams);
    }

    @NonNull
    public ListenableFuture<ListenableWorker.Result> startWork() {
        return this.convert(this.createWork());
    }

    @NonNull
    protected Scheduler getBackgroundScheduler() {
        return Schedulers.from((Executor)this.getBackgroundExecutor());
    }

    @MainThread
    @NonNull
    public abstract Single<ListenableWorker.Result> createWork();

    @Deprecated
    @NonNull
    public final Single<Void> setProgress(@NonNull Data data) {
        return Single.fromFuture((Future)this.setProgressAsync(data));
    }

    @NonNull
    public final Completable setCompletableProgress(@NonNull Data data) {
        return Completable.fromFuture((Future)this.setProgressAsync(data));
    }

    @NonNull
    public ListenableFuture<ForegroundInfo> getForegroundInfoAsync() {
        return this.convert(this.getForegroundInfo());
    }

    @NonNull
    public Single<ForegroundInfo> getForegroundInfo() {
        String message = "Expedited WorkRequests require a RxWorker to provide an implementation for `getForegroundInfo()`";
        return Single.error((Throwable)new IllegalStateException(message));
    }

    @NonNull
    public final Completable setForeground(@NonNull ForegroundInfo foregroundInfo) {
        return Completable.fromFuture((Future)this.setForegroundAsync(foregroundInfo));
    }

    private <T> ListenableFuture<T> convert(Single<T> single) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            Scheduler scheduler = this.getBackgroundScheduler();
            single.subscribeOn(scheduler).observeOn(Schedulers.from((Executor)this.getTaskExecutor().getSerialTaskExecutor())).subscribe(new SingleObserver<T>(){

                public void onSubscribe(Disposable d) {
                    completer.addCancellationListener(() -> ((Disposable)d).dispose(), INSTANT_EXECUTOR);
                }

                public void onSuccess(T t) {
                    completer.set(t);
                }

                public void onError(Throwable e) {
                    completer.setException(e);
                }
            });
            return "converted single to future";
        });
    }
}

