/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.testing;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.utils.SerialExecutor;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import androidx.work.testing.SynchronousExecutor;
import androidx.work.testing.TestDriver;
import androidx.work.testing.TestScheduler;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class TestWorkManagerImpl
extends WorkManagerImpl
implements TestDriver {
    private TestScheduler mScheduler;

    TestWorkManagerImpl(@NonNull Context context, final @NonNull Configuration configuration) {
        super(context, configuration, new TaskExecutor(){
            Executor mSynchronousExecutor = new SynchronousExecutor();
            SerialExecutor mSerialExecutor = new SerialExecutor(configuration.getTaskExecutor());

            public void postToMainThread(Runnable runnable) {
                runnable.run();
            }

            public Executor getMainThreadExecutor() {
                return this.mSynchronousExecutor;
            }

            public void executeOnBackgroundThread(Runnable runnable) {
                this.mSerialExecutor.execute(runnable);
            }

            public SerialExecutor getBackgroundExecutor() {
                return this.mSerialExecutor;
            }
        }, true);
        this.getProcessor().addExecutionListener((ExecutionListener)this.mScheduler);
    }

    @NonNull
    public List<Scheduler> createSchedulers(@NonNull Context context, @NonNull Configuration configuration, @NonNull TaskExecutor taskExecutor) {
        this.mScheduler = new TestScheduler(context);
        return Collections.singletonList(this.mScheduler);
    }

    @Override
    public void setAllConstraintsMet(@NonNull UUID workSpecId) {
        this.mScheduler.setAllConstraintsMet(workSpecId);
    }

    @Override
    public void setInitialDelayMet(@NonNull UUID workSpecId) {
        this.mScheduler.setInitialDelayMet(workSpecId);
    }

    @Override
    public void setPeriodDelayMet(@NonNull UUID workSpecId) {
        this.mScheduler.setPeriodDelayMet(workSpecId);
    }
}

