/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.testing;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.work.Configuration;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.testing.SynchronousExecutor;
import androidx.work.testing.TestDriver;
import androidx.work.testing.TestWorkManagerImpl;
import java.util.concurrent.Executor;

public final class WorkManagerTestInitHelper {
    public static void initializeTestWorkManager(@NonNull Context context) {
        SynchronousExecutor synchronousExecutor = new SynchronousExecutor();
        Configuration configuration = new Configuration.Builder().setExecutor((Executor)synchronousExecutor).setTaskExecutor((Executor)synchronousExecutor).build();
        WorkManagerTestInitHelper.initializeTestWorkManager(context, configuration);
    }

    public static void initializeTestWorkManager(@NonNull Context context, @NonNull Configuration configuration) {
        if (configuration.isUsingDefaultTaskExecutor()) {
            Configuration.Builder builder = new Configuration.Builder(configuration).setTaskExecutor((Executor)new SynchronousExecutor());
            configuration = builder.build();
        }
        WorkManagerImpl.setDelegate((WorkManagerImpl)new TestWorkManagerImpl(context, configuration));
    }

    @Deprecated
    @Nullable
    public static TestDriver getTestDriver() {
        WorkManagerImpl workManager = WorkManagerImpl.getInstance();
        if (workManager == null) {
            return null;
        }
        return (TestWorkManagerImpl)workManager;
    }

    @Nullable
    public static TestDriver getTestDriver(@NonNull Context context) {
        try {
            return (TestWorkManagerImpl)WorkManagerImpl.getInstance((Context)context);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private WorkManagerTestInitHelper() {
    }
}

