/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Dataset<T extends Dataset<T, O>, O> {
    protected final List<O> data = new ArrayList<O>();

    public List<O> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public T setData(Collection<O> data) {
        this.clearData();
        if (data != null) {
            this.data.addAll(data);
        }
        return (T)this;
    }

    public T setData(O ... data) {
        this.clearData();
        if (data != null) {
            this.data.addAll(Arrays.asList(data));
        }
        return (T)this;
    }

    public T clearData() {
        this.data.clear();
        return (T)this;
    }

    public T addData(O data) {
        this.data.add(data);
        return (T)this;
    }
}

