/*
 * Decompiled with CFR 0.152.
 */
package be.ceau.chart.dataset;

import be.ceau.chart.dataset.PointDataset;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RadarDataset
extends PointDataset<RadarDataset, BigDecimal> {
    private final List<Integer> hitRadius = new ArrayList<Integer>();

    public List<Integer> getHitRadius() {
        return this.hitRadius;
    }

    public RadarDataset addHitRadius(Integer hitRadius) {
        this.hitRadius.add(hitRadius);
        return this;
    }

    public RadarDataset setHitRadius(List<Integer> hitRadius) {
        this.hitRadius.clear();
        if (hitRadius != null) {
            this.hitRadius.addAll(hitRadius);
        }
        return this;
    }

    public RadarDataset setData(int ... data) {
        this.clearData();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                this.data.add(new BigDecimal(data[i]));
            }
        }
        return this;
    }

    public RadarDataset setData(double ... data) {
        this.clearData();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                this.data.add(new BigDecimal(String.valueOf(data[i])));
            }
        }
        return this;
    }

    @Override
    public RadarDataset addData(int data) {
        this.data.add(new BigDecimal(data));
        return this;
    }

    @Override
    public RadarDataset addData(double data) {
        this.data.add(new BigDecimal(String.valueOf(data)));
        return this;
    }
}

