/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl.bin.utf8;

import com.amazon.ion.impl.bin.utf8.Poolable;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Pool<T extends Poolable<?>> {
    private static final int MAX_QUEUE_SIZE = 128;
    private final ArrayBlockingQueue<T> bufferQueue;
    private final Allocator<T> allocator;

    Pool(Allocator<T> allocator) {
        this.allocator = allocator;
        this.bufferQueue = new ArrayBlockingQueue(128);
    }

    public T getOrCreate() {
        Poolable object = (Poolable)this.bufferQueue.poll();
        if (object == null) {
            object = this.allocator.newInstance(this);
        }
        return (T)object;
    }

    public void returnToPool(T object) {
        this.bufferQueue.offer(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Allocator<T extends Poolable<?>> {
        public T newInstance(Pool<T> var1);
    }
}

