/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.AlternativeBillingOnlyAvailabilityListener;
import com.android.billingclient.api.AlternativeBillingOnlyInformationDialogListener;
import com.android.billingclient.api.AlternativeBillingOnlyReportingDetailsListener;
import com.android.billingclient.api.BillingClientImpl;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingConfigResponseListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.ExternalOfferAvailabilityListener;
import com.android.billingclient.api.ExternalOfferInformationDialogListener;
import com.android.billingclient.api.ExternalOfferReportingDetailsListener;
import com.android.billingclient.api.GetBillingConfigParams;
import com.android.billingclient.api.InAppMessageParams;
import com.android.billingclient.api.InAppMessageResponseListener;
import com.android.billingclient.api.PendingPurchasesParams;
import com.android.billingclient.api.ProductDetailsResponseListener;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.QueryProductDetailsParams;
import com.android.billingclient.api.QueryPurchaseHistoryParams;
import com.android.billingclient.api.QueryPurchasesParams;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.android.billingclient.api.UserChoiceBillingListener;
import com.android.billingclient.api.zzb;
import com.android.billingclient.api.zzcc;
import com.android.billingclient.api.zzch;
import com.android.billingclient.api.zzco;
import com.android.billingclient.api.zzf;
import com.android.billingclient.api.zzg;
import com.android.billingclient.api.zzh;
import com.android.billingclient.api.zzj;
import com.android.billingclient.api.zzk;
import com.android.billingclient.api.zzo;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.play_billing.zze;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.ExecutorService;

public abstract class BillingClient {
    @AnyThread
    public abstract int getConnectionState();

    @AnyThread
    @NonNull
    public static Builder newBuilder(@NonNull Context context) {
        Context context2;
        return new Builder(context2, null);
    }

    @AnyThread
    @NonNull
    public abstract BillingResult isFeatureSupported(@NonNull String var1);

    @UiThread
    @NonNull
    public abstract BillingResult launchBillingFlow(@NonNull Activity var1, @NonNull BillingFlowParams var2);

    @zzf
    @UiThread
    @NonNull
    public abstract BillingResult showAlternativeBillingOnlyInformationDialog(@NonNull Activity var1, @NonNull AlternativeBillingOnlyInformationDialogListener var2);

    @zzg
    @UiThread
    @NonNull
    public abstract BillingResult showExternalOfferInformationDialog(@NonNull Activity var1, @NonNull ExternalOfferInformationDialogListener var2);

    @UiThread
    @NonNull
    public abstract BillingResult showInAppMessages(@NonNull Activity var1, @NonNull InAppMessageParams var2, @NonNull InAppMessageResponseListener var3);

    @AnyThread
    public abstract void acknowledgePurchase(@NonNull AcknowledgePurchaseParams var1, @NonNull AcknowledgePurchaseResponseListener var2);

    @AnyThread
    public abstract void consumeAsync(@NonNull ConsumeParams var1, @NonNull ConsumeResponseListener var2);

    @zzf
    @AnyThread
    @KeepForSdk
    public abstract void createAlternativeBillingOnlyReportingDetailsAsync(@NonNull AlternativeBillingOnlyReportingDetailsListener var1);

    @AnyThread
    @zzg
    public abstract void createExternalOfferReportingDetailsAsync(@NonNull ExternalOfferReportingDetailsListener var1);

    @AnyThread
    public abstract void endConnection();

    @zzh
    @AnyThread
    public abstract void getBillingConfigAsync(@NonNull GetBillingConfigParams var1, @NonNull BillingConfigResponseListener var2);

    @zzf
    @AnyThread
    @KeepForSdk
    public abstract void isAlternativeBillingOnlyAvailableAsync(@NonNull AlternativeBillingOnlyAvailabilityListener var1);

    @AnyThread
    @zzg
    public abstract void isExternalOfferAvailableAsync(@NonNull ExternalOfferAvailabilityListener var1);

    @AnyThread
    public abstract void queryProductDetailsAsync(@NonNull QueryProductDetailsParams var1, @NonNull ProductDetailsResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull QueryPurchaseHistoryParams var1, @NonNull PurchaseHistoryResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchaseHistoryAsync(@NonNull String var1, @NonNull PurchaseHistoryResponseListener var2);

    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull QueryPurchasesParams var1, @NonNull PurchasesResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void queryPurchasesAsync(@NonNull String var1, @NonNull PurchasesResponseListener var2);

    @Deprecated
    @AnyThread
    public abstract void querySkuDetailsAsync(@NonNull SkuDetailsParams var1, @NonNull SkuDetailsResponseListener var2);

    @AnyThread
    public abstract void startConnection(@NonNull BillingClientStateListener var1);

    @AnyThread
    public abstract boolean isReady();

    @AnyThread
    public static final class Builder {
        private volatile String zza;
        private volatile PendingPurchasesParams zzb;
        private final Context zzc;
        private volatile PurchasesUpdatedListener zzd;
        private volatile zzco zze;
        private volatile zzch zzf;
        private volatile zzb zzg;
        private volatile UserChoiceBillingListener zzh;
        @Nullable
        private volatile ExecutorService zzi;
        private volatile boolean zzj;
        private volatile boolean zzk;
        private volatile boolean zzl;

        @zzf
        @NonNull
        public Builder enableAlternativeBillingOnly() {
            this.zzj = true;
            return this;
        }

        @zzg
        @NonNull
        public Builder enableExternalOffer() {
            this.zzk = true;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder enablePendingPurchases() {
            PendingPurchasesParams.Builder builder = PendingPurchasesParams.newBuilder();
            builder.enableOneTimeProducts();
            this.enablePendingPurchases(builder.build());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @zzj
        @NonNull
        public Builder enablePendingPurchases(@NonNull PendingPurchasesParams pendingPurchasesParams) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @zzk
        @NonNull
        public Builder enableUserChoiceBilling(@NonNull UserChoiceBillingListener userChoiceBillingListener) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setListener(@NonNull PurchasesUpdatedListener listener) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public BillingClient build() {
            if (((Builder)this).zzc == null) {
                throw new IllegalArgumentException("Please provide a valid Context.");
            }
            if (((Builder)this).zzd != null) {
            }
            if (((Builder)this).zzd == null) {
                if (((Builder)this).zzh != null) {
                    throw new IllegalArgumentException("Please provide a valid listener for Google Play Billing purchases updates when enabling User Choice Billing.");
                }
                if (!((Builder)this).zzj) {
                    if (!((Builder)this).zzk) throw new IllegalArgumentException("Please provide a valid listener for purchases updates.");
                }
                Context context = ((Builder)this).zzc;
                if (!((Builder)this).zza()) return new BillingClientImpl(null, context, null, null);
                return new zzcc(null, context, null, null);
            }
            if (((Builder)this).zzb == null) throw new IllegalArgumentException("Pending purchases for one-time products must be supported.");
            if (!((Builder)this).zzb.isEnabledForOneTimeProducts()) {
                throw new IllegalArgumentException("Pending purchases for one-time products must be supported.");
            }
            if (((Builder)this).zzd != null) {
                if (((Builder)this).zzh == null) {
                    PendingPurchasesParams pendingPurchasesParams = ((Builder)this).zzb;
                    Context context = ((Builder)this).zzc;
                    PurchasesUpdatedListener purchasesUpdatedListener = ((Builder)this).zzd;
                    if (!super.zza()) return new BillingClientImpl(null, pendingPurchasesParams, context, purchasesUpdatedListener, null, null, null);
                    return new zzcc(null, pendingPurchasesParams, context, purchasesUpdatedListener, null, null, null);
                }
                PendingPurchasesParams pendingPurchasesParams = ((Builder)this).zzb;
                Context context = ((Builder)this).zzc;
                PurchasesUpdatedListener purchasesUpdatedListener = ((Builder)this).zzd;
                UserChoiceBillingListener userChoiceBillingListener = ((Builder)this).zzh;
                if (!super.zza()) return new BillingClientImpl(null, pendingPurchasesParams, context, purchasesUpdatedListener, userChoiceBillingListener, null, null);
                return new zzcc(null, pendingPurchasesParams, context, purchasesUpdatedListener, userChoiceBillingListener, null, null);
            }
            PendingPurchasesParams pendingPurchasesParams = ((Builder)this).zzb;
            Context context = ((Builder)this).zzc;
            if (!((Builder)this).zza()) return new BillingClientImpl(null, pendingPurchasesParams, context, null, null, null);
            return new zzcc(null, pendingPurchasesParams, context, null, null, null);
        }

        /* synthetic */ Builder(Context context, zzo zzo2) {
            this.zzc = context;
        }

        private final boolean zza() {
            try {
                boolean bl = this.zzc.getPackageManager().getApplicationInfo((String)this.zzc.getPackageName(), (int)128).metaData.getBoolean("com.google.android.play.billingclient.enableBillingOverridesTesting", false);
                return bl;
            }
            catch (Exception exception) {
                com.google.android.gms.internal.play_billing.zze.zzm("BillingClient", "Unable to retrieve metadata value for enableBillingOverridesTesting.", exception);
                return false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
        public static final int DISCONNECTED = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;
        public static final int CLOSED = 3;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BillingResponseCode {
        @Deprecated
        public static final int SERVICE_TIMEOUT = -3;
        public static final int FEATURE_NOT_SUPPORTED = -2;
        public static final int SERVICE_DISCONNECTED = -1;
        public static final int OK = 0;
        public static final int USER_CANCELED = 1;
        public static final int SERVICE_UNAVAILABLE = 2;
        public static final int BILLING_UNAVAILABLE = 3;
        public static final int ITEM_UNAVAILABLE = 4;
        public static final int DEVELOPER_ERROR = 5;
        public static final int ERROR = 6;
        public static final int ITEM_ALREADY_OWNED = 7;
        public static final int ITEM_NOT_OWNED = 8;
        public static final int NETWORK_ERROR = 12;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
        @NonNull
        public static final String SUBSCRIPTIONS = "subscriptions";
        @NonNull
        public static final String SUBSCRIPTIONS_UPDATE = "subscriptionsUpdate";
        @NonNull
        public static final String PRICE_CHANGE_CONFIRMATION = "priceChangeConfirmation";
        @NonNull
        public static final String IN_APP_MESSAGING = "bbb";
        @NonNull
        public static final String PRODUCT_DETAILS = "fff";
        @zzh
        @NonNull
        public static final String BILLING_CONFIG = "ggg";
        @zzf
        @NonNull
        public static final String ALTERNATIVE_BILLING_ONLY = "jjj";
        @zzg
        @NonNull
        public static final String EXTERNAL_OFFER = "kkk";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProductType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Deprecated
    public static @interface SkuType {
        @NonNull
        public static final String INAPP = "inapp";
        @NonNull
        public static final String SUBS = "subs";
    }
}

