/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.play_billing;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.InAppMessageResult;
import com.android.billingclient.api.Purchase;
import com.google.android.gms.internal.play_billing.zzd;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public final class zze {
    public static final int zza = Runtime.getRuntime().availableProcessors();

    private static int zzp(Bundle bundle, String string) {
        if (bundle == null) {
            zze.zzl(string, "Unexpected null bundle received!");
            return 0;
        }
        return bundle.getInt("IN_APP_MESSAGE_RESPONSE_CODE", 0);
    }

    public static int zza(Intent intent, String string) {
        string = "ProxyBillingActivity";
        if (intent == null) {
            zze.zzl(string, "Got null intent!");
            return 0;
        }
        return zze.zzp(intent.getExtras(), string);
    }

    public static int zzb(Bundle object, String string) {
        if (object == null) {
            zze.zzl(string, "Unexpected null bundle received!");
            return 6;
        }
        if ((object = object.get("RESPONSE_CODE")) == null) {
            zze.zzk(string, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        object = String.valueOf(object.getClass().getName());
        zze.zzl(string, "Unexpected type for bundle response code: ".concat((String)object));
        return 6;
    }

    public static Bundle zzc(Bundle bundle, String string, long l) {
        bundle.putString("playBillingLibraryVersion", string);
        bundle.putLong("billingClientSessionId", l);
        return bundle;
    }

    public static Bundle zzd(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, long l) {
        Bundle bundle = new Bundle();
        zze.zzc(bundle, string, l);
        if (bl && bl3) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        if (bl2 && bl4) {
            bundle.putBoolean("enablePendingPurchaseForSubscriptions", true);
        }
        return bundle;
    }

    public static Bundle zze(String string, long l) {
        Bundle bundle = new Bundle();
        zze.zzc(bundle, string, l);
        return bundle;
    }

    public static BillingResult zzf(Intent intent, String string) {
        if (intent == null) {
            zze.zzl("BillingHelper", "Got null intent!");
            BillingResult.Builder builder = BillingResult.newBuilder();
            builder.setResponseCode(6);
            builder.setDebugMessage("An internal error occurred.");
            return builder.build();
        }
        BillingResult.Builder builder = BillingResult.newBuilder();
        builder.setResponseCode(zze.zzb(intent.getExtras(), string));
        builder.setDebugMessage(zze.zzh(intent.getExtras(), string));
        return builder.build();
    }

    public static InAppMessageResult zzg(Bundle bundle, String string) {
        if (bundle == null) {
            return new InAppMessageResult(0, null);
        }
        return new InAppMessageResult(zze.zzp(bundle, "BillingClient"), bundle.getString("IN_APP_MESSAGE_PURCHASE_TOKEN"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Purchase zzq(String object, String string) {
        if (object == null || string == null) {
            zze.zzk("BillingHelper", "Received a null purchase data.");
            return null;
        }
        try {
            Purchase purchase = new Purchase((String)object, string);
            return purchase;
        }
        catch (JSONException jSONException) {
            object = "Got JSONException while parsing purchase data: ".concat(((Object)((Object)jSONException)).toString());
            zze.zzl("BillingHelper", (String)object);
            return null;
        }
    }

    public static String zzh(Bundle object, String string) {
        String string2 = "";
        if (object == null) {
            zze.zzl(string, "Unexpected null bundle received!");
            return string2;
        }
        if ((object = object.get("DEBUG_MESSAGE")) == null) {
            zze.zzk(string, "getDebugMessageFromBundle() got null response code, assuming OK");
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        object = String.valueOf(object.getClass().getName());
        zze.zzl(string, "Unexpected type for debug message: ".concat((String)object));
        return string2;
    }

    public static String zzi(int n) {
        return zzd.zza(n).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public static List zzj(Bundle object) {
        Object object2 = object;
        ArrayList arrayList = object2.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList arrayList2 = object2.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        ArrayList<Purchase> arrayList3 = new ArrayList<Purchase>();
        if (arrayList == null || arrayList2 == null) {
            Purchase purchase = zze.zzq(object.getString("INAPP_PURCHASE_DATA"), object.getString("INAPP_DATA_SIGNATURE"));
            if (purchase == null) {
                zze.zzk("BillingHelper", "Couldn't find single purchase data as well.");
                return null;
            }
            arrayList3.add(purchase);
            return arrayList3;
        } else {
            void var0_4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found purchase list of ");
            stringBuilder.append(arrayList.size());
            stringBuilder.append(" items");
            String string = stringBuilder.toString();
            zze.zzk("BillingHelper", string);
            boolean bl = false;
            while (var0_4 < arrayList.size() && var0_4 < arrayList2.size()) {
                Purchase purchase = zze.zzq((String)arrayList.get((int)var0_4), (String)arrayList2.get((int)var0_4));
                if (purchase != null) {
                    arrayList3.add(purchase);
                }
                ++var0_4;
            }
        }
        return arrayList3;
    }

    public static void zzk(String string, String string2) {
        if (Log.isLoggable((String)string, (int)2)) {
            if (!string2.isEmpty()) {
                int n;
                for (int i = 40000; !string2.isEmpty() && i > 0; i -= n) {
                    n = Math.min(string2.length(), Math.min(4000, i));
                    Log.v((String)string, (String)string2.substring(0, n));
                    string2 = string2.substring(n);
                }
            } else {
                Log.v((String)string, (String)string2);
                return;
            }
        }
    }

    public static void zzl(String string, String string2) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzm(String string, String string2, @Nullable Throwable throwable) {
        try {
            boolean bl = Log.isLoggable((String)string, (int)5);
            if (!bl) {
                return;
            }
            if (throwable == null) {
                Log.w((String)string, (String)string2);
                return;
            }
            Log.w((String)string, (String)string2, (Throwable)throwable);
            return;
        }
        catch (Throwable throwable2) {
            return;
        }
    }

    public static Bundle zzn(BillingResult billingResult, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("RESPONSE_CODE", billingResult.getResponseCode());
        bundle.putString("DEBUG_MESSAGE", billingResult.getDebugMessage());
        bundle.putInt("LOG_REASON", n + -1);
        return bundle;
    }

    public static Bundle zzo(BillingResult billingResult, int n, @Nullable String string) {
        billingResult = zze.zzn(billingResult, 5);
        if (string != null) {
            billingResult.putString("ADDITIONAL_LOG_DETAILS", string);
        }
        return billingResult;
    }
}

