/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.databinding.BindingAdapter;
import android.databinding.InverseBindingListener;
import android.databinding.InverseBindingMethod;
import android.databinding.InverseBindingMethods;
import android.support.annotation.RestrictTo;
import android.widget.SeekBar;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@InverseBindingMethods(value={@InverseBindingMethod(type=SeekBar.class, attribute="android:progress")})
public class SeekBarBindingAdapter {
    @BindingAdapter(value={"android:progress"})
    public static void setProgress(SeekBar view, int progress) {
        if (progress != view.getProgress()) {
            view.setProgress(progress);
        }
    }

    @BindingAdapter(value={"android:onStartTrackingTouch", "android:onStopTrackingTouch", "android:onProgressChanged", "android:progressAttrChanged"}, requireAll=false)
    public static void setOnSeekBarChangeListener(SeekBar view, final OnStartTrackingTouch start, final OnStopTrackingTouch stop, final OnProgressChanged progressChanged, final InverseBindingListener attrChanged) {
        if (start == null && stop == null && progressChanged == null && attrChanged == null) {
            view.setOnSeekBarChangeListener(null);
        } else {
            view.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (progressChanged != null) {
                        progressChanged.onProgressChanged(seekBar, progress, fromUser);
                    }
                    if (attrChanged != null) {
                        attrChanged.onChange();
                    }
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                    if (start != null) {
                        start.onStartTrackingTouch(seekBar);
                    }
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                    if (stop != null) {
                        stop.onStopTrackingTouch(seekBar);
                    }
                }
            });
        }
    }

    public static interface OnProgressChanged {
        public void onProgressChanged(SeekBar var1, int var2, boolean var3);
    }

    public static interface OnStartTrackingTouch {
        public void onStartTrackingTouch(SeekBar var1);
    }

    public static interface OnStopTrackingTouch {
        public void onStopTrackingTouch(SeekBar var1);
    }
}

