/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.Binding;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.ArgListExpr;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MergedBinding
extends Binding {
    private final SetterStore.MultiAttributeSetter mMultiAttributeSetter;

    public MergedBinding(ExprModel model, SetterStore.MultiAttributeSetter multiAttributeSetter, BindingTarget target, Iterable<Binding> bindings) {
        super(target, MergedBinding.createMergedName(bindings), MergedBinding.createArgListExpr(model, bindings));
        this.mMultiAttributeSetter = multiAttributeSetter;
    }

    @Override
    public void resolveListeners() {
        ModelClass[] parameters = this.mMultiAttributeSetter.getParameterTypes();
        List<Expr> children = this.getExpr().getChildren();
        Expr expr = this.getExpr();
        for (int i = 0; i < children.size(); ++i) {
            Expr child = children.get(i);
            child.resolveListeners(parameters[i], expr);
        }
    }

    private static Expr createArgListExpr(ExprModel model, Iterable<Binding> bindings) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        for (Binding binding : bindings) {
            args.add(binding.getExpr());
        }
        Expr expr = model.argListExpr(args);
        expr.markAsBindingExpression();
        expr.setUnwrapObservableFields(false);
        return expr;
    }

    private static String createMergedName(Iterable<Binding> bindings) {
        StringBuilder sb = new StringBuilder();
        for (Binding binding : bindings) {
            sb.append(binding.getName());
        }
        return sb.toString();
    }

    @Override
    public void injectSafeUnboxing(ExprModel exprModel) {
        ModelClass[] params = this.mMultiAttributeSetter.getParameterTypes();
        ArgListExpr args = (ArgListExpr)this.getExpr();
        args.injectSafeUnboxingForParams(exprModel, params);
    }

    @Override
    public Expr[] getComponentExpressions() {
        ArgListExpr args = (ArgListExpr)this.getExpr();
        return args.getChildren().toArray(new Expr[args.getChildren().size()]);
    }

    public String[] getAttributes() {
        return this.mMultiAttributeSetter.attributes;
    }

    @Override
    public String getBindingAdapterInstanceClass() {
        return this.mMultiAttributeSetter.getBindingAdapterInstanceClass();
    }

    @Override
    public boolean requiresOldValue() {
        return this.mMultiAttributeSetter.requiresOldValue();
    }

    public SetterStore.MultiAttributeSetter getMultiAttributeSetter() {
        return this.mMultiAttributeSetter;
    }

    @Override
    public int getMinApi() {
        return 1;
    }

    @Override
    public String toJavaCode(String targetViewName, String bindingComponent) {
        List<Object> oldValues;
        ArgListExpr args = (ArgListExpr)this.getExpr();
        ArrayList<String> newValues = new ArrayList<String>();
        for (Expr expr : args.getChildren()) {
            newValues.add(expr.toCode().generate());
        }
        if (this.requiresOldValue()) {
            oldValues = new ArrayList();
            for (Expr expr : args.getChildren()) {
                oldValues.add("this." + LayoutBinderWriterKt.getOldValueName(expr));
            }
        } else {
            oldValues = Arrays.asList(new String[args.getChildren().size()]);
        }
        String[] stringArray = MergedBinding.concat(oldValues, newValues, String.class);
        L.d((String)"merged binding arg: %s", (Object[])new Object[]{args.toString()});
        return this.mMultiAttributeSetter.toJava(bindingComponent, targetViewName, stringArray);
    }

    private static <T> T[] concat(List<T> l1, List<T> l2, Class<T> klass2) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(l1);
        result.addAll(l2);
        return result.toArray((Object[])Array.newInstance(klass2, result.size()));
    }
}

