/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.Bindable;
import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.StringUtils;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ModelClass {
    public static Map<Class, Class> BOX_MAPPING;
    public static Map<Class, Class> UNBOX_MAPPING;

    public ModelClass() {
        BOX_MAPPING = ImmutableMap.builder().put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Boolean.TYPE, Boolean.class).build();
        ImmutableMap.Builder reverseBuilder = ImmutableMap.builder();
        for (Map.Entry<Class, Class> entry : BOX_MAPPING.entrySet()) {
            reverseBuilder.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        UNBOX_MAPPING = reverseBuilder.build();
    }

    public abstract String toJavaCode();

    public abstract boolean isArray();

    public abstract ModelClass getComponentType();

    public boolean isList() {
        for (ModelClass listType : ModelAnalyzer.getInstance().getListTypes()) {
            if (listType == null || !listType.isAssignableFrom(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isMap() {
        return ModelAnalyzer.getInstance().getMapType().isAssignableFrom(this.erasure());
    }

    public boolean isString() {
        return ModelAnalyzer.getInstance().getStringType().equals(this);
    }

    public abstract boolean isNullable();

    public abstract boolean isPrimitive();

    public abstract boolean isBoolean();

    public abstract boolean isChar();

    public abstract boolean isByte();

    public abstract boolean isShort();

    public abstract boolean isInt();

    public abstract boolean isLong();

    public abstract boolean isFloat();

    public abstract boolean isDouble();

    public abstract boolean isGeneric();

    public abstract List<ModelClass> getTypeArguments();

    public abstract boolean isTypeVar();

    public abstract boolean isWildcard();

    public boolean isObject() {
        return ModelAnalyzer.getInstance().getObjectType().equals(this);
    }

    public abstract boolean isInterface();

    public boolean isViewDataBinding() {
        return ModelAnalyzer.getInstance().getViewDataBindingType().isAssignableFrom(this);
    }

    public boolean extendsViewStub() {
        return ModelAnalyzer.getInstance().getViewStubType().isAssignableFrom(this);
    }

    public boolean isObservable() {
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        return modelAnalyzer.getObservableType().isAssignableFrom(this) || modelAnalyzer.getObservableListType().isAssignableFrom(this) || modelAnalyzer.getObservableMapType().isAssignableFrom(this) || modelAnalyzer.getLiveDataType() != null && modelAnalyzer.getLiveDataType().isAssignableFrom(this);
    }

    public boolean isObservableField() {
        ModelClass erasure = this.erasure();
        for (ModelClass observableField : ModelAnalyzer.getInstance().getObservableFieldTypes()) {
            if (!observableField.isAssignableFrom(erasure)) continue;
            return true;
        }
        return false;
    }

    public boolean isLiveData() {
        ModelClass liveDataType = ModelAnalyzer.getInstance().getLiveDataType();
        return liveDataType != null && liveDataType.isAssignableFrom(this.erasure());
    }

    public boolean isMutableLiveData() {
        ModelClass mutableLiveDataType = ModelAnalyzer.getInstance().getMutableLiveDataType();
        return mutableLiveDataType != null && mutableLiveDataType.isAssignableFrom(this.erasure());
    }

    public String getObservableGetterName() {
        if (this.isObservableField()) {
            return "get";
        }
        if (this.isLiveData()) {
            return "getValue";
        }
        return null;
    }

    public String getObservableSetterName() {
        if (this.isObservableField()) {
            return "set";
        }
        if (this.isMutableLiveData()) {
            return "setValue";
        }
        return null;
    }

    public abstract boolean isVoid();

    public abstract ModelClass unbox();

    public abstract ModelClass box();

    public abstract boolean isAssignableFrom(ModelClass var1);

    public ModelMethod[] getMethods(String name, List<ModelClass> args, boolean staticOnly, boolean allowProtected, boolean unwrapObservableFields) {
        ModelMethod[] methods = this.getDeclaredMethods();
        ArrayList<ModelMethod> matching = new ArrayList<ModelMethod>();
        for (ModelMethod method : methods) {
            if (!method.isPublic() && (!allowProtected || !method.isProtected()) || staticOnly && !method.isStatic() || !name.equals(method.getName()) || !method.acceptsArguments(args, unwrapObservableFields)) continue;
            matching.add(method);
        }
        return matching.toArray(new ModelMethod[matching.size()]);
    }

    public ModelMethod[] getMethods(String name, int numParameters) {
        ModelMethod[] methods = this.getDeclaredMethods();
        ArrayList<ModelMethod> matching = new ArrayList<ModelMethod>();
        for (ModelMethod method : methods) {
            if (!method.isPublic() || method.isStatic() || !name.equals(method.getName()) || method.getParameterTypes().length != numParameters) continue;
            matching.add(method);
        }
        return matching.toArray(new ModelMethod[matching.size()]);
    }

    public ModelMethod getMethod(String name, List<ModelClass> args, boolean staticOnly, boolean allowProtected) {
        return this.getMethod(name, args, staticOnly, allowProtected, false);
    }

    public ModelMethod getMethod(String name, List<ModelClass> args, boolean staticOnly, boolean allowProtected, boolean unwrapObservableFields) {
        ModelMethod[] methods = this.getMethods(name, args, staticOnly, allowProtected, unwrapObservableFields);
        L.d((String)"looking methods for %s. static only ? %s . method count: %d", (Object[])new Object[]{name, staticOnly, methods.length});
        for (ModelMethod method : methods) {
            L.d((String)"method: %s, %s", (Object[])new Object[]{method.getName(), method.isStatic()});
        }
        if (methods.length == 0) {
            return null;
        }
        ModelMethod bestMethod = methods[0];
        for (int i = 1; i < methods.length; ++i) {
            if (!methods[i].isBetterArgMatchThan(bestMethod, args)) continue;
            bestMethod = methods[i];
        }
        return bestMethod;
    }

    public abstract ModelClass getSuperclass();

    public String getCanonicalName() {
        return this.erasure().toJavaCode();
    }

    public String getSimpleName() {
        String canonicalName = this.getCanonicalName();
        int dotIndex = canonicalName.lastIndexOf(46);
        if (dotIndex >= 0) {
            return canonicalName.substring(dotIndex + 1);
        }
        return canonicalName;
    }

    public abstract ModelClass erasure();

    public int getMinApi() {
        return SdkUtil.get().getMinApi(this);
    }

    public abstract String getJniDescription();

    @NotNull
    public List<ModelMethod> getAbstractMethods() {
        ModelMethod[] methods;
        ArrayList<ModelMethod> abstractMethods = new ArrayList<ModelMethod>();
        for (ModelMethod method : methods = this.getDeclaredMethods()) {
            if (!method.isAbstract()) continue;
            abstractMethods.add(method);
        }
        return abstractMethods;
    }

    public Callable findGetterOrField(String name, boolean staticOnly) {
        String[] methodNames;
        if ("length".equals(name) && this.isArray()) {
            return new Callable(Callable.Type.FIELD, name, null, ModelAnalyzer.getInstance().loadPrimitive("int"), 0, 0, null, null);
        }
        String capitalized = StringUtils.capitalize((String)name);
        for (String methodName : methodNames = new String[]{"get" + capitalized, "is" + capitalized, name}) {
            ModelMethod[] methods;
            for (ModelMethod method : methods = this.getMethods(methodName, new ArrayList<ModelClass>(), staticOnly, false, false)) {
                Bindable bindable;
                if (!method.isPublic() || staticOnly && !method.isStatic() || method.getReturnType(Arrays.asList(method.getParameterTypes())).isVoid()) continue;
                int flags = 1;
                if (method.isStatic()) {
                    flags |= 4;
                }
                if (method.isBindable()) {
                    flags |= 2;
                    bindable = method.getBindableAnnotation();
                } else {
                    ModelField backingField = this.getField(name, true, method.isStatic());
                    L.d((String)"backing field for method %s is %s", (Object[])new Object[]{method.getName(), backingField == null ? "NOT FOUND" : backingField.getName()});
                    if (backingField != null && backingField.isBindable()) {
                        flags |= 2;
                        bindable = backingField.getBindableAnnotation();
                    } else {
                        bindable = null;
                    }
                }
                ModelMethod setterMethod = this.findSetter(method, name);
                String setterName2 = setterMethod == null ? null : setterMethod.getName();
                Callable result = new Callable(Callable.Type.METHOD, methodName, setterName2, method.getReturnType(null), method.getParameterTypes().length, flags, method, bindable);
                return result;
            }
        }
        ModelField publicField = null;
        if (staticOnly) {
            publicField = this.getField(name, false, true);
        } else {
            publicField = this.getField(name, false, false);
            if (publicField == null) {
                publicField = this.getField(name, false, true);
            }
        }
        if (publicField == null) {
            return null;
        }
        ModelClass fieldType = publicField.getFieldType();
        int flags = 0;
        String setterFieldName = name;
        if (publicField.isStatic()) {
            flags |= 4;
        }
        if (!publicField.isFinal()) {
            setterFieldName = null;
            flags |= 1;
        }
        if (publicField.isBindable()) {
            flags |= 2;
        }
        return new Callable(Callable.Type.FIELD, name, setterFieldName, fieldType, 0, flags, null, publicField.getBindableAnnotation());
    }

    public ModelMethod findInstanceGetter(String name) {
        String[] methodNames;
        String capitalized = StringUtils.capitalize((String)name);
        for (String methodName : methodNames = new String[]{"get" + capitalized, "is" + capitalized, name}) {
            ModelMethod[] methods;
            for (ModelMethod method : methods = this.getMethods(methodName, new ArrayList<ModelClass>(), false, false, false)) {
                if (!method.isPublic() || method.isStatic() || method.getReturnType(Arrays.asList(method.getParameterTypes())).isVoid()) continue;
                return method;
            }
        }
        return null;
    }

    private ModelField getField(String name, boolean allowPrivate, boolean isStatic) {
        ModelField[] fields;
        for (ModelField field : fields = this.getDeclaredFields()) {
            boolean nameMatch;
            boolean bl = nameMatch = name.equals(field.getName()) || name.equals(ModelClass.stripFieldName(field.getName()));
            if (!nameMatch || field.isStatic() != isStatic || !allowPrivate && !field.isPublic()) continue;
            return field;
        }
        return null;
    }

    private ModelMethod findSetter(ModelMethod getter, String originalName) {
        String capitalized = StringUtils.capitalize((String)originalName);
        String[] possibleNames = originalName.equals(getter.getName()) ? new String[]{originalName, "set" + capitalized} : (getter.getName().startsWith("is") ? new String[]{"set" + capitalized, "setIs" + capitalized} : new String[]{"set" + capitalized});
        for (String name : possibleNames) {
            List<ModelMethod> methods = this.findMethods(name, getter.isStatic());
            ModelClass param = getter.getReturnType(null);
            for (ModelMethod method : methods) {
                ModelClass[] parameterTypes = method.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || !parameterTypes[0].equals(param) || method.isStatic() != getter.isStatic()) continue;
                return method;
            }
        }
        return null;
    }

    @NotNull
    public List<ModelMethod> findMethods(String name, boolean staticOnly) {
        ModelMethod[] methods = this.getDeclaredMethods();
        ArrayList<ModelMethod> matching = new ArrayList<ModelMethod>();
        for (ModelMethod method : methods) {
            if (!method.getName().equals(name) || staticOnly && !method.isStatic() || !method.isPublic()) continue;
            matching.add(method);
        }
        return matching;
    }

    public boolean isIncomplete() {
        if (this.isTypeVar() || this.isWildcard()) {
            return true;
        }
        List<ModelClass> typeArgs = this.getTypeArguments();
        if (typeArgs != null) {
            for (ModelClass typeArg : typeArgs) {
                if (!typeArg.isIncomplete()) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract ModelField[] getDeclaredFields();

    protected abstract ModelMethod[] getDeclaredMethods();

    private static String stripFieldName(String fieldName2) {
        char start;
        if (fieldName2.length() > 2) {
            start = fieldName2.charAt(2);
            if (fieldName2.startsWith("m_") && Character.isJavaIdentifierStart(start)) {
                return Character.toLowerCase(start) + fieldName2.substring(3);
            }
        }
        if (fieldName2.length() > 1) {
            start = fieldName2.charAt(1);
            char fieldIdentifier = fieldName2.charAt(0);
            boolean strip = fieldIdentifier == '_' ? true : fieldIdentifier == 'm' && Character.isJavaIdentifierStart(start) && !Character.isLowerCase(start);
            if (strip) {
                return Character.toLowerCase(start) + fieldName2.substring(2);
            }
        }
        return fieldName2;
    }

    public TypeName getTypeName() {
        return ExtKt.toTypeName((String)this.toJavaCode());
    }

    public boolean equals(Object that) {
        if (that instanceof ModelClass) {
            TypeName thisTypeName = this.getTypeName();
            TypeName thatTypeName = ((ModelClass)that).getTypeName();
            return thisTypeName.equals((Object)thatTypeName);
        }
        return false;
    }
}

