/*
 * Decompiled with CFR 0.152.
 */
package android.databinding;

import android.databinding.DataBinderMapper;
import android.databinding.DataBindingComponent;
import android.databinding.ViewDataBinding;
import android.view.View;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MergedDataBinderMapper
extends DataBinderMapper {
    private List<DataBinderMapper> mMappers = new CopyOnWriteArrayList<DataBinderMapper>();
    private List<String> mFeatureBindingMappers = new CopyOnWriteArrayList<String>();

    protected void addMapper(DataBinderMapper mapper) {
        this.mMappers.add(mapper);
    }

    protected void addMapper(String featureMapper) {
        this.mFeatureBindingMappers.add(featureMapper + ".DataBinderMapperImpl");
    }

    @Override
    public ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View view, int layoutId) {
        for (DataBinderMapper mapper : this.mMappers) {
            ViewDataBinding result = mapper.getDataBinder(bindingComponent, view, layoutId);
            if (result == null) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.getDataBinder(bindingComponent, view, layoutId);
        }
        return null;
    }

    @Override
    public ViewDataBinding getDataBinder(DataBindingComponent bindingComponent, View[] view, int layoutId) {
        for (DataBinderMapper mapper : this.mMappers) {
            ViewDataBinding result = mapper.getDataBinder(bindingComponent, view, layoutId);
            if (result == null) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.getDataBinder(bindingComponent, view, layoutId);
        }
        return null;
    }

    @Override
    public int getLayoutId(String tag) {
        for (DataBinderMapper mapper : this.mMappers) {
            int result = mapper.getLayoutId(tag);
            if (result == 0) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.getLayoutId(tag);
        }
        return 0;
    }

    @Override
    public String convertBrIdToString(int id2) {
        for (DataBinderMapper mapper : this.mMappers) {
            String result = mapper.convertBrIdToString(id2);
            if (result == null) continue;
            return result;
        }
        if (this.loadFeatures()) {
            return this.convertBrIdToString(id2);
        }
        return null;
    }

    private boolean loadFeatures() {
        boolean found = false;
        for (String mapper : this.mFeatureBindingMappers) {
            try {
                Class<?> aClass = Class.forName(mapper);
                if (!DataBinderMapper.class.isAssignableFrom(aClass)) continue;
                DataBinderMapper featureMapper = (DataBinderMapper)aClass.newInstance();
                this.addMapper(featureMapper);
                this.mFeatureBindingMappers.remove(mapper);
                found = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        }
        return found;
    }
}

