/*
 * Decompiled with CFR 0.152.
 */
package android.support.customtabs;

import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.customtabs.CustomTabsSessionToken;
import android.support.customtabs.ICustomTabsCallback;
import android.support.customtabs.ICustomTabsService;
import android.support.v4.util.ArrayMap;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class CustomTabsService
extends Service {
    public static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    public static final String KEY_URL = "android.support.customtabs.otherurls.URL";
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILURE_DISALLOWED = -1;
    public static final int RESULT_FAILURE_REMOTE_ERROR = -2;
    public static final int RESULT_FAILURE_MESSAGING_ERROR = -3;
    public static final int RELATION_USE_AS_ORIGIN = 1;
    public static final int RELATION_HANDLE_ALL_URLS = 2;
    private final Map<IBinder, IBinder.DeathRecipient> mDeathRecipientMap = new ArrayMap();
    private ICustomTabsService.Stub mBinder = new ICustomTabsService.Stub(){

        @Override
        public boolean warmup(long flags) {
            return CustomTabsService.this.warmup(flags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean newSession(ICustomTabsCallback callback) {
            final CustomTabsSessionToken sessionToken = new CustomTabsSessionToken(callback);
            try {
                IBinder.DeathRecipient deathRecipient = new IBinder.DeathRecipient(){

                    public void binderDied() {
                        CustomTabsService.this.cleanUpSession(sessionToken);
                    }
                };
                Map map = CustomTabsService.this.mDeathRecipientMap;
                synchronized (map) {
                    callback.asBinder().linkToDeath(deathRecipient, 0);
                    CustomTabsService.this.mDeathRecipientMap.put(callback.asBinder(), deathRecipient);
                }
                return CustomTabsService.this.newSession(sessionToken);
            }
            catch (RemoteException e) {
                return false;
            }
        }

        @Override
        public boolean mayLaunchUrl(ICustomTabsCallback callback, Uri url, Bundle extras, List<Bundle> otherLikelyBundles) {
            return CustomTabsService.this.mayLaunchUrl(new CustomTabsSessionToken(callback), url, extras, otherLikelyBundles);
        }

        @Override
        public Bundle extraCommand(String commandName, Bundle args) {
            return CustomTabsService.this.extraCommand(commandName, args);
        }

        @Override
        public boolean updateVisuals(ICustomTabsCallback callback, Bundle bundle) {
            return CustomTabsService.this.updateVisuals(new CustomTabsSessionToken(callback), bundle);
        }

        @Override
        public boolean requestPostMessageChannel(ICustomTabsCallback callback, Uri postMessageOrigin) {
            return CustomTabsService.this.requestPostMessageChannel(new CustomTabsSessionToken(callback), postMessageOrigin);
        }

        @Override
        public int postMessage(ICustomTabsCallback callback, String message, Bundle extras) {
            return CustomTabsService.this.postMessage(new CustomTabsSessionToken(callback), message, extras);
        }

        @Override
        public boolean validateRelationship(ICustomTabsCallback callback, int relation, Uri origin, Bundle extras) {
            return CustomTabsService.this.validateRelationship(new CustomTabsSessionToken(callback), relation, origin, extras);
        }
    };

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cleanUpSession(CustomTabsSessionToken sessionToken) {
        try {
            Map<IBinder, IBinder.DeathRecipient> map = this.mDeathRecipientMap;
            synchronized (map) {
                IBinder binder = sessionToken.getCallbackBinder();
                IBinder.DeathRecipient deathRecipient = this.mDeathRecipientMap.get(binder);
                binder.unlinkToDeath(deathRecipient, 0);
                this.mDeathRecipientMap.remove(binder);
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    protected abstract boolean warmup(long var1);

    protected abstract boolean newSession(CustomTabsSessionToken var1);

    protected abstract boolean mayLaunchUrl(CustomTabsSessionToken var1, Uri var2, Bundle var3, List<Bundle> var4);

    protected abstract Bundle extraCommand(String var1, Bundle var2);

    protected abstract boolean updateVisuals(CustomTabsSessionToken var1, Bundle var2);

    protected abstract boolean requestPostMessageChannel(CustomTabsSessionToken var1, Uri var2);

    protected abstract int postMessage(CustomTabsSessionToken var1, String var2, Bundle var3);

    protected abstract boolean validateRelationship(CustomTabsSessionToken var1, int var2, Uri var3, Bundle var4);

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Relation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }
}

