/*
 * Decompiled with CFR 0.152.
 */
package android.support.customtabs;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsCallback;
import android.support.customtabs.CustomTabsSession;
import android.support.customtabs.ICustomTabsCallback;
import android.support.v4.app.BundleCompat;
import android.util.Log;

public class CustomTabsSessionToken {
    private static final String TAG = "CustomTabsSessionToken";
    private final ICustomTabsCallback mCallbackBinder;
    private final CustomTabsCallback mCallback;

    public static CustomTabsSessionToken getSessionTokenFromIntent(Intent intent) {
        Bundle b = intent.getExtras();
        IBinder binder = BundleCompat.getBinder((Bundle)b, (String)"android.support.customtabs.extra.SESSION");
        if (binder == null) {
            return null;
        }
        return new CustomTabsSessionToken(ICustomTabsCallback.Stub.asInterface(binder));
    }

    @NonNull
    public static CustomTabsSessionToken createMockSessionTokenForTesting() {
        return new CustomTabsSessionToken(new MockCallback());
    }

    CustomTabsSessionToken(ICustomTabsCallback callbackBinder) {
        this.mCallbackBinder = callbackBinder;
        this.mCallback = new CustomTabsCallback(){

            @Override
            public void onNavigationEvent(int navigationEvent, Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onNavigationEvent(navigationEvent, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void extraCallback(String callbackName, Bundle args) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.extraCallback(callbackName, args);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onMessageChannelReady(Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onMessageChannelReady(extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onPostMessage(String message, Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onPostMessage(message, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }

            @Override
            public void onRelationshipValidationResult(int relation, Uri origin, boolean result, Bundle extras) {
                try {
                    CustomTabsSessionToken.this.mCallbackBinder.onRelationshipValidationResult(relation, origin, result, extras);
                }
                catch (RemoteException e) {
                    Log.e((String)CustomTabsSessionToken.TAG, (String)"RemoteException during ICustomTabsCallback transaction");
                }
            }
        };
    }

    IBinder getCallbackBinder() {
        return this.mCallbackBinder.asBinder();
    }

    public int hashCode() {
        return this.getCallbackBinder().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CustomTabsSessionToken)) {
            return false;
        }
        CustomTabsSessionToken token = (CustomTabsSessionToken)o;
        return token.getCallbackBinder().equals(this.mCallbackBinder.asBinder());
    }

    public CustomTabsCallback getCallback() {
        return this.mCallback;
    }

    public boolean isAssociatedWith(CustomTabsSession session) {
        return session.getBinder().equals(this.mCallbackBinder);
    }

    static class MockCallback
    extends ICustomTabsCallback.Stub {
        MockCallback() {
        }

        @Override
        public void onNavigationEvent(int navigationEvent, Bundle extras) {
        }

        @Override
        public void extraCallback(String callbackName, Bundle args) {
        }

        @Override
        public void onMessageChannelReady(Bundle extras) {
        }

        @Override
        public void onPostMessage(String message, Bundle extras) {
        }

        @Override
        public void onRelationshipValidationResult(int relation, Uri requestedOrigin, boolean result, Bundle extras) {
        }

        @Override
        public IBinder asBinder() {
            return this;
        }
    }
}

