/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v14.preference.SwitchPreference;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceManager;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PreferenceInflater {
    private static final String TAG = "PreferenceInflater";
    private static final Class<?>[] CONSTRUCTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap<String, Constructor> CONSTRUCTOR_MAP = new HashMap();
    private final Context mContext;
    private final Object[] mConstructorArgs = new Object[2];
    private PreferenceManager mPreferenceManager;
    private String[] mDefaultPackages;
    private static final String INTENT_TAG_NAME = "intent";
    private static final String EXTRA_TAG_NAME = "extra";

    public PreferenceInflater(Context context, PreferenceManager preferenceManager) {
        this.mContext = context;
        this.init(preferenceManager);
    }

    private void init(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.setDefaultPackages(new String[]{Preference.class.getPackage().getName() + ".", SwitchPreference.class.getPackage().getName() + "."});
    }

    public void setDefaultPackages(String[] defaultPackage) {
        this.mDefaultPackages = defaultPackage;
    }

    public String[] getDefaultPackages() {
        return this.mDefaultPackages;
    }

    public Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preference inflate(int resource, @Nullable PreferenceGroup root) {
        try (XmlResourceParser parser = this.getContext().getResources().getXml(resource);){
            Preference preference = this.inflate((XmlPullParser)parser, root);
            return preference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preference inflate(XmlPullParser parser, @Nullable PreferenceGroup root) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (this.mConstructorArgs) {
            PreferenceGroup result;
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            this.mConstructorArgs[0] = this.mContext;
            try {
                int type;
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
                }
                Preference xmlRoot = this.createItemFromTag(parser.getName(), attrs);
                result = this.onMergeRoots(root, (PreferenceGroup)xmlRoot);
                this.rInflate(parser, result, attrs);
            }
            catch (InflateException e) {
                throw e;
            }
            catch (XmlPullParserException e) {
                InflateException ex = new InflateException(e.getMessage());
                ex.initCause((Throwable)e);
                throw ex;
            }
            catch (IOException e) {
                InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
                ex.initCause((Throwable)e);
                throw ex;
            }
            return result;
        }
    }

    @NonNull
    private PreferenceGroup onMergeRoots(PreferenceGroup givenRoot, @NonNull PreferenceGroup xmlRoot) {
        if (givenRoot == null) {
            xmlRoot.onAttachedToHierarchy(this.mPreferenceManager);
            return xmlRoot;
        }
        return givenRoot;
    }

    private Preference createItem(@NonNull String name, @Nullable String[] prefixes, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Constructor<?> constructor = CONSTRUCTOR_MAP.get(name);
        try {
            if (constructor == null) {
                ClassLoader classLoader = this.mContext.getClassLoader();
                Class<?> clazz = null;
                if (prefixes == null || prefixes.length == 0) {
                    clazz = classLoader.loadClass(name);
                } else {
                    ClassNotFoundException notFoundException = null;
                    for (String prefix : prefixes) {
                        try {
                            clazz = classLoader.loadClass(prefix + name);
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            notFoundException = e;
                        }
                    }
                    if (clazz == null) {
                        if (notFoundException == null) {
                            throw new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
                        }
                        throw notFoundException;
                    }
                }
                constructor = clazz.getConstructor(CONSTRUCTOR_SIGNATURE);
                constructor.setAccessible(true);
                CONSTRUCTOR_MAP.put(name, constructor);
            }
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            return (Preference)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    protected Preference onCreateItem(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createItem(name, this.mDefaultPackages, attrs);
    }

    private Preference createItemFromTag(String name, AttributeSet attrs) {
        try {
            Preference item = -1 == name.indexOf(46) ? this.onCreateItem(name, attrs) : this.createItem(name, null, attrs);
            return item;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class (not found)" + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    private void rInflate(XmlPullParser parser, Preference parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (INTENT_TAG_NAME.equals(name)) {
                Intent intent;
                try {
                    intent = Intent.parseIntent((Resources)this.getContext().getResources(), (XmlPullParser)parser, (AttributeSet)attrs);
                }
                catch (IOException e) {
                    XmlPullParserException ex = new XmlPullParserException("Error parsing preference");
                    ex.initCause((Throwable)e);
                    throw ex;
                }
                parent.setIntent(intent);
                continue;
            }
            if (EXTRA_TAG_NAME.equals(name)) {
                this.getContext().getResources().parseBundleExtra(EXTRA_TAG_NAME, attrs, parent.getExtras());
                try {
                    PreferenceInflater.skipCurrentTag(parser);
                    continue;
                }
                catch (IOException e) {
                    XmlPullParserException ex = new XmlPullParserException("Error parsing preference");
                    ex.initCause((Throwable)e);
                    throw ex;
                }
            }
            Preference item = this.createItemFromTag(name, attrs);
            ((PreferenceGroup)parent).addItemFromInflater(item);
            this.rInflate(parser, item, attrs);
        }
    }

    private static void skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
        }
    }
}

